/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap items, PdfWriter writer) throws IOException {
        if (items.isEmpty()) {
            return null;
        }
        Object[] names = new String[items.size()];
        names = items.keySet().toArray(names);
        Arrays.sort(names);
        if (names.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k2 = 0;
            while (k2 < names.length) {
                ar.add(new PdfString((String)names[k2], null));
                ar.add((PdfObject)items.get(names[k2]));
                ++k2;
            }
            dic.put(PdfName.NAMES, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(names.length + 64 - 1) / 64];
        int k3 = 0;
        while (k3 < kids.length) {
            int offset = k3 * 64;
            int end = Math.min(offset + 64, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString((String)names[offset], null));
            arr.add(new PdfString((String)names[end - 1], null));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfString((String)names[offset], null));
                arr.add((PdfObject)items.get(names[offset]));
                ++offset;
            }
            dic.put(PdfName.NAMES, arr);
            kids[k3] = writer.addToBody(dic).getIndirectReference();
            ++k3;
        }
        int top = kids.length;
        while (true) {
            int k4;
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                k4 = 0;
                while (k4 < top) {
                    arr.add(kids[k4]);
                    ++k4;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 64) - 1) / skip;
            k4 = 0;
            while (k4 < tt) {
                int offset = k4 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfString((String)names[k4 * skip], null));
                arr.add(new PdfString((String)names[Math.min((k4 + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k4] = writer.addToBody(dic).getIndirectReference();
                ++k4;
            }
            top = tt;
        }
    }

    private static void iterateItems(PdfDictionary dic, HashMap items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NAMES));
                if (nn == null) break block2;
                ArrayList arr = nn.getArrayList();
                int k2 = 0;
                while (k2 < arr.size()) {
                    PdfString s2 = (PdfString)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k2++));
                    items.put(PdfEncodings.convertToString(s2.getBytes(), null), arr.get(k2));
                    ++k2;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            ArrayList arr = nn.getArrayList();
            int k3 = 0;
            while (k3 < arr.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k3));
                PdfNameTree.iterateItems(kid, items);
                ++k3;
            }
        }
    }

    public static HashMap readTree(PdfDictionary dic) {
        HashMap items = new HashMap();
        if (dic != null) {
            PdfNameTree.iterateItems(dic, items);
        }
        return items;
    }
}

