/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList fonts = new ArrayList();

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont bf = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf, font.size(), font.getCalculatedStyle(), font.color());
        this.fonts.add(f2);
    }

    public Phrase process(String text) {
        int fsize = this.fonts.size();
        if (fsize == 0) {
            throw new IndexOutOfBoundsException("No font is defined.");
        }
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Font font = null;
        int lastidx = -1;
        Phrase ret = new Phrase();
        int k2 = 0;
        while (k2 < len) {
            char c2 = cc[k2];
            if (c2 == '\n' || c2 == '\r') {
                sb.append(c2);
            } else {
                int f2 = 0;
                while (f2 < fsize) {
                    font = (Font)this.fonts.get(f2);
                    if (font.getBaseFont().charExists(c2)) {
                        if (lastidx == f2) {
                            sb.append(c2);
                            break;
                        }
                        if (sb.length() > 0 && lastidx != -1) {
                            Chunk ck = new Chunk(sb.toString(), (Font)this.fonts.get(lastidx));
                            ret.add(ck);
                            sb.setLength(0);
                        }
                        sb.append(c2);
                        lastidx = f2;
                        break;
                    }
                    ++f2;
                }
            }
            ++k2;
        }
        if (sb.length() > 0) {
            Chunk ck = new Chunk(sb.toString(), (Font)this.fonts.get(lastidx));
            ret.add(ck);
        }
        return ret;
    }
}

