/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkupParser
extends HashMap {
    private static final long serialVersionUID = 3724008022202507040L;
    protected HashMap stylecache = new HashMap();
    protected HashMap fontcache = new HashMap();
    public static HashMap colorTable = new HashMap();

    static {
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarkupParser(String file) {
        BufferedReader br = null;
        try {
            try {
                StringTokenizer tokenizer;
                FileReader reader = new FileReader(file);
                br = new BufferedReader(reader);
                StringBuffer buf = new StringBuffer();
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        String string = buf.toString();
                        string = MarkupParser.removeComment(string, "/*", "*/");
                        tokenizer = new StringTokenizer(string, "}");
                        break;
                    }
                    buf.append(line.trim());
                }
                while (tokenizer.hasMoreTokens()) {
                    String tmp = tokenizer.nextToken();
                    int pos = tmp.indexOf(123);
                    if (pos <= 0) continue;
                    String selector = tmp.substring(0, pos).trim();
                    String attributes = tmp.substring(pos + 1).trim();
                    if (attributes.endsWith("}")) {
                        attributes = attributes.substring(0, attributes.length() - 1);
                    }
                    this.put(selector, MarkupParser.parseAttributes(attributes));
                }
            }
            catch (Exception e2) {
                throw new ExceptionConverter(e2);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (br == null) return;
        br.close();
    }

    public static String removeComment(String string, String startComment, String endComment) {
        StringBuffer result = new StringBuffer();
        int pos = 0;
        int end = endComment.length();
        int start = string.indexOf(startComment, pos);
        while (start > -1) {
            result.append(string.substring(pos, start));
            pos = string.indexOf(endComment, start) + end;
            start = string.indexOf(startComment, pos);
        }
        result.append(string.substring(pos));
        return result.toString();
    }

    public static Properties parseAttributes(String string) {
        Properties result = new Properties();
        if (string == null) {
            return result;
        }
        StringTokenizer keyValuePairs = new StringTokenizer(string, ";");
        while (keyValuePairs.hasMoreTokens()) {
            StringTokenizer keyValuePair = new StringTokenizer(keyValuePairs.nextToken(), ":");
            if (!keyValuePair.hasMoreTokens()) continue;
            String key = keyValuePair.nextToken().trim();
            if (!keyValuePair.hasMoreTokens()) continue;
            String value = keyValuePair.nextToken().trim();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            result.setProperty(key.toLowerCase(), value);
        }
        return result;
    }

    public static float parseLength(String string) {
        int pos = 0;
        int length = string.length();
        boolean ok = true;
        while (ok && pos < length) {
            switch (string.charAt(pos)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++pos;
                    break;
                }
                default: {
                    ok = false;
                }
            }
        }
        if (pos == 0) {
            return 0.0f;
        }
        if (pos == length) {
            return Float.parseFloat(String.valueOf(string) + "f");
        }
        float f2 = Float.parseFloat(String.valueOf(string.substring(0, pos)) + "f");
        if ((string = string.substring(pos)).startsWith("in")) {
            return f2 * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f2 / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f2 / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f2 * 12.0f;
        }
        return f2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Color decodeColor(String s2) {
        if (s2 == null) {
            return null;
        }
        Color c2 = (Color)colorTable.get(s2 = s2.toLowerCase().trim());
        if (c2 != null) {
            return c2;
        }
        try {
            if (s2.startsWith("#")) {
                if (s2.length() == 4) {
                    s2 = "#" + s2.substring(1, 2) + s2.substring(1, 2) + s2.substring(2, 3) + s2.substring(2, 3) + s2.substring(3, 4) + s2.substring(3, 4);
                }
                if (s2.length() != 7) return null;
                return new Color(Integer.parseInt(s2.substring(1), 16));
            }
            if (!s2.startsWith("rgb")) return null;
            StringTokenizer tk = new StringTokenizer(s2.substring(3), " \t\r\n\f(),");
            int[] cc = new int[3];
            int k2 = 0;
            while (true) {
                float n2;
                if (k2 >= 3) {
                    return new Color(cc[0], cc[1], cc[2]);
                }
                if (!tk.hasMoreTokens()) {
                    return null;
                }
                String t = tk.nextToken();
                if (t.endsWith("%")) {
                    n2 = Float.parseFloat(t.substring(0, t.length() - 1));
                    n2 = n2 * 255.0f / 100.0f;
                } else {
                    n2 = Float.parseFloat(t);
                }
                int ni = (int)n2;
                if (ni > 255) {
                    ni = 255;
                } else if (ni < 0) {
                    ni = 0;
                }
                cc[k2] = ni;
                ++k2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getKey(Properties attributes) {
        String tag = attributes.getProperty("tag");
        String id = attributes.getProperty("id");
        String cl = attributes.getProperty("class");
        id = id == null ? "" : "#" + id;
        cl = cl == null ? "" : "." + cl;
        String key = String.valueOf(tag) + id + cl;
        if (!this.stylecache.containsKey(key) && key.length() > 0) {
            Properties props = new Properties();
            Properties tagprops = (Properties)this.get(tag);
            Properties idprops = (Properties)this.get(id);
            Properties clprops = (Properties)this.get(cl);
            Properties tagidprops = (Properties)this.get(String.valueOf(tag) + id);
            Properties tagclprops = (Properties)this.get(String.valueOf(tag) + cl);
            if (tagprops != null) {
                props.putAll((Map<?, ?>)tagprops);
            }
            if (idprops != null) {
                props.putAll((Map<?, ?>)idprops);
            }
            if (clprops != null) {
                props.putAll((Map<?, ?>)clprops);
            }
            if (tagidprops != null) {
                props.putAll((Map<?, ?>)tagidprops);
            }
            if (tagclprops != null) {
                props.putAll((Map<?, ?>)tagclprops);
            }
            this.stylecache.put(key, props);
        }
        return key;
    }

    public boolean getPageBreakBefore(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        return styleattributes != null && "always".equals(styleattributes.getProperty("page-break-before"));
    }

    public boolean getPageBreakAfter(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        return styleattributes != null && "always".equals(styleattributes.getProperty("page-break-after"));
    }

    public Element getObject(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        if (styleattributes == null) {
            return null;
        }
        if ("hidden".equals(styleattributes.get("visibility"))) {
            return null;
        }
        String display = styleattributes.getProperty("display");
        Element element = null;
        if ("inline".equals(display)) {
            element = this.retrievePhrase(this.getFont(attributes), styleattributes);
        } else if ("block".equals(display)) {
            element = this.retrieveParagraph(this.getFont(attributes), styleattributes);
        } else if ("list-item".equals(display)) {
            element = this.retrieveListItem(this.getFont(attributes), styleattributes);
        } else if ("table-cell".equals(display)) {
            element = this.retrieveTableCell(attributes, styleattributes);
        } else if ("table-row".equals(display)) {
            element = this.retrieveTableRow(attributes, styleattributes);
        } else if ("table".equals(display)) {
            element = this.retrieveTable(attributes, styleattributes);
        }
        return element;
    }

    public Font getFont(Properties attributes) {
        String key = this.getKey(attributes);
        Font f2 = (Font)this.fontcache.get(key);
        if (f2 != null) {
            return f2;
        }
        Properties styleattributes = (Properties)this.stylecache.get(key);
        f2 = this.retrieveFont(styleattributes);
        this.fontcache.put(key, f2);
        return f2;
    }

    public Rectangle getRectangle(Properties attrs) {
        String width = null;
        String height = null;
        String key = this.getKey(attrs);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        if (styleattributes != null) {
            width = styleattributes.getProperty("width");
            height = styleattributes.getProperty("height");
        }
        if (width == null) {
            width = attrs.getProperty("width");
        }
        if (height == null) {
            height = attrs.getProperty("height");
        }
        if (width == null || height == null) {
            return null;
        }
        return new Rectangle(MarkupParser.parseLength(width), MarkupParser.parseLength(height));
    }

    public Element retrievePhrase(Font font, Properties styleattributes) {
        Phrase p2 = new Phrase("", font);
        if (styleattributes == null) {
            return p2;
        }
        String leading = styleattributes.getProperty("line-height");
        if (leading != null) {
            if (leading.endsWith("%")) {
                p2.setLeading(p2.font().size() * (MarkupParser.parseLength(leading) / 100.0f));
            } else {
                p2.setLeading(MarkupParser.parseLength(leading));
            }
        }
        return p2;
    }

    public Element retrieveParagraph(Font font, Properties styleattributes) {
        String align;
        float f2;
        Paragraph p2 = new Paragraph((Phrase)this.retrievePhrase(font, styleattributes));
        if (styleattributes == null) {
            return p2;
        }
        String margin = styleattributes.getProperty("margin");
        if (margin != null) {
            f2 = MarkupParser.parseLength(margin);
            p2.setIndentationLeft(f2);
            p2.setIndentationRight(f2);
            p2.setSpacingBefore(f2);
            p2.setSpacingAfter(f2);
        }
        if ((margin = styleattributes.getProperty("margin-left")) != null) {
            f2 = MarkupParser.parseLength(margin);
            p2.setIndentationLeft(f2);
        }
        if ((margin = styleattributes.getProperty("margin-right")) != null) {
            f2 = MarkupParser.parseLength(margin);
            p2.setIndentationRight(f2);
        }
        if ((margin = styleattributes.getProperty("margin-top")) != null) {
            f2 = MarkupParser.parseLength(margin);
            p2.setSpacingBefore(f2);
        }
        if ((margin = styleattributes.getProperty("margin-bottom")) != null) {
            f2 = MarkupParser.parseLength(margin);
            p2.setSpacingAfter(f2);
        }
        if ("left".equals(align = styleattributes.getProperty("text-align"))) {
            p2.setAlignment(0);
        } else if ("right".equals(align)) {
            p2.setAlignment(2);
        } else if ("center".equals(align)) {
            p2.setAlignment(1);
        } else if ("justify".equals(align)) {
            p2.setAlignment(3);
        }
        return p2;
    }

    private Element retrieveTable(Properties attributes, Properties styleattributes) {
        SimpleTable table = new SimpleTable();
        this.applyBordersColors(table, attributes, styleattributes);
        return table;
    }

    private Element retrieveTableRow(Properties attributes, Properties styleattributes) {
        String padding;
        float f2;
        String margin;
        SimpleCell row = new SimpleCell(true);
        this.applyBordersColors(row, attributes, styleattributes);
        String width = null;
        if (attributes != null) {
            width = attributes.getProperty("width");
        }
        if (width == null) {
            width = styleattributes.getProperty("width");
        }
        if (width != null) {
            if (width.endsWith("%")) {
                row.setWidthpercentage(MarkupParser.parseLength(width));
            } else {
                row.setWidth(MarkupParser.parseLength(width));
            }
        }
        if ((margin = styleattributes.getProperty("margin")) != null) {
            f2 = MarkupParser.parseLength(margin);
            row.setSpacing(f2);
        }
        if ((margin = styleattributes.getProperty("margin-left")) != null) {
            f2 = MarkupParser.parseLength(margin);
            row.setSpacing_left(f2);
        }
        if ((margin = styleattributes.getProperty("margin-right")) != null) {
            f2 = MarkupParser.parseLength(margin);
            row.setSpacing_right(f2);
        }
        if ((margin = styleattributes.getProperty("margin-top")) != null) {
            f2 = MarkupParser.parseLength(margin);
            row.setSpacing_top(f2);
        }
        if ((margin = styleattributes.getProperty("margin-bottom")) != null) {
            f2 = MarkupParser.parseLength(margin);
            row.setSpacing_bottom(f2);
        }
        if ((padding = styleattributes.getProperty("padding")) != null) {
            f2 = MarkupParser.parseLength(padding);
            row.setPadding(f2);
        }
        if ((padding = styleattributes.getProperty("padding-left")) != null) {
            f2 = MarkupParser.parseLength(padding);
            row.setSpacing_left(f2);
        }
        if ((padding = styleattributes.getProperty("padding-right")) != null) {
            f2 = MarkupParser.parseLength(padding);
            row.setSpacing_right(f2);
        }
        if ((padding = styleattributes.getProperty("padding-top")) != null) {
            f2 = MarkupParser.parseLength(padding);
            row.setSpacing_top(f2);
        }
        if ((padding = styleattributes.getProperty("padding-bottom")) != null) {
            f2 = MarkupParser.parseLength(padding);
            row.setSpacing_bottom(f2);
        }
        return row;
    }

    private Element retrieveTableCell(Properties attributes, Properties styleattributes) {
        SimpleCell cell = (SimpleCell)this.retrieveTableRow(attributes, styleattributes);
        cell.setCellgroup(false);
        return cell;
    }

    private Element retrieveListItem(Font font, Properties styleattributes) {
        ListItem li = new ListItem();
        return li;
    }

    private void applyBordersColors(Rectangle rect, Properties attributes, Properties styleattributes) {
        float f2;
        String s2 = styleattributes.getProperty("border-width");
        if (s2 != null) {
            f2 = MarkupParser.parseLength(s2);
            rect.setBorderWidth(f2);
        }
        if ((s2 = styleattributes.getProperty("border-left-width")) != null) {
            f2 = MarkupParser.parseLength(s2);
            rect.setBorderWidthLeft(f2);
        }
        if ((s2 = styleattributes.getProperty("border-right-width")) != null) {
            f2 = MarkupParser.parseLength(s2);
            rect.setBorderWidthRight(f2);
        }
        if ((s2 = styleattributes.getProperty("border-top-width")) != null) {
            f2 = MarkupParser.parseLength(s2);
            rect.setBorderWidthTop(f2);
        }
        if ((s2 = styleattributes.getProperty("border-bottom-width")) != null) {
            f2 = MarkupParser.parseLength(s2);
            rect.setBorderWidthBottom(f2);
        }
        if ((s2 = styleattributes.getProperty("border-color")) != null) {
            rect.setBorderColor(MarkupParser.decodeColor(s2));
        }
    }

    /*
     * Unable to fully structure code
     */
    public Font retrieveFont(Properties styleAttributes) {
        block6: {
            fontname = null;
            encoding = FontFactory.defaultEncoding;
            embedded = FontFactory.defaultEmbedding;
            size = -1.0f;
            style = 0;
            color = null;
            value = (String)styleAttributes.get("font-family");
            if (value == null) break block6;
            if (value.indexOf(44) != -1) ** GOTO lbl17
            fontname = value.trim();
            break block6;
lbl-1000:
            // 1 sources

            {
                tmp = value.substring(0, value.indexOf(44)).trim();
                if (FontFactory.isRegistered(tmp)) {
                    fontname = tmp;
                    break;
                }
                value = value.substring(value.indexOf(44) + 1);
lbl17:
                // 2 sources

                ** while (value.indexOf((int)44) != -1)
            }
        }
        if ((value = (String)styleAttributes.get("font-size")) != null) {
            size = MarkupParser.parseLength(value);
        }
        if ((value = (String)styleAttributes.get("font-weight")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = (String)styleAttributes.get("font-style")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = (String)styleAttributes.get("color")) != null) {
            color = MarkupParser.decodeColor(value);
        }
        return FontFactory.getFont(fontname, encoding, embedded, size, style, color);
    }
}

