/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.SpecialSymbol;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Phrase
extends ArrayList
implements TextElementArray,
MarkupAttributes {
    private static final long serialVersionUID = 2643594602455068231L;
    protected float leading = Float.NaN;
    protected Font font = new Font();
    protected Properties markupAttributes;

    private Phrase(boolean dummy) {
    }

    public Phrase() {
        this(16.0f);
    }

    public Phrase(float leading) {
        this.leading = leading;
    }

    public Phrase(Chunk chunk) {
        super.add(chunk);
        this.font = chunk.font();
    }

    public Phrase(float leading, Chunk chunk) {
        this(leading);
        super.add(chunk);
        this.font = chunk.font();
    }

    public Phrase(String string) {
        this(Float.NaN, string, new Font());
    }

    public Phrase(String string, Font font) {
        this(Float.NaN, string, font);
        this.font = font;
    }

    public Phrase(float leading, String string) {
        this(leading, string, new Font());
    }

    public Phrase(float leading, String string, Font font) {
        this(leading);
        this.font = font;
        if (string != null && string.length() != 0) {
            super.add(new Chunk(string, font));
        }
    }

    public static final Phrase getInstance(String string) {
        return Phrase.getInstance(16, string, new Font());
    }

    public static final Phrase getInstance(int leading, String string) {
        return Phrase.getInstance(leading, string, new Font());
    }

    public static final Phrase getInstance(int leading, String string, Font font) {
        Phrase p2 = new Phrase(true);
        p2.setLeading(leading);
        p2.font = font;
        if (font.family() != 3 && font.family() != 4 && font.getBaseFont() == null) {
            int index;
            while ((index = SpecialSymbol.index(string)) > -1) {
                if (index > 0) {
                    String firstPart = string.substring(0, index);
                    ((ArrayList)p2).add(new Chunk(firstPart, font));
                    string = string.substring(index);
                }
                Font symbol = new Font(3, font.size(), font.style(), font.color());
                StringBuffer buf = new StringBuffer();
                buf.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (SpecialSymbol.index(string) == 0) {
                    buf.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                ((ArrayList)p2).add(new Chunk(buf.toString(), symbol));
            }
        }
        if (string != null && string.length() != 0) {
            ((ArrayList)p2).add(new Chunk(string, font));
        }
        return p2;
    }

    public Phrase(Properties attributes) {
        this("", FontFactory.getFont(attributes));
        this.clear();
        String value = (String)attributes.remove("leading");
        if (value != null) {
            this.setLeading(Float.parseFloat(String.valueOf(value) + "f"));
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength(value));
            }
        }
        value = (String)attributes.remove("itext");
        if (value != null) {
            Chunk chunk = new Chunk(value);
            value = (String)attributes.remove(ElementTags.GENERICTAG);
            if (value != null) {
                chunk.setGenericTag(value);
            }
            this.add(chunk);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public boolean process(ElementListener listener) {
        try {
            Iterator i2 = this.iterator();
            while (i2.hasNext()) {
                listener.add((Element)i2.next());
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public int type() {
        return 11;
    }

    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i2 = this.iterator();
        while (i2.hasNext()) {
            tmp.addAll(((Element)i2.next()).getChunks());
        }
        return tmp;
    }

    public void add(int index, Object o2) {
        block6: {
            if (o2 == null) {
                return;
            }
            try {
                Element element = (Element)o2;
                if (element.type() == 10) {
                    Chunk chunk = (Chunk)element;
                    if (!this.font.isStandardFont()) {
                        chunk.setFont(this.font.difference(chunk.font()));
                    }
                    super.add(index, chunk);
                    break block6;
                }
                if (element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 39) {
                    super.add(index, element);
                    break block6;
                }
                throw new ClassCastException(String.valueOf(element.type()));
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
            }
        }
    }

    public boolean add(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof String) {
            return super.add(new Chunk((String)o2, this.font));
        }
        try {
            Element element = (Element)o2;
            switch (element.type()) {
                case 10: {
                    return this.addChunk((Chunk)o2);
                }
                case 11: 
                case 12: {
                    Phrase phrase = (Phrase)o2;
                    boolean success = true;
                    Iterator i2 = phrase.iterator();
                    while (i2.hasNext()) {
                        Element e2 = (Element)i2.next();
                        if (e2 instanceof Chunk) {
                            success &= this.addChunk((Chunk)e2);
                            continue;
                        }
                        success &= this.add(e2);
                    }
                    return success;
                }
                case 14: 
                case 17: 
                case 22: 
                case 23: 
                case 29: 
                case 39: {
                    return super.add(o2);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Insertion of illegal Element: " + cce.getMessage());
        }
    }

    private synchronized boolean addChunk(Chunk chunk) {
        if (!this.font.isStandardFont()) {
            chunk.setFont(this.font.difference(chunk.font()));
        }
        if (this.size() > 0 && !chunk.hasAttributes()) {
            try {
                Chunk previous = (Chunk)this.get(this.size() - 1);
                if (!(previous.hasAttributes() || previous.font().compareTo(chunk.font()) != 0 || "".equals(previous.content().trim()) || "".equals(chunk.content().trim()))) {
                    previous.append(chunk.content());
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return super.add(chunk);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    protected void addSpecial(Object object) {
        super.add(object);
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public boolean leadingDefined() {
        return !Float.isNaN(this.leading);
    }

    public float leading() {
        if (Float.isNaN(this.leading)) {
            return this.font.leading(1.5f);
        }
        return this.leading;
    }

    public Font font() {
        return this.font;
    }

    public String content() {
        StringBuffer buf = new StringBuffer();
        Iterator i2 = this.getChunks().iterator();
        while (i2.hasNext()) {
            buf.append(i2.next().toString());
        }
        return buf.toString();
    }

    public static boolean isTag(String tag) {
        return "phrase".equals(tag);
    }

    public void setMarkupAttribute(String name, String value) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(name, value);
    }

    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

