/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.IOException;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERBMPString.getInstance(obj.getObject());
    }

    public DERBMPString(byte[] string) {
        char[] cs = new char[string.length / 2];
        int i2 = 0;
        while (i2 != cs.length) {
            cs[i2] = (char)(string[2 * i2] << 8 | string[2 * i2 + 1] & 0xFF);
            ++i2;
        }
        this.string = new String(cs);
    }

    public DERBMPString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof DERBMPString)) {
            return false;
        }
        DERBMPString s2 = (DERBMPString)o2;
        return this.getString().equals(s2.getString());
    }

    void encode(DEROutputStream out) throws IOException {
        char[] c2 = this.string.toCharArray();
        byte[] b2 = new byte[c2.length * 2];
        int i2 = 0;
        while (i2 != c2.length) {
            b2[2 * i2] = (byte)(c2[i2] >> 8);
            b2[2 * i2 + 1] = (byte)c2[i2];
            ++i2;
        }
        out.writeEncoded(30, b2);
    }
}

