/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.vecmath;

import com.jhlabs.vecmath.Tuple4f;

public class Point4f
extends Tuple4f {
    public Point4f() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Point4f(float[] x) {
        this.x = x[0];
        this.y = x[1];
        this.z = x[2];
        this.w = x[3];
    }

    public Point4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Point4f(Point4f t) {
        this.x = t.x;
        this.y = t.y;
        this.z = t.z;
        this.w = t.w;
    }

    public Point4f(Tuple4f t) {
        this.x = t.x;
        this.y = t.y;
        this.z = t.z;
        this.w = t.w;
    }

    public float distanceL1(Point4f p2) {
        return Math.abs(this.x - p2.x) + Math.abs(this.y - p2.y) + Math.abs(this.z - p2.z) + Math.abs(this.w - p2.w);
    }

    public float distanceSquared(Point4f p2) {
        float dx = this.x - p2.x;
        float dy = this.y - p2.y;
        float dz = this.z - p2.z;
        float dw = this.w - p2.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public float distance(Point4f p2) {
        float dx = this.x - p2.x;
        float dy = this.y - p2.y;
        float dz = this.z - p2.z;
        float dw = this.w - p2.w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }
}

