/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;
import java.io.Serializable;

public class PosterizeFilter
extends PointFilter
implements Serializable {
    private int numLevels;
    private int[] levels;
    private boolean initialized = false;

    public PosterizeFilter() {
        this.setNumLevels(6);
    }

    public void setNumLevels(int numLevels) {
        this.numLevels = numLevels;
        this.initialized = false;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    protected void initialize() {
        this.levels = new int[256];
        if (this.numLevels != 1) {
            for (int i2 = 0; i2 < 256; ++i2) {
                this.levels[i2] = 255 * (this.numLevels * i2 / 256) / (this.numLevels - 1);
            }
        }
    }

    public int filterRGB(int x, int y, int rgb) {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        int a2 = rgb & 0xFF000000;
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        r2 = this.levels[r2];
        g2 = this.levels[g2];
        b2 = this.levels[b2];
        return a2 | r2 << 16 | g2 << 8 | b2;
    }

    public String toString() {
        return "Colors/Posterize...";
    }
}

