/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class DiffuseFilter
extends TransformFilter {
    public float[] sinTable;
    public float[] cosTable;
    public float scale = 4.0f;

    public DiffuseFilter() {
        this.setEdgeAction(1);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    protected void transformInverse(int x, int y, float[] out) {
        int angle = (int)(Math.random() * 255.0);
        float distance = (float)Math.random();
        out[0] = (float)x + distance * this.sinTable[angle];
        out[1] = (float)y + distance * this.cosTable[angle];
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.sinTable = new float[256];
        this.cosTable = new float[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            float angle = (float)Math.PI * 2 * (float)i2 / 256.0f;
            this.sinTable[i2] = (float)((double)this.scale * Math.sin(angle));
            this.cosTable[i2] = (float)((double)this.scale * Math.cos(angle));
        }
        return super.filter(src, dst);
    }

    public String toString() {
        return "Distort/Diffuse...";
    }
}

