/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class ContourFilter
extends WholeImageFilter {
    private float levels = 5.0f;
    private float scale = 1.0f;
    private float offset = 0.0f;
    private int contourColor = -16777216;

    public void setLevels(float levels) {
        this.levels = levels;
    }

    public float getLevels() {
        return this.levels;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getOffset() {
        return this.offset;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        short[][] r2 = new short[3][width];
        int[] outPixels = new int[width * height];
        short[] table = new short[256];
        int offsetl = (int)(this.offset * 256.0f / this.levels);
        for (int i2 = 0; i2 < 256; ++i2) {
            table[i2] = (short)PixelUtils.clamp((int)(255.0 * Math.floor(this.levels * (float)(i2 + offsetl) / 256.0f) / (double)(this.levels - 1.0f) - (double)offsetl));
        }
        for (int x = 0; x < width; ++x) {
            int rgb = inPixels[x];
            r2[1][x] = (short)PixelUtils.brightness(rgb);
        }
        for (int y = 0; y < height; ++y) {
            int x;
            boolean yIn = y > 0 && y < height - 1;
            int nextRowIndex = index + width;
            if (y < height - 1) {
                for (x = 0; x < width; ++x) {
                    int rgb = inPixels[nextRowIndex++];
                    r2[2][x] = (short)PixelUtils.brightness(rgb);
                }
            }
            for (x = 0; x < width; ++x) {
                boolean xIn = x > 0 && x < width - 1;
                int w = x - 1;
                int e2 = x + 1;
                int v = 0;
                if (yIn && xIn) {
                    short nwb = r2[0][w];
                    short neb = r2[0][x];
                    short swb = r2[1][w];
                    short seb = r2[1][x];
                    short nw = table[nwb];
                    short ne = table[neb];
                    short sw = table[swb];
                    short se = table[seb];
                    if ((nw != ne || nw != sw || ne != se || sw != se) && (v = (int)(this.scale * (float)(Math.abs(nwb - neb) + Math.abs(nwb - swb) + Math.abs(neb - seb) + Math.abs(swb - seb)))) > 255) {
                        v = 255;
                    }
                }
                outPixels[index] = v != 0 ? PixelUtils.combinePixels(inPixels[index], this.contourColor, 1, v) : inPixels[index];
                ++index;
            }
            short[] t = r2[0];
            r2[0] = r2[1];
            r2[1] = r2[2];
            r2[2] = t;
        }
        return outPixels;
    }

    public String toString() {
        return "Stylize/Contour...";
    }
}

