/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.RGBComposite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class HardLightComposite
extends RGBComposite {
    public HardLightComposite(float alpha) {
        super(alpha);
    }

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new Context(this.extraAlpha, srcColorModel, dstColorModel);
    }

    static class Context
    extends RGBComposite.RGBCompositeContext {
        public Context(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            super(alpha, srcColorModel, dstColorModel);
        }

        public void composeRGB(int[] src, int[] dst, float alpha) {
            int w = src.length;
            for (int i2 = 0; i2 < w; i2 += 4) {
                int sr = src[i2];
                int dir = dst[i2];
                int sg = src[i2 + 1];
                int dig = dst[i2 + 1];
                int sb = src[i2 + 2];
                int dib = dst[i2 + 2];
                int sa = src[i2 + 3];
                int dia = dst[i2 + 3];
                int dor = sr > 127 ? 255 - 2 * Context.multiply255(255 - sr, 255 - dir) : 2 * Context.multiply255(sr, dir);
                int dog = sg > 127 ? 255 - 2 * Context.multiply255(255 - sg, 255 - dig) : 2 * Context.multiply255(sg, dig);
                int dob = sb > 127 ? 255 - 2 * Context.multiply255(255 - sb, 255 - dib) : 2 * Context.multiply255(sb, dib);
                float a2 = alpha * (float)sa / 255.0f;
                float ac = 1.0f - a2;
                dst[i2] = (int)(a2 * (float)dor + ac * (float)dir);
                dst[i2 + 1] = (int)(a2 * (float)dog + ac * (float)dig);
                dst[i2 + 2] = (int)(a2 * (float)dob + ac * (float)dib);
                dst[i2 + 3] = (int)((float)sa * alpha + (float)dia * ac);
            }
        }
    }
}

