/*
 * Decompiled with CFR 0.152.
 */
package jecomics.JECEngine;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class JECImageInfo {
    static final int BUFFSIZE = 51200;
    static final int UNKNOWNTYPE = -1;
    static final int JPEG = 0;
    static final int PNG = 1;
    private int type = -1;
    private int width = -1;
    private int height = -1;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isKnown() {
        return this.type != -1;
    }

    protected void assignImage(BufferedInputStream stream, String Filename) {
        this.type = -1;
        byte[] buff = null;
        this.width = -1;
        this.height = -1;
        buff = stream == null ? this.readBlock(Filename) : this.readBlock(stream);
        String fn = Filename.toLowerCase();
        if (fn.endsWith(".jpg") || fn.endsWith(".jpeg")) {
            if (this.getImageSize(buff, 0)) {
                this.type = 0;
            }
        } else if (fn.endsWith(".png")) {
            if (this.getImageSize(buff, 1)) {
                this.type = 1;
            }
        } else {
            this.type = -1;
        }
    }

    private byte[] readBlock(BufferedInputStream stream) {
        DataInputStream dis = null;
        byte[] buff = new byte[51200];
        try {
            dis = new DataInputStream(stream);
            dis.read(buff);
            dis.close();
            return buff;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private byte[] readBlock(String Filename) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] buff = null;
        try {
            fis = new FileInputStream(Filename);
            bis = new BufferedInputStream(fis);
            buff = this.readBlock(bis);
            fis.close();
            bis.close();
            return buff;
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return null;
        }
    }

    public static int b2int(byte b2) {
        int k2 = b2 & 0xFF;
        return k2;
    }

    private int seek(byte what, byte[] source) {
        for (int k2 = 0; k2 < source.length; ++k2) {
            if (source[k2] != what) continue;
            return k2;
        }
        return -1;
    }

    public static boolean checkSig(byte[] source, int offset, byte[] sig) {
        if (offset + sig.length < source.length) {
            for (int i2 = 0; i2 < sig.length; ++i2) {
                if (sig[i2] == source[i2 + offset]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean getImageSizeJPG(byte[] buff) {
        byte b2 = 0;
        byte[] ValidSig = new byte[]{-1, -40};
        byte[] Parameterless = new byte[]{1, -48, -47, -46, -45, -44, -43, -42, -41};
        if (JECImageInfo.checkSig(buff, 0, ValidSig)) {
            for (int i2 = 2; i2 < buff.length; ++i2) {
                int g2;
                while (buff[i2] == -1) {
                    ++i2;
                }
                b2 = buff[i2];
                if (b2 == -64 || b2 == -63) {
                    int w;
                    int h2 = (JECImageInfo.b2int(buff[(i2 += 3) + 1]) << 8) + JECImageInfo.b2int(buff[i2 + 2]);
                    this.width = w = (JECImageInfo.b2int(buff[i2 + 3]) << 8) + JECImageInfo.b2int(buff[i2 + 4]);
                    this.height = h2;
                    return true;
                }
                int p2 = 0;
                p2 = this.seek(b2, Parameterless);
                if (p2 != -1 || (g2 = (JECImageInfo.b2int(buff[i2 + 1]) << 8) + JECImageInfo.b2int(buff[i2 + 2])) <= 0) continue;
                i2 += g2;
            }
            return false;
        }
        return false;
    }

    protected boolean getImageSizePNG(byte[] buff) {
        boolean b2 = false;
        byte[] ValidSig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (JECImageInfo.checkSig(buff, 0, ValidSig)) {
            int i2 = 0;
            i2 = 18;
            int w = (JECImageInfo.b2int(buff[i2]) << 8) + JECImageInfo.b2int(buff[i2 + 1]);
            i2 = 22;
            int h2 = (JECImageInfo.b2int(buff[i2]) << 8) + JECImageInfo.b2int(buff[i2 + 1]);
            this.width = w;
            this.height = h2;
            return true;
        }
        return false;
    }

    protected boolean getImageSize(byte[] buff, int atype) {
        switch (atype) {
            case 0: {
                return this.getImageSizeJPG(buff);
            }
            case 1: {
                return this.getImageSizePNG(buff);
            }
        }
        return false;
    }

    public JECImageInfo(String Filename) {
        this.assignImage(null, Filename);
    }

    public JECImageInfo(BufferedInputStream stream, String Filename) {
        this.assignImage(stream, Filename);
    }
}

