/*
 * Decompiled with CFR 0.152.
 */
package jecomics.JECEngine;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import jecomics.JECEngine.JECCallBack;
import jecomics.JECEngine.JECImage;
import jecomics.JECEngine.JECImageFilters;
import jecomics.JECEngine.JECImageProcessor;
import jecomics.JECEngine.JECImagesList;
import jecomics.JECEngine.JECOutputType;

public class JECComicProject {
    protected static final String EngineShortVersion = "v0.8.6";
    protected static final String EngineVersion = "v0.8.6 $Revision: 1.48 $";
    private JECCallBack CB;
    private String title = "";
    private String author = "";
    private JECOutputType ot = null;
    private boolean lossless = false;
    private int brightness = 0;
    private int contrast = 0;
    private boolean sharpening = false;
    private boolean diffusion = false;
    private boolean smooth = false;
    private boolean mangamode = false;
    private JECImagesList Images = new JECImagesList();

    public static String getEngineVersion() {
        return new String(EngineVersion);
    }

    public static String getEngineShortVersion() {
        return new String(EngineShortVersion);
    }

    public void setMangaMode(boolean n2) {
        this.mangamode = n2;
    }

    public boolean getMangaMode() {
        return this.mangamode;
    }

    public void setLossless(boolean n2) {
        this.lossless = n2;
    }

    public boolean getLossless() {
        return this.lossless;
    }

    public void setBrightness(int n2) {
        if (n2 > 10) {
            n2 = 10;
        }
        if (n2 < -10) {
            n2 = -10;
        }
        this.brightness = n2;
    }

    public int geBrightness() {
        return this.brightness;
    }

    public void setContrast(int n2) {
        if (n2 > 3) {
            n2 = 3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.contrast = n2;
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setSmartSmooth(boolean n2) {
        this.smooth = n2;
    }

    public boolean getSmartSmooth() {
        return this.smooth;
    }

    public void setErrorDiffusion(boolean n2) {
        this.diffusion = n2;
    }

    public boolean getErrorDiffusion() {
        return this.diffusion;
    }

    public void setSharpening(boolean n2) {
        this.sharpening = n2;
    }

    public boolean getSharpening() {
        return this.sharpening;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String ntitle) {
        this.title = "" + ntitle;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String n2) {
        this.author = "" + n2;
    }

    public JECImagesList getImages() {
        return this.Images;
    }

    public void setOutputType(JECOutputType o2) {
        this.ot = o2;
    }

    public JECOutputType getOutputType() {
        return this.ot;
    }

    private void addImage2Document(JECImageProcessor Processor, BufferedImage source, Document document, boolean hasnext) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Processor.doProcess(source, os);
        Image I = Image.getInstance(os.toByteArray());
        I.setAbsolutePosition(0.0f, 0.0f);
        I.scaleToFit(this.ot.getMediaBoxWidth(), this.ot.getMediaBoxHeight());
        document.add(I);
        if (hasnext) {
            document.newPage();
        }
    }

    private JECImageProcessor generateProcessor() {
        float brg;
        JECImageProcessor Processor = new JECImageProcessor(this.ot);
        Processor.setLossless(this.lossless);
        switch (this.contrast) {
            case 1: {
                Processor.contrast = 1.05f;
                break;
            }
            case 2: {
                Processor.contrast = 1.1f;
                break;
            }
            case 3: {
                Processor.contrast = 1.15f;
                break;
            }
            default: {
                Processor.contrast = 1.0f;
            }
        }
        Processor.brightness = brg = 1.0f + (float)this.brightness * 0.02f;
        Processor.sharpening = this.getSharpening();
        Processor.smartSmooth = this.getSmartSmooth();
        Processor.errorDiffusion = this.getErrorDiffusion();
        return Processor;
    }

    public BufferedImage generatePreview(JECImage input) {
        Object appo = null;
        JECImageProcessor Processor = this.generateProcessor();
        try {
            BufferedImage source = input.getImage();
            if (input.getRotateLeft()) {
                source = JECImageFilters.rotateImage(source, false);
            } else if (input.getRotateRight()) {
                source = JECImageFilters.rotateImage(source, true);
            }
            if (input.getSplit()) {
                BufferedImage A = JECImageFilters.split(source, false);
                return Processor.doProcess(A);
            }
            return Processor.doProcess(source);
        }
        catch (Exception EX) {
            this.CB.addMessage(EX.getMessage());
            return null;
        }
    }

    public void generate(String OutputFile) {
        long starttime = System.currentTimeMillis();
        this.CB.setInfoBox("Working...");
        Rectangle pageSize = new Rectangle(this.ot.getMediaBoxWidth(), this.ot.getMediaBoxHeight());
        pageSize.setBackgroundColor(new Color(255, 255, 255));
        Document document = new Document(pageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        document.setHeader(null);
        document.setFooter(null);
        try {
            PdfWriter p2 = PdfWriter.getInstance(document, new FileOutputStream(OutputFile));
            document.addTitle(this.title);
            document.addAuthor(this.author);
            document.addCreator("JE-Comics v0.8.6 output for " + this.ot.getTypeName());
            document.open();
            if (!document.setMargins(0.0f, 0.0f, 0.0f, 0.0f)) {
                System.out.println("Setmargins fail!");
            }
            JECImageProcessor Processor = this.generateProcessor();
            Iterator i2 = this.getImages().iterator();
            int count = 0;
            int total = this.getImages().size();
            this.CB.addMessage("Generating output for: " + this.ot.getTypeName());
            while (i2.hasNext()) {
                long imagetime = System.currentTimeMillis();
                try {
                    JECImage input = (JECImage)i2.next();
                    BufferedImage source = input.getImage();
                    if (input.getRotateLeft()) {
                        source = JECImageFilters.rotateImage(source, false);
                    } else if (input.getRotateRight()) {
                        source = JECImageFilters.rotateImage(source, true);
                    }
                    if (input.getSplit()) {
                        BufferedImage A = JECImageFilters.split(source, !this.getMangaMode());
                        BufferedImage B = JECImageFilters.split(source, this.getMangaMode());
                        this.addImage2Document(Processor, A, document, true);
                        this.addImage2Document(Processor, B, document, i2.hasNext());
                    } else {
                        this.addImage2Document(Processor, source, document, i2.hasNext());
                    }
                    this.CB.setProgress(100 * ++count / total);
                    if (count > 2) {
                        long elapsed = (System.currentTimeMillis() - starttime) / 1000L;
                        long remaining = (long)(total - count) * elapsed / (long)count;
                        if (remaining < 60L) {
                            this.CB.setInfoBox("R.Time: <1m");
                        } else {
                            long M = remaining / 60L;
                            this.CB.setInfoBox("R.Time: ~" + M + "m");
                        }
                    }
                    this.CB.addMessage("Image '" + input.getFileName() + "' processed in:" + (System.currentTimeMillis() - imagetime) / 1000L + "s");
                }
                catch (Exception E) {
                    this.CB.addMessage("Exception:" + E.toString());
                    System.out.println("Exception:" + E.toString());
                    E.printStackTrace();
                    document.close();
                    this.CB.setInfoBox("Error!");
                    this.CB.Done();
                }
            }
        }
        catch (Exception E) {
            System.out.println("Exception:" + E.toString());
            E.printStackTrace();
        }
        document.close();
        this.CB.addMessage("Total Processing time:" + (System.currentTimeMillis() - starttime) / 1000L + "s");
        this.CB.setInfoBox("Done");
        this.CB.Done();
    }

    public JECComicProject(JECCallBack _CB) {
        this.CB = _CB;
        System.out.println("Comic Project manager $Revision: 1.48 $");
    }
}

