/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.CRCInputStream;
import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import com.sixlegs.image.png.PngImage;
import java.io.IOException;
import java.io.InputStream;

final class IDATInputStream
extends InputStream {
    private static final int[] signature = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private InputStream in_raw;
    private CRCInputStream in_crc;
    private ExDataInputStream in_data;
    private PngImage img;
    private Chunk cur;
    private int chunk_left;
    private boolean close;
    private byte[] _b = new byte[1];

    public IDATInputStream(PngImage pngImage, InputStream inputStream, boolean bl) {
        this.img = pngImage;
        this.in_raw = inputStream;
        this.close = bl;
        this.in_crc = new CRCInputStream(inputStream);
        this.in_data = new ExDataInputStream(this.in_crc);
    }

    void readToData() throws IOException {
        if (this.cur != null) {
            return;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = this.in_data.readUnsignedByte();
            if (n2 == signature[i2]) continue;
            throw new PngException("Improper signature, byte " + i2 + " should be 0x" + Integer.toHexString(signature[i2]) + " but is 0x" + Integer.toHexString(n2));
        }
        try {
            if (this.getNextChunk().type != Chunk.IHDR) {
                throw new PngException("IHDR chunk must be first chunk");
            }
            while (this.getNextChunk().type != Chunk.IDAT) {
            }
            if (this.img.data.palette == null && this.img.data.header.paletteUsed) {
                throw new PngException("Required PLTE chunk not found");
            }
            this.img.fillGammaTable();
        }
        catch (NullPointerException nullPointerException) {
            throw new PngException("Can't find data chunk");
        }
    }

    int count() {
        return this.in_crc.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunk(Chunk chunk) throws IOException {
        block8: {
            try {
                if (!chunk.multipleOK() && this.img.getChunk(chunk.type) != null) {
                    String string = "Multiple " + Chunk.typeToString(chunk.type) + " chunks are not allowed";
                    if (chunk.isAncillary()) {
                        throw new PngExceptionSoft(string);
                    }
                    throw new PngException(string);
                }
                chunk.readData();
                this.img.putChunk(chunk.type, chunk);
            }
            catch (PngExceptionSoft pngExceptionSoft) {
                if (PngImage.allFatal) {
                    throw pngExceptionSoft;
                }
                this.img.addError(pngExceptionSoft);
            }
            finally {
                this.in_data.skipBytes(chunk.bytesRemaining());
                long l2 = this.in_crc.getValue();
                long l3 = this.in_data.readUnsignedInt();
                if (l2 == l3) break block8;
                throw new PngException("Bad CRC value for " + Chunk.typeToString(chunk.type) + " chunk");
            }
        }
    }

    private Chunk getNextChunk() throws IOException {
        if (this.cur != null) {
            this.readChunk(this.cur);
            if (this.cur.type == Chunk.IEND) {
                return null;
            }
        }
        this.chunk_left = this.in_data.readInt();
        this.in_crc.reset();
        int n2 = this.in_data.readInt();
        if (this.chunk_left < 0) {
            throw new PngException("Bad " + Chunk.typeToString(n2) + " chunk length: " + ExDataInputStream.unsign(this.chunk_left));
        }
        this.cur = PngImage.getRegisteredChunk(n2);
        this.cur.img = this.img;
        this.cur.length = this.chunk_left;
        this.cur.in_data = this.in_data;
        if (this.cur.isUnknown()) {
            String string = Chunk.typeToString(n2);
            if (!this.cur.isAncillary()) {
                throw new PngException("Private critical chunk encountered: " + string);
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 >= 'A' && (c2 <= 'Z' || c2 >= 'a') && c2 <= 'z') continue;
                throw new PngException("Corrupted chunk type: " + string);
            }
        }
        return this.cur;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.cur == null) {
            this.readToData();
        }
        if (this.chunk_left == 0) {
            return -1;
        }
        int n4 = this.chunk_left < n3 ? this.chunk_left : n3;
        this.in_data.readFully(byArray, n2, n4);
        this.chunk_left -= n4;
        if (this.chunk_left == 0 && this.getNextChunk().type != Chunk.IDAT) {
            Chunk chunk;
            while ((chunk = this.getNextChunk()) != null) {
                if (!chunk.beforeIDAT()) continue;
                throw new PngException(Chunk.typeToString(chunk.type) + " chunk must precede first IDAT chunk");
            }
            if (this.close) {
                this.close();
            }
        }
        return n4;
    }

    public int read() throws IOException {
        return this.read(this._b, 0, 1) > 0 ? this._b[0] & 0xFF : -1;
    }

    public void close() throws IOException {
        this.in_data.close();
    }
}

