/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.Chunk_PLTE;
import com.sixlegs.image.png.PngException;
import java.awt.Color;
import java.io.IOException;

final class Chunk_tRNS
extends Chunk {
    int rgb;
    int rgb_low;
    int r;
    int g;
    int b;

    Chunk_tRNS() {
        super(Chunk.tRNS);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int n2 = this.img.data.header.outputDepth;
        switch (this.img.data.header.colorType) {
            case 0: {
                if (this.length != 2) {
                    this.badLength(2);
                }
                if (this.img.data.header.depth == 16) {
                    this.g = this.b = this.in_data.readUnsignedByte();
                    this.r = this.b;
                    int n3 = this.in_data.readUnsignedByte();
                    this.img.data.properties.put("transparency low bytes", new Color(n3, n3, n3));
                } else {
                    this.g = this.b = this.in_data.readUnsignedShort();
                    this.r = this.b;
                }
                this.rgb = this.r | this.r << n2 | this.r << n2 * 2;
                this.img.data.header.model = this.img.data.header.alphaModel;
                this.img.data.properties.put("transparency", new Color(this.r, this.g, this.b));
                break;
            }
            case 2: {
                if (this.length != 6) {
                    this.badLength(6);
                }
                if (this.img.data.header.depth == 16) {
                    this.r = this.in_data.readUnsignedByte();
                    int n4 = this.in_data.readUnsignedByte();
                    this.g = this.in_data.readUnsignedByte();
                    int n5 = this.in_data.readUnsignedByte();
                    this.b = this.in_data.readUnsignedByte();
                    int n6 = this.in_data.readUnsignedByte();
                    this.rgb_low = n6 | n5 << 8 | n4 << 16;
                    this.img.data.properties.put("transparency low bytes", new Color(n4, n5, n6));
                } else {
                    this.r = this.in_data.readUnsignedShort();
                    this.g = this.in_data.readUnsignedShort();
                    this.b = this.in_data.readUnsignedShort();
                }
                this.rgb = this.b | this.g << n2 | this.r << n2 * 2;
                this.img.data.header.model = this.img.data.header.alphaModel;
                this.img.data.properties.put("transparency", new Color(this.r, this.g, this.b));
                break;
            }
            case 3: {
                int n7;
                if (this.img.data.palette == null) {
                    throw new PngException("tRNS chunk must follow PLTE chunk");
                }
                Chunk_PLTE chunk_PLTE = this.img.data.palette;
                int n8 = chunk_PLTE.r.length;
                if (this.length > n8) {
                    this.badLength();
                }
                chunk_PLTE.a_raw = new int[n8];
                chunk_PLTE.a = new byte[n8];
                for (n7 = 0; n7 < this.length; ++n7) {
                    chunk_PLTE.a_raw[n7] = this.in_data.readUnsignedByte();
                    chunk_PLTE.a[n7] = (byte)chunk_PLTE.a_raw[n7];
                }
                while (n7 < n8) {
                    chunk_PLTE.a_raw[n7] = 255;
                    chunk_PLTE.a[n7] = (byte)255;
                    ++n7;
                }
                this.img.data.properties.put("transparency size", new Integer(this.length));
                chunk_PLTE.updateProperties(true);
                break;
            }
            default: {
                throw new PngException("tRNS prohibited for color type " + this.img.data.header.colorType);
            }
        }
    }
}

