/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.KeyValueChunk;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sPLT
extends Chunk {
    Chunk_sPLT() {
        super(Chunk.sPLT);
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int[][] nArray;
        String string = this.in_data.readString();
        if (string.length() > 79) {
            throw new PngExceptionSoft("sPLT palette name too long");
        }
        if (this.img.data.palettes.containsKey(string = KeyValueChunk.repairKey(string))) {
            throw new PngExceptionSoft("Duplicate sPLT names");
        }
        int n2 = this.in_data.readUnsignedByte();
        int n3 = this.length - string.length();
        if (n2 == 8) {
            if (n3 % 6 != 0) {
                this.badLength();
            }
            int n4 = n3 / 6;
            nArray = new int[5][n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                nArray[0][i2] = this.in_data.readUnsignedByte();
                nArray[1][i2] = this.in_data.readUnsignedByte();
                nArray[2][i2] = this.in_data.readUnsignedByte();
                nArray[3][i2] = this.in_data.readUnsignedByte();
                nArray[4][i2] = this.in_data.readUnsignedShort();
            }
        } else if (n2 == 16) {
            if (n3 % 10 != 0) {
                this.badLength();
            }
            int n5 = n3 / 10;
            nArray = new int[5][n5];
            for (int i3 = 0; i3 < n5; ++i3) {
                nArray[0][i3] = this.in_data.readUnsignedShort();
                nArray[1][i3] = this.in_data.readUnsignedShort();
                nArray[2][i3] = this.in_data.readUnsignedShort();
                nArray[3][i3] = this.in_data.readUnsignedShort();
                nArray[4][i3] = this.in_data.readUnsignedShort();
            }
        } else {
            throw new PngExceptionSoft("Bad sPLT sample depth: " + n2);
        }
        this.img.data.palettes.put(string, nArray);
    }
}

