/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.KeyValueChunk;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_pCAL
extends Chunk {
    Chunk_pCAL() {
        super(Chunk.pCAL);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        String string = this.in_data.readString();
        if (string.length() > 79) {
            throw new PngExceptionSoft("pCAL purpose too long");
        }
        string = KeyValueChunk.repairKey(string);
        int n2 = this.in_data.readInt();
        int n3 = this.in_data.readInt();
        if (n3 == n2) {
            throw new PngExceptionSoft("X1 == X0 in pCAL chunk");
        }
        int n4 = this.in_data.readUnsignedByte();
        int n5 = this.in_data.readUnsignedByte();
        String string2 = this.in_data.readString();
        if (string2.length() > 79) {
            throw new PngExceptionSoft("pCAL unit string too long");
        }
        double[] dArray = new double[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            dArray[i2] = this.in_data.readFloatingPoint();
        }
        this.img.data.properties.put("pixel calibration purpose", string);
        this.img.data.properties.put("pixel calibration x0", new Integer(n2));
        this.img.data.properties.put("pixel calibration x1", new Integer(n3));
        this.img.data.properties.put("pixel calibration type", new Integer(n4));
        this.img.data.properties.put("pixel calibration n", new Integer(n5));
        this.img.data.properties.put("pixel calibration unit", string2);
        this.img.data.properties.put("pixel calibration parameters", dArray);
    }
}

