/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import java.awt.image.IndexColorModel;
import java.io.IOException;

final class Chunk_PLTE
extends Chunk {
    private int size;
    int[] r_raw;
    int[] g_raw;
    int[] b_raw;
    int[] a_raw;
    byte[] r;
    byte[] g;
    byte[] b;
    byte[] a;

    Chunk_PLTE() {
        super(Chunk.PLTE);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        this.img.data.palette = this;
        if (this.img.getChunk(Chunk.bKGD) != null) {
            throw new PngException("bKGD chunk must follow PLTE chunk");
        }
        if (!this.img.data.header.colorUsed) {
            throw new PngExceptionSoft("PLTE chunk found in grayscale image");
        }
        if (this.length % 3 != 0) {
            throw new PngException("PLTE chunk length indivisible by 3");
        }
        this.size = this.length / 3;
        if (this.img.data.header.colorType == 3) {
            if (this.size > 2 << this.img.data.header.depth) {
                throw new PngException("Too many palette entries");
            }
            if (this.size > 256) {
                throw new PngExceptionSoft("Too many palette entries");
            }
        }
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        int[][] nArray = new int[3][this.size];
        this.r_raw = nArray[0];
        this.g_raw = nArray[1];
        this.b_raw = nArray[2];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.r_raw[i2] = this.in_data.readUnsignedByte();
            this.g_raw[i2] = this.in_data.readUnsignedByte();
            this.b_raw[i2] = this.in_data.readUnsignedByte();
        }
        this.updateProperties(false);
    }

    void updateProperties(boolean bl) {
        int[][] nArray = new int[bl ? 4 : 3][this.size];
        System.arraycopy(this.r_raw, 0, nArray[0], 0, this.size);
        System.arraycopy(this.g_raw, 0, nArray[1], 0, this.size);
        System.arraycopy(this.b_raw, 0, nArray[2], 0, this.size);
        if (bl) {
            System.arraycopy(this.a_raw, 0, nArray[3], 0, this.size);
        }
        this.img.data.properties.put("palette", nArray);
        this.img.data.properties.put("palette size", new Integer(this.size));
    }

    void calculate() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.r[i2] = (byte)this.img.data.gammaTable[this.r_raw[i2]];
            this.g[i2] = (byte)this.img.data.gammaTable[this.g_raw[i2]];
            this.b[i2] = (byte)this.img.data.gammaTable[this.b_raw[i2]];
        }
        if (this.img.data.header.paletteUsed) {
            this.img.data.header.model = this.a != null ? new IndexColorModel(this.img.data.header.cmBits, this.size, this.r, this.g, this.b, this.a) : new IndexColorModel(this.img.data.header.cmBits, this.size, this.r, this.g, this.b);
        }
    }
}

