/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Adam7Interlacer;
import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.Interlacer;
import com.sixlegs.image.png.NullInterlacer;
import com.sixlegs.image.png.PngException;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;

final class Chunk_IHDR
extends Chunk {
    int width;
    int height;
    int depth;
    int outputDepth;
    int compress;
    int filter;
    int interlace;
    Interlacer interlacer;
    int samples = 1;
    int colorType;
    int cmBits;
    boolean paletteUsed = false;
    boolean colorUsed = false;
    boolean alphaUsed = false;
    ColorModel alphaModel;
    ColorModel model;

    Chunk_IHDR() {
        super(Chunk.IHDR);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected void readData() throws IOException {
        this.img.data.header = this;
        if (this.length != 13) {
            this.badLength(13);
        }
        this.width = this.in_data.readInt();
        this.height = this.in_data.readInt();
        if (this.width <= 0 || this.height <= 0) {
            throw new PngException("Bad image size: " + ExDataInputStream.unsign(this.width) + "x" + ExDataInputStream.unsign(this.height));
        }
        this.depth = this.in_data.readUnsignedByte();
        this.outputDepth = this.depth == 16 ? 8 : this.depth;
        int n2 = 0;
        switch (this.outputDepth) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 15;
                break;
            }
            case 8: {
                n2 = 255;
                break;
            }
            default: {
                throw new PngException("Bad bit depth: " + this.depth);
            }
        }
        byte[] byArray = null;
        int n3 = n2 << this.outputDepth;
        int n4 = n3 << this.outputDepth;
        int n5 = n4 << this.outputDepth;
        byte by = (byte)this.depth;
        this.colorType = this.in_data.readUnsignedByte();
        switch (this.colorType) {
            case 0: {
                byArray = new byte[]{by, by, by};
                this.cmBits = 3 * this.outputDepth;
                break;
            }
            case 2: {
                byArray = new byte[]{by, by, by};
                this.cmBits = 3 * this.outputDepth;
                this.samples = 3;
                this.colorUsed = true;
                break;
            }
            case 3: {
                byArray = new byte[]{8, 8, 8};
                this.cmBits = this.outputDepth;
                this.paletteUsed = true;
                this.colorUsed = true;
                break;
            }
            case 4: {
                byArray = new byte[]{by, by, by, by};
                this.cmBits = 4 * this.outputDepth;
                this.samples = 2;
                this.alphaUsed = true;
                break;
            }
            case 6: {
                byArray = new byte[]{by, by, by, by};
                this.cmBits = 4 * this.outputDepth;
                this.samples = 4;
                this.colorUsed = true;
                this.alphaUsed = true;
                break;
            }
            default: {
                this.cmBits = 0;
                throw new PngException("Bad color type: " + this.colorType);
            }
        }
        this.img.data.properties.put("significant bits", byArray);
        if (!this.paletteUsed) {
            if (this.alphaUsed) {
                this.model = this.alphaModel = new DirectColorModel(this.cmBits, n4, n3, n2, n5);
            } else {
                this.alphaModel = ColorModel.getRGBdefault();
                this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        switch (this.colorType) {
            case 0: {
                break;
            }
            case 3: {
                if (this.depth != 16) break;
                throw new PngException("Bad bit depth for color type " + this.colorType + ": " + this.depth);
            }
            default: {
                if (this.depth > 4) break;
                throw new PngException("Bad bit depth for color type " + this.colorType + ": " + this.depth);
            }
        }
        this.compress = this.in_data.readUnsignedByte();
        if (this.compress != 0) {
            throw new PngException("Unrecognized compression method: " + this.compress);
        }
        this.filter = this.in_data.readUnsignedByte();
        if (this.filter != 0) {
            throw new PngException("Unrecognized filter method: " + this.filter);
        }
        this.interlace = this.in_data.readUnsignedByte();
        switch (this.interlace) {
            case 0: {
                this.interlacer = new NullInterlacer(this.width, this.height);
                break;
            }
            case 1: {
                this.interlacer = new Adam7Interlacer(this.width, this.height);
                break;
            }
            default: {
                throw new PngException("Unrecognized interlace method: " + this.interlace);
            }
        }
        this.img.data.properties.put("width", new Integer(this.width));
        this.img.data.properties.put("height", new Integer(this.height));
        this.img.data.properties.put("bit depth", new Integer(this.depth));
        this.img.data.properties.put("interlace type", new Integer(this.interlace));
        this.img.data.properties.put("compression type", new Integer(this.compress));
        this.img.data.properties.put("filter type", new Integer(this.filter));
        this.img.data.properties.put("color type", new Integer(this.colorType));
    }
}

