/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.crypto;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.crypto.AESFastEngine;
import com.lowagie.text.pdf.crypto.CBCBlockCipher;
import com.lowagie.text.pdf.crypto.KeyParameter;
import com.lowagie.text.pdf.crypto.PaddedBufferedBlockCipher;
import com.lowagie.text.pdf.crypto.ParametersWithIV;

public class AESCipher {
    private PaddedBufferedBlockCipher bp;

    public AESCipher(boolean forEncryption, byte[] key, byte[] iv) {
        AESFastEngine aes = new AESFastEngine();
        CBCBlockCipher cbc = new CBCBlockCipher(aes);
        this.bp = new PaddedBufferedBlockCipher(cbc);
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV piv = new ParametersWithIV(kp, iv);
        this.bp.init(forEncryption, piv);
    }

    public byte[] update(byte[] inp, int inpOff, int inpLen) {
        int neededLen = this.bp.getUpdateOutputSize(inpLen);
        byte[] outp = null;
        if (neededLen > 0) {
            outp = new byte[neededLen];
        } else {
            neededLen = 0;
        }
        this.bp.processBytes(inp, inpOff, inpLen, outp, 0);
        return outp;
    }

    public byte[] doFinal() {
        int neededLen = this.bp.getOutputSize(0);
        byte[] outp = new byte[neededLen];
        int n2 = 0;
        try {
            n2 = this.bp.doFinal(outp, 0);
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
        if (n2 != outp.length) {
            byte[] outp2 = new byte[n2];
            System.arraycopy(outp, 0, outp2, 0, n2);
            return outp2;
        }
        return outp;
    }
}

