/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] DATE_SPACE;

    static {
        int[] nArray = new int[18];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = -1;
        nArray[6] = 5;
        nArray[7] = 2;
        nArray[9] = 11;
        nArray[10] = 2;
        nArray[12] = 12;
        nArray[13] = 2;
        nArray[15] = 13;
        nArray[16] = 2;
        DATE_SPACE = nArray;
    }

    public PdfDate(Calendar d2) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d2.get(1), 4));
        date.append(this.setLength(d2.get(2) + 1, 2));
        date.append(this.setLength(d2.get(5), 2));
        date.append(this.setLength(d2.get(11), 2));
        date.append(this.setLength(d2.get(12), 2));
        date.append(this.setLength(d2.get(13), 2));
        int timezone = (d2.get(15) + d2.get(16)) / 3600000;
        if (timezone == 0) {
            date.append('Z');
        } else if (timezone < 0) {
            date.append('-');
            timezone = -timezone;
        } else {
            date.append('+');
        }
        if (timezone != 0) {
            date.append(this.setLength(timezone, 2)).append('\'');
            int zone = Math.abs((d2.get(15) + d2.get(16)) / 60000) - timezone * 60;
            date.append(this.setLength(zone, 2)).append('\'');
        }
        this.value = date.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i2, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i2);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }

    public String getW3CDate() {
        return PdfDate.getW3CDate(this.value);
    }

    public static String getW3CDate(String d2) {
        SimpleDateFormat w3c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Calendar c2 = PdfDate.decode(d2);
        return w3c.format(c2.getTime());
    }

    public static Calendar decode(String s2) {
        try {
            GregorianCalendar calendar;
            if (s2.startsWith("D:")) {
                s2 = s2.substring(2);
            }
            int slen = s2.length();
            int idx = s2.indexOf(90);
            if (idx >= 0) {
                slen = idx;
                calendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                int sign = 1;
                idx = s2.indexOf(43);
                if (idx < 0 && (idx = s2.indexOf(45)) >= 0) {
                    sign = -1;
                }
                if (idx < 0) {
                    calendar = new GregorianCalendar();
                } else {
                    int offset = Integer.parseInt(s2.substring(idx + 1, idx + 3)) * 60;
                    if (idx + 5 < s2.length()) {
                        offset += Integer.parseInt(s2.substring(idx + 4, idx + 6));
                    }
                    calendar = new GregorianCalendar(new SimpleTimeZone(offset * sign * 60000, "ZPDF"));
                    slen = idx;
                }
            }
            calendar.clear();
            idx = 0;
            int k2 = 0;
            while (k2 < DATE_SPACE.length) {
                if (idx >= slen) break;
                calendar.set(DATE_SPACE[k2], Integer.parseInt(s2.substring(idx, idx + DATE_SPACE[k2 + 1])) + DATE_SPACE[k2 + 2]);
                idx += DATE_SPACE[k2 + 1];
                k2 += 3;
            }
            return calendar;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

