/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp = FontFactory.getFontImp();
    public static HashMap followTags = new HashMap();

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
    }

    public Chunk createChunk(String text, ChainedProperties props) {
        Chunk ck = new Chunk(text, this.getFont(props));
        if (props.hasProperty("sub")) {
            ck.setTextRise(-6.0f);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(6.0f);
        }
        return ck;
    }

    private static void setParagraphLeading(Paragraph p2, String leading) {
        if (leading == null) {
            p2.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                p2.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            p2.setLeading(v1, v2);
        }
        catch (Exception e2) {
            p2.setLeading(0.0f, 1.5f);
        }
    }

    public static Paragraph createParagraph(HashMap props) {
        Paragraph p2 = new Paragraph();
        String value = (String)props.get("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p2.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p2.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p2.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p2, (String)props.get("leading"));
        return p2;
    }

    public static void createParagraph(Paragraph p2, ChainedProperties props) {
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p2.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p2.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p2.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p2, props.getProperty("leading"));
        value = props.getProperty("before");
        if (value != null) {
            try {
                p2.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("after")) != null) {
            try {
                p2.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("extraparaspace")) != null) {
            try {
                p2.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p2 = new Paragraph();
        FactoryProperties.createParagraph(p2, props);
        return p2;
    }

    public static ListItem createListItem(ChainedProperties props) {
        ListItem p2 = new ListItem();
        FactoryProperties.createParagraph(p2, props);
        return p2;
    }

    public Font getFont(ChainedProperties props) {
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (this.fontImp.isRegistered(face)) break;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        Color color = MarkupParser.decodeColor(props.getProperty("color"));
        String encoding = props.getProperty("encoding");
        if (encoding == null) {
            encoding = "Cp1252";
        }
        return this.fontImp.getFont(face, encoding, true, size, style, color);
    }

    public static void insertStyle(HashMap h2) {
        String style = (String)h2.get("style");
        if (style == null) {
            return;
        }
        Properties prop = MarkupParser.parseAttributes(style);
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String ss;
            String key = (String)it.next();
            if (key.equals("font-family")) {
                h2.put("face", prop.getProperty(key));
                continue;
            }
            if (key.equals("font-size")) {
                h2.put("size", String.valueOf(Float.toString(MarkupParser.parseLength(prop.getProperty(key)))) + "px");
                continue;
            }
            if (key.equals("font-style")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h2.put("i", null);
                continue;
            }
            if (key.equals("font-weight")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h2.put("b", null);
                continue;
            }
            if (key.equals("font-weight")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h2.put("u", null);
                continue;
            }
            if (key.equals("color")) {
                Color c2 = MarkupParser.decodeColor(prop.getProperty(key));
                if (c2 == null) continue;
                int hh = c2.getRGB();
                String hs = Integer.toHexString(hh);
                hs = "000000" + hs;
                hs = "#" + hs.substring(hs.length() - 6);
                h2.put("color", hs);
                continue;
            }
            if (key.equals("line-height")) {
                ss = prop.getProperty(key).trim();
                float v = MarkupParser.parseLength(prop.getProperty(key));
                if (ss.endsWith("%")) {
                    h2.put("leading", "0," + v / 100.0f);
                    continue;
                }
                h2.put("leading", String.valueOf(v) + ",0");
                continue;
            }
            if (!key.equals("text-align")) continue;
            ss = prop.getProperty(key).trim().toLowerCase();
            h2.put("align", ss);
        }
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontImp) {
        this.fontImp = fontImp;
    }
}

