/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;

public class RomanList
extends List {
    protected boolean romanlower;
    private static final RomanDigit[] roman = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};

    public RomanList(int symbolIndent) {
        super(true, symbolIndent);
    }

    public RomanList(boolean romanlower, int symbolIndent) {
        super(true, symbolIndent);
        this.romanlower = romanlower;
    }

    public void setRomanLower(boolean romanlower) {
        this.romanlower = romanlower;
    }

    public boolean isRomanLower() {
        return this.romanlower;
    }

    public boolean add(Object o2) {
        if (o2 instanceof ListItem) {
            ListItem item = (ListItem)o2;
            Chunk chunk = this.romanlower ? new Chunk(RomanList.toRomanLowerCase(this.first + this.list.size()), this.symbol.font()) : new Chunk(RomanList.toRomanUppercase(this.first + this.list.size()), this.symbol.font());
            chunk.append(".");
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else {
            if (o2 instanceof List) {
                List nested = (List)o2;
                nested.setIndentationLeft(nested.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(nested);
            }
            if (o2 instanceof String) {
                return this.add(new ListItem((String)o2));
            }
        }
        return false;
    }

    public static String toRoman(int number) {
        return RomanList.toRomanLowerCase(number);
    }

    public static String toRomanUppercase(int number) {
        return RomanList.toRomanLowerCase(number).toUpperCase();
    }

    public static String toRomanLowerCase(int number) {
        StringBuffer buf = new StringBuffer();
        if (number < 0) {
            buf.append('-');
            number = -number;
        }
        if (number > 3000) {
            buf.append('|');
            buf.append(RomanList.toRomanLowerCase(number / 1000));
            buf.append('|');
            number -= number / 1000 * 1000;
        }
        int pos = 0;
        while (true) {
            RomanDigit dig = roman[pos];
            while (number >= dig.value) {
                buf.append(dig.digit);
                number -= dig.value;
            }
            if (number <= 0) break;
            int j2 = pos;
            while (!RomanList.roman[++j2].pre) {
            }
            if (number + RomanList.roman[j2].value >= dig.value) {
                buf.append(RomanList.roman[j2].digit).append(dig.digit);
                number -= dig.value - RomanList.roman[j2].value;
            }
            ++pos;
        }
        return buf.toString();
    }

    private static class RomanDigit {
        public char digit;
        public int value;
        public boolean pre;

        RomanDigit(char digit, int value, boolean pre) {
            this.digit = digit;
            this.value = value;
            this.pre = pre;
        }
    }
}

