/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import com.jhlabs.math.FFT;
import java.awt.image.BufferedImage;

public class LensBlurFilter
extends AbstractBufferedImageOp {
    private float radius = 10.0f;
    private float bloom = 2.0f;
    private float bloomThreshold = 192.0f;
    private float angle = 0.0f;
    private int sides = 5;

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setSides(int sides) {
        this.sides = sides;
    }

    public int getSides() {
        return this.sides;
    }

    public void setBloom(float bloom) {
        this.bloom = bloom;
    }

    public float getBloom() {
        return this.bloom;
    }

    public void setBloomThreshold(float bloomThreshold) {
        this.bloomThreshold = bloomThreshold;
    }

    public float getBloomThreshold() {
        return this.bloomThreshold;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int x;
        int y;
        int tileWidth;
        int width = src.getWidth();
        int height = src.getHeight();
        int rows = 1;
        int cols = 1;
        int log2rows = 0;
        int log2cols = 0;
        int iradius = (int)Math.ceil(this.radius);
        int tileHeight = tileWidth = 128;
        int adjustedWidth = width + iradius * 2;
        int adjustedHeight = height + iradius * 2;
        tileWidth = iradius < 32 ? Math.min(128, width + 2 * iradius) : Math.min(256, width + 2 * iradius);
        int n2 = tileHeight = iradius < 32 ? Math.min(128, height + 2 * iradius) : Math.min(256, height + 2 * iradius);
        if (dst == null) {
            dst = new BufferedImage(width, height, 2);
        }
        while (rows < tileHeight) {
            rows *= 2;
            ++log2rows;
        }
        while (cols < tileWidth) {
            cols *= 2;
            ++log2cols;
        }
        int w = cols;
        int h2 = rows;
        tileWidth = w;
        tileHeight = h2;
        FFT fft = new FFT(Math.max(log2rows, log2cols));
        int[] rgb = new int[w * h2];
        float[][] mask = new float[2][w * h2];
        float[][] gb = new float[2][w * h2];
        float[][] ar = new float[2][w * h2];
        double polyAngle = Math.PI / (double)this.sides;
        double polyScale = 1.0 / Math.cos(polyAngle);
        double r2 = this.radius * this.radius;
        double rangle = Math.toRadians(this.angle);
        float total = 0.0f;
        int i2 = 0;
        for (y = 0; y < h2; ++y) {
            for (x = 0; x < w; ++x) {
                double f2;
                double dx = (float)x - (float)w / 2.0f;
                double dy = (float)y - (float)h2 / 2.0f;
                double r3 = dx * dx + dy * dy;
                double d2 = f2 = r3 < r2 ? 1.0 : 0.0;
                if (f2 != 0.0) {
                    r3 = Math.sqrt(r3);
                    if (this.sides != 0) {
                        double a2 = Math.atan2(dy, dx) + rangle;
                        a2 = ImageMath.mod(a2, polyAngle * 2.0) - polyAngle;
                        f2 = Math.cos(a2) * polyScale;
                    } else {
                        f2 = 1.0;
                    }
                    f2 = f2 * r3 < (double)this.radius ? 1.0 : 0.0;
                }
                total += (float)f2;
                mask[0][i2] = (float)f2;
                mask[1][i2] = 0.0f;
                ++i2;
            }
        }
        i2 = 0;
        for (y = 0; y < h2; ++y) {
            for (x = 0; x < w; ++x) {
                float[] fArray = mask[0];
                int n3 = i2++;
                fArray[n3] = fArray[n3] / total;
            }
        }
        fft.transform2D(mask[0], mask[1], w, h2, true);
        for (int tileY = -iradius; tileY < height; tileY += tileHeight - 2 * iradius) {
            for (int tileX = -iradius; tileX < width; tileX += tileWidth - 2 * iradius) {
                int y2;
                int tx = tileX;
                int ty = tileY;
                int tw = tileWidth;
                int th = tileHeight;
                int fx = 0;
                int fy = 0;
                if (tx < 0) {
                    tw += tx;
                    fx -= tx;
                    tx = 0;
                }
                if (ty < 0) {
                    th += ty;
                    fy -= ty;
                    ty = 0;
                }
                if (tx + tw > width) {
                    tw = width - tx;
                }
                if (ty + th > height) {
                    th = height - ty;
                }
                src.getRGB(tx, ty, tw, th, rgb, fy * w + fx, w);
                i2 = 0;
                for (y2 = 0; y2 < h2; ++y2) {
                    int imageY = y2 + tileY;
                    int j2 = imageY < 0 ? fy : (imageY > height ? fy + th - 1 : y2);
                    j2 *= w;
                    for (int x2 = 0; x2 < w; ++x2) {
                        int imageX = x2 + tileX;
                        int k2 = imageX < 0 ? fx : (imageX > width ? fx + tw - 1 : x2);
                        ar[0][i2] = rgb[k2 += j2] >> 24 & 0xFF;
                        float r4 = rgb[k2] >> 16 & 0xFF;
                        float g2 = rgb[k2] >> 8 & 0xFF;
                        float b2 = rgb[k2] & 0xFF;
                        if (r4 > this.bloomThreshold) {
                            r4 *= this.bloom;
                        }
                        if (g2 > this.bloomThreshold) {
                            g2 *= this.bloom;
                        }
                        if (b2 > this.bloomThreshold) {
                            b2 *= this.bloom;
                        }
                        ar[1][i2] = r4;
                        gb[0][i2] = g2;
                        gb[1][i2] = b2;
                        ++i2;
                        ++k2;
                    }
                }
                fft.transform2D(ar[0], ar[1], cols, rows, true);
                fft.transform2D(gb[0], gb[1], cols, rows, true);
                i2 = 0;
                for (y2 = 0; y2 < h2; ++y2) {
                    for (int x3 = 0; x3 < w; ++x3) {
                        float re = ar[0][i2];
                        float im = ar[1][i2];
                        float rem = mask[0][i2];
                        float imm = mask[1][i2];
                        ar[0][i2] = re * rem - im * imm;
                        ar[1][i2] = re * imm + im * rem;
                        re = gb[0][i2];
                        im = gb[1][i2];
                        gb[0][i2] = re * rem - im * imm;
                        gb[1][i2] = re * imm + im * rem;
                        ++i2;
                    }
                }
                fft.transform2D(ar[0], ar[1], cols, rows, false);
                fft.transform2D(gb[0], gb[1], cols, rows, false);
                int row_flip = w >> 1;
                int col_flip = h2 >> 1;
                int index = 0;
                for (int y3 = 0; y3 < w; ++y3) {
                    int ym = y3 ^ row_flip;
                    int yi = ym * cols;
                    for (int x4 = 0; x4 < w; ++x4) {
                        int xm = yi + (x4 ^ col_flip);
                        int a3 = (int)ar[0][xm];
                        int r5 = (int)ar[1][xm];
                        int g3 = (int)gb[0][xm];
                        int b3 = (int)gb[1][xm];
                        if (r5 > 255) {
                            r5 = 255;
                        }
                        if (g3 > 255) {
                            g3 = 255;
                        }
                        if (b3 > 255) {
                            b3 = 255;
                        }
                        int argb = a3 << 24 | r5 << 16 | g3 << 8 | b3;
                        rgb[index++] = argb;
                    }
                }
                tx = tileX + iradius;
                ty = tileY + iradius;
                tw = tileWidth - 2 * iradius;
                th = tileHeight - 2 * iradius;
                if (tx + tw > width) {
                    tw = width - tx;
                }
                if (ty + th > height) {
                    th = height - ty;
                }
                dst.setRGB(tx, ty, tw, th, rgb, iradius * w + iradius, w);
            }
        }
        return dst;
    }

    public String toString() {
        return "Blur/Lens Blur...";
    }
}

