/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ApplyMaskFilter
extends AbstractBufferedImageOp {
    private BufferedImage destination;
    private BufferedImage maskImage;

    public void setDestination(BufferedImage destination) {
        this.destination = destination;
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public void setMaskImage(BufferedImage maskImage) {
        this.maskImage = maskImage;
    }

    public BufferedImage getMaskImage() {
        return this.maskImage;
    }

    public static void composeThroughMask(Raster src, WritableRaster dst, Raster sel) {
        int x = src.getMinX();
        int y = src.getMinY();
        int w = src.getWidth();
        int h2 = src.getHeight();
        int[] srcRGB = null;
        int[] selRGB = null;
        int[] dstRGB = null;
        for (int i2 = 0; i2 < h2; ++i2) {
            srcRGB = src.getPixels(x, y, w, 1, srcRGB);
            selRGB = sel.getPixels(x, y, w, 1, selRGB);
            dstRGB = dst.getPixels(x, y, w, 1, dstRGB);
            int k2 = x;
            for (int j2 = 0; j2 < w; ++j2) {
                int sr = srcRGB[k2];
                int dir = dstRGB[k2];
                int sg = srcRGB[k2 + 1];
                int dig = dstRGB[k2 + 1];
                int sb = srcRGB[k2 + 2];
                int dib = dstRGB[k2 + 2];
                int sa = srcRGB[k2 + 3];
                int dia = dstRGB[k2 + 3];
                float a2 = (float)selRGB[k2 + 3] / 255.0f;
                float ac = 1.0f - a2;
                dstRGB[k2] = (int)(a2 * (float)sr + ac * (float)dir);
                dstRGB[k2 + 1] = (int)(a2 * (float)sg + ac * (float)dig);
                dstRGB[k2 + 2] = (int)(a2 * (float)sb + ac * (float)dib);
                dstRGB[k2 + 3] = (int)(a2 * (float)sa + ac * (float)dia);
                k2 += 4;
            }
            dst.setPixels(x, y, w, 1, dstRGB);
            ++y;
        }
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int type = src.getType();
        WritableRaster srcRaster = src.getRaster();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        WritableRaster dstRaster = dst.getRaster();
        if (this.destination != null && this.maskImage != null) {
            ApplyMaskFilter.composeThroughMask(src.getRaster(), dst.getRaster(), this.maskImage.getRaster());
        }
        return dst;
    }

    public String toString() {
        return "Keying/Key...";
    }
}

