#!/bin/sh

export DISPLAY=:0
export scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# Find out in what file system this script resides
MOUNTPOINT=`df . | grep dev | tr -s " " | cut -f6 -d" "`

# If /usr/local exists and is not a symlink exit with an error code.
if [ -e /usr/local -a ! -L /usr/local ]; then
	test -x /usr/bin/error_usr-local_directory_exists.sh && /usr/bin/error_usr-local_directory_exists.sh
	exit 1
fi

# If /usr/local exists and is a symlink this script has probably already been
# run. If /usr/local/programs exists continue, if not remove the
# broken symlink since it points to a removed media card.
if [ -L /usr/local -a ! -d /usr/local/programs ]; then
	if [ -x /usr/bin/warning_usr-local_symlink_exists.sh ]; then
		/usr/bin/warning_usr-local_symlink_exists.sh
		test $? -eq 1 && exit 2
	fi

	rm /usr/local
	# Create directory structure in the current file system and make a
	# symlink from /usr/local to point to it.
	mkdir -p ${MOUNTPOINT}/_local/programs
	mkdir -p ${MOUNTPOINT}/_local/home
	ln -s ${MOUNTPOINT}/_local /usr/local
fi

# Write common environment variables to /usr/local/home/environment.
printf "%s\n" "HOME=/usr/local/home" > /usr/local/home/environment
printf "%s\n" "export HOME" >> /usr/local/home/environment
printf "%s\n" "LD_LIBRARY_PATH=/usr/local/lib:$LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "export LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "PATH=/usr/local/bin:$PATH" >> /usr/local/home/environment
printf "%s\n" "export PATH" >> /usr/local/home/environment
 
# Extract embedded ipkg package and install it
tail -n +48 "$0" > ${scriptdir}/package.ipk

ipkg install ${scriptdir}/package.ipk
rm ${scriptdir}/package.ipk
exit $?

!<arch>
debian-binary/  1178355028  1000  100   100644  4         `
2.0
data.tar.gz/    1178355028  1000  100   100644  37135     `
 TE<F Z|u_	!d](.viVjwVpddٻݓn=䒘1nl	NHB[ӔXN҉68!5Nk!-mic$&}37{#軳oޛ7o̼y%K~Bڦ*M
!*CzVK	Mpm¡Z⛦(iӜjpko"g8;a;{-Yv~olCMw5q
*_n׆=%LMm}CSS=ƺ&\PcR8^HʒͧKuHQQi/QJKZ)j*W#pʀYYVw)+`V(a-9KQ3GaJ5(\A ]	j-RK2^R+mk	_zq
/JQ|"5`x);<.ꏈ>q0px	o:>O7Nݠ;P #xv _x.s࿀b~t
x&2pSMp(;+|| Gh4D	L
?V zFO_nSK띮Wo󀛁^`S 	
P럀o?D35G eA'xR<AǀWr>ܠ=w\E<<_:=ҠkބwY{@x^4xghہ_*U5P[E:@m<.e2P	hdH3Q(
!>)   aGHd\k`w}竁5#e'zW 껀O+k-X_
\<t5p/>|X
8
3 v1w'i`3J@Ws@r}<:8kERNgAKQ~%sa>"0Ѵ>
33/ULN{K8zH^P0~}t9?H섞?ψomJعsD=#|D#!b#LtW^zafq g2џ\+!
cla2DG:&ȟ
ѷQ|6/з5R΃G_~w
FycQN2{PJ_Qױ/EˌD7p6"ѯ|/ݣ|o0#k13B_t?GGy^E-_3XF"_cr?Ճ_51~),ŠO	}o, kܠ13zܟ %"Eܼ1W^
k(㱔GϮ~"?ہ1~=xg@396œ1(=3;9k_{w@~Ḍí~!r0SW=H^rqƭ)ўrqޞ>.)8?y˸sg_q~x۞qCx؎ly>U8*M?S^d\ːw5?6.}h,]!z\
#Rx4}]_Y'zee!es=?A߲}NtAR'
[6!Ut&*ػ-+  ]!s/Y9?O~_``Vƿ,9'=YhV`Oee|._yA(_ń0	9_AWO[Oz^-&.)a	?
'=Е_ՠN,1!W~BNx&4VQc_O'A9wfsxzڗM]/5_Ob;vr~þ^OuOD?S4X?I?U\2){'Oe{'/3ɿ3X.߃O9w$0;ÓrR?1~>cρr=I^>IG"GSFGS|yǢ)9¿)yF(L)>{yu

SҾg``_&Khm"z=ſ)_ad9MNA=ߣЗs폂>%qw:?¾S߆FOEа"'CUNh__?9O`|m9y^=[WNcs{>'ӡ|?<7rr|@.wz9ţ/7'G'{ 0l^~u@,ɜ	*׹+O9WR_H,-?}5?s~'?/WC<.=sZׯC_o?IG
y6[_
OK<	};~o zRi9i+9y= }lZG|~Dـ\oD_-8$E!="ub^$ꐴ*.ӫƷ|G̨	^mcMVEOn҆5n&MEUuT_k>\p!З\@UV3#!p:RRFpЦ_K&
K݆iei^v1;ɥ
oZ:]v"%u年Z-HzJ*m
#I-jR@=wAEJ;iFnJl9:v~
fe<u[-Cs|2UqPK
cljM;'Ӹ0.3nDod`6 9fOkZ(U͆L%:fs(MscQ̱co2\Uu̪SqS4;j6/t;&40ݴchI0a-X5,Xސj=iW7#zp4א--g}cd@''<م`:hz٘c3;*VO^.0~S=C8Z7ĲճҧZv2LªADwMk@hA
Nk0N0(}IRPh1Ϥ25gduˎm*
PQm 7o]40=qKB|nӍpX֡BtxC)iƚIkjM-~NV$wclNlq^Rxڲ
^YB_}bۇ$IOqI-a{:ǀ-ZLzʌeQڙBaifphu*s=p)5B
y邮--jX| g&۰k!'3(Wv#Ghyg&`:Cv&qM[8fplT,CU4ӜD~Xb5u晱<yOSf&>Hus;Nz[:h)A_+cpҖX`FX-TƴqnF4yHN
lSiB|r91BB{>3ɚ5ezCrprsg=T 8@_ѢF,%,by"7Qz$r2gJH([EMo++LmW:vbsUz[,@6$\ĭ}U3Xa8
V"h>{
VC/_ޱ~#F}cu'c 5~Mbx
LܓjV(Xx" Z-NGg8-&{S)p޹&Ѝߖ6c5u4Měm;N7	 7{ȳ&2@ܛ ϳ;5tb-D4},Z%Ʈmv&Rr}m۰#]к|'$R[\=km [Xc1-iW'z!ۤa]y[1}N%µ큡R_#" 1Gtݔwk5U顡%=T;3ŷO
{A]0lHW}Z#^p5üv3hm
ø7gv)f
7ЊmTRHMQ5cix;cK!*"z:`n8%-	nr;fhuu[uzUnr#7×_P'7,{Lv"BXL^ ;af[uքh8
k^_T$35cވgUe S߁AaG׺fjxzy#_畴1kXHaѐƷXqM"6_%;ѷm7fМ1"@6h$V PxKR¨vo܈g?O#=W㖭yc
MqXo ۻi@`d'J7匙b1>b7BDJ"LDlrhC/8 R|F"R(94%JjH9NQB/$k98X"%
<OӒqN];#9F_qApƢ\
!V" aknRR<5ZWf|JZ<f`oe؈OϪ*(ڹ˥v[jv~<˦8i sHa"nL˴wvhUkkO!Uҗ?rWPPIb~U"Y.8sVKK_ee5=K鷙sKj.eBS[v}PoE9^J/Y~%bDѿռolf'<`ikS.KW7^|k_n
^_K?4/#s8]9JU߾T8By~S]uC1=Ukd\흫ȞYJ(_r;rUШ	4o_)Uݠ(|PQt*Q~*_Pʒk4T{BUj[ae~(ٖRJ8=G%a*HT߅Q	8N%&R*1ғTNS9OQP	ϼH%K>n`!\ h
^mA.-i]J)_KmZ},gKi!	/R ><OV."j(`QovIPPyU$wfnvK?ܹr朙3gΜ3w?~!:~!Q/EzaE )B3<UB26!BcX(Dӄ(fx:hbá?3(ax&hpc-8b"b
s\Љa1p8<ЉЉ!XÑ;lQB~A*_=@W	ˠ/!V0	_~1P!0##
8@ ~
guПxППᕠ?ë@Wc?É?I?ɠ?k@ }©?o336:Пa)П፠??Û@3	3??33gПA?
3
gx;Ǡ?٠?ß g8gx'g?A?
Пa%ϰ
g8g8g8g gsПBП/@ՠ?П]?ûA?:Пa=ϰggggxp9??Õ?C:=E3L
gkП?AПo@3!ППà?߃ 0>3|gGПc?C3p-ϐkׁi+/?ÿ??'A@AO33;П᳠?	3|gg"pp+p%П@A/w_
3|g@@p703:֥SZ@?=?7Ao3|ggx gxgxgxgxg}ПQП?c?6П!Vs ýoh
[i!+ZST[qۈqˈ0⇏dxƈF|l7܈1⫍x/3F|F̈4F|qF<jGqǈqۈqˈ07#F|dēFq#ƈ6	#̈F<ng2#>ӈF<fm#^dm#^`-#6>d߈gkķF|OǍ#ڈ'2#^kmˌL#^jħgģF|wxxx؈#~#1n7MF<i7kj#0ˌx_`F|/33xjcF|F1EF6F2a#.xƈF|l7܈1⫍x/3F|F̈4F|qF<jGqǈqۈqˈ07#F|dēFq#ƈ6	#̈F<ng2#>ӈF<fm#^dm#^`-#6~q׈o7⛍&#45F|OeFֈ/0q#>ۈFԈO51#>ΈGh#"#n#nF;lĚD:dN4lbgFrPrr{]@l~
;B1vxsA+@މݠ~np_z"sg.>:yJ8</qQ+/TSlSξDӄ]h
E HgğȔ^#fӾ>4R=фqujEw*m0rWE[[U}3P.CD4;[b7i;,V
<OXS@o'=ې[Z"!4=,
C_	މC8`
9t>E%gpVo2%DN\?+BXiqYmk
I>Qҫ\eݬ/Xʍ@]gYuB=a]O2ѴU#A5RSP~FoFZv7]OS>J6jsPW3g].2 3qXy|jC+3O"}i;MEWg5>Ǘ<uδxeh?d{S^y!>\x/F^7Pf6@Yx.EAǁL`Vr06
K烦8ޜz96@&Tx] !ŐAcToCdGFx@ya ~uC]xGᧅqӉ4mQ'LlXM(F'=sO}ߥ=xs:yt|p;Jtihq"7BuU~'ΦB],MS~Gq~G~}GcctU~:RrwHEN.*R7Si!V櫴\6iUZVTi>vw">渁st"0p\~-Zi:iEe~Ӫ6>cT&1i}{vL+D
I^s&EIhuqheuC{zoWZYЪZmѕV47꙾]iJh7UHѿ+ZӉV6*8A@rM
Zy_+%ӑ|I_X:fJ-cVWls([^ ?Zj{]_;HC|MԓKInpHxN4N44m4|?,	<p6 
֨mkLN-
O0G
EUNy V^eM{G)?$s@֕C~bJ*RK܏ϥ}XPr̀,N[[s{wQ&|b:
;;Wssu?W9.#ZAoנTNoFN,:{ĵahA9b?~GSh{m/Z!<:6@uZ/O倖O'D>}fvS:@m^FY 0Y6oWzlhX/+04x{M-c#^-SqoQՏh۲ʽR7Λ6\6nx<L<k6a1=Bx0aaaY`3Aŧ4ߣ̞s-rgl;7NE̲v,K~,ۄ"48>qpeXp\8B\iammxP_S_Wp~r
Pe,Mͮ婁qcƇ/ÖSߴο3Ͽm@+u:ͿxꘚC7w_KNq߳wY߮oU{q	Hwf߮oNu#οkB>:̿iYtο^#aQoxE\y\yUYC'd[Q..C=m;&zRD~!o&9vtw{}{n*d-~RuW ?Ր}&kqk1k6 WU)B5^p;/"uI
^2.Oz9L}<G>e{O! e>P}?u2ػO]P>`Q"x>xH}hYt6S7
_2LI[3/'[m-rQCaȆq07꽭 Q})OݞX={XHcF>(W*(FzҜc}MuD4o_p=J4z'Ҏ\[X"SHh#M]!5>NCNͿu&ɲ)Z/h?+ys<ge,4psqLć ?StiB, D8o|רxs{~5#!/&g5Ni4IH{43<q0Ti(G/ղ_Q}C?К*3{<UUcF.ߚ-:L ^Dڲ{fA{Uȩ%69wm918,C`MmrݪCH-]쓳{CQ_8HcmurzqaUqDUd}}:yM6[\&󙰄WGF^3M(.~EXuy**[qҳݕiQV(]Pu `[6M0vx0D~7kCӑh՚މYk0_他~ӃxsLz|1桵n9f-Ť`I"|'pghoH*ܾ.U_=gNIgKcs]"ΧIs+RwRrb*s	s)?
wM6 Jo7v7xH:W<ZW[Ej<|za %
?	%ǭJz,"=Wc^9~FBQ96x9ϓ%ޏq +J^>
<%GpB]@\C.LYH_K9Ϸp2?Ezh<\.̟y+@CA7!3cJeQ5OQ,O(jj?xﵩ>Dk%?<긅8YzޏA2P/CG/#G~.hH;ֻyPAbwS* _ւL}w*"2'
W~mWb>䉠`r2!G:>-/Xc`fBbsSL.w^Rx@}Fo.g?.݇Y=+ϥpBSs(܋'Q\`SﶓNOyQ/$
<h%> >x2C<o_;M&cvK8AT
{@t,~/"LKD{
ƀLY5t}n*3G?p~?E#׽,E/.`u9_cMWWIGh(ggDq`%ךb>l4
ݎD&}Oջqu
|>|6
D'_ghCMn@(2r27/`	%cmX+& ֶ6\^	c%eJ	X8'sccj̜C#0ip0L滤9)=HowyICGV@o<?Vop}RvU
9wq{{xy$_A͐k%?NL>Q\#(Yu6d"u'/QHr
wZ=v@͏檞<#
0{;v,e*E>ǐWH+q<TG#T;l
9zÐXCj& ?Y;Gxjsw@g[6E<X/mv:2ʇE^$Hs
g$UyGYNzSvPO}[uAu66Cuѥo|]Cuww)]1F8ֈsWccCp\sHߘm꼂@Hwλ{y΃mٲ;>leCuY 7?Kk)=4@ш#{!Ѫ=X6q<(2<vGwsOiOIZԖ8[_ qi7Q wYs8dW5s^,KNG(ގWr/q˃רW0K8l/2ߚ>5}"ZmBd涒35pQf[W궖-sޖaY,(B7$HDgYy^CצYw&!
9bbv+tar~ /;ysR*;P_svr˹FT]+e85uDGj{mlyeol_alx<ŰPvfl`ΘSbgw.#9.Q-mv`օj['dK[ڒ4V˨o"ϟmm֑W!xɭCyP*}{~uᙶ5AUR;FoҸ~[⇓*p@l"1D'M?9ȎCꦎF!p҃2q=G<'Y+2ϠufS*» ҉21ik1S(<$uSv}nʵ(YM.mb-EAiL]{F|[e+ؚ=bj<Zlz:g
>&H4Nqy'RNk moTZ@]@.6K}h~"3{'u_)=<^cofHx9DD!As+n$y[J^WVFEkXWFRt=ުv=^+3uX 3LZS
-LkB;QX)]ss\0bn`=(K+V@6>UϔǇ~~q\A]"z=Fߕr*<r(sah3Y@[g;husf?!xx?.O.
WW&q/Hu&n|	(`ؿ`G+.U8vP'EP_ql%m8O|ixp[!6/˻݈,,~a8Ѳ^	7 q]JWr3Oo2^:/{s޴:M~ќ9L-OU
z\m]5\5J[hv τ Os vEJ_=d_ƱhW!ݴ0{shcoͳ{Ļko/6pOw<SǠW%xޕ%~X;rFSb/.Svh _OWyG[w0O/ʝ9P?	|F&(ig;ʖrOubL>zcF$
1ϓӰ4u^N֦g=桝}DKX{c,yRWo2#Ac/uR/
e{uޭȻwλytwey9wMyjݠ󎵸7䵸ƀ&	c.C~?[FCʶ_h[UXMxvV3X3GVxg<7zG*vT_TA{6F~GD+UxUB+ߺOǁb,nό<Sx-ZЇa/ x!5.m\
y72Fe:<cެ u}14"ˎ~[7龾2GͯmQ~=g{йɥIAZ7soMzs?~f۳O!~7|%^wK[BStP^kp=Bga}܂rW
Hu]un D|X#hƩ,g_
Ors_ܓouG$e
/yp⩌_vFv{G7uCkP
=~GRwO}Mߒ~YwP0X_Q~ӳuxYK.uyJtnqD3\_-uBYUJ6@:u%^uTX{;2ط~?#܇"-.egQ72{aKѼO<=<|O-L&2d$=]R26=,}c:$deroD[
ڟ4b<s|USN$FV_jk{4/rK{#SEJOKv{E7ϋ]WpA
jv/eGU_ȇAYl>`#^LֿHF_kh=cԡpZQɊuBok;>JRiv;K]fѦҥ=K_C9uַPL[<굞y?1e{J_2m=^<LOQHJts;i3U+)݀58j] dgd˶vSU˖w*XڎiPz>#5DmؗZ꜔}i=)9u?W<|<`JW"w^%IY{ŇYފ jf0FlU~Ĵ/Z=Z1KRKaktAI]<K WLaˎ:K<_zqWN,NIB!6rueIi M|MR6=M;Ї&\!u}z_ډxy>G&yV)Q[]lPS5}&O#c]ymr+Ojfi^vgYVI;Z3lxs=DW'^ڹ5^Xms\XyAOk6r,0OЮpsuM9nb=oXӱ:܀Ek'c
ďRi׻FT\si&jga:BKNޗNGan)?0+\reWC^c3 Y׻ȋ|8".v]W0(ryWYhoUz&9n9q1uGoiK!!fIek"l*寫Q|RU7ۋyQcyi{y7^;,I]Êˈɕ^<VLP,Δ]--x\ƽklK}J~>/<ґk;~!GRGB7fPMA|kK;O{Kͷ0跛V$y'/x;_z3kl@c)èk?#?Q/ǨCڹ(oo5KN]
kM_p&%<"^@T>;%2VFC`uFfBWQC+^!e
-yKɽA-{ދ:~|s+S+O)OQwTlXBTAû	x5;
Sc߂3g9Klyf꽙([1;a!ިsmmh\M٨H;K%}gz
$<8>,ϋu{@_k<uόP&2h޶!NJ+[*3ƘngL}΍w{-9k}<5d?+#=5;}
't~ޥVUYBIFo޶+]T?V㐖n.h1b<߆t޻r0;7Znh3
u!ZҰ[{ˢ7-CHTO@_t53igϟg8q-mWxY7WzO
mv\0ífS&בev gruhdԽ{߬djlbtZ(^5
e3Uԕ#Gշo3J¶ o+:bmȏ,qVF7o1C5gVy3gy5Kʮ޼CsI l[nuuK[}ցʦߛGt5`HϢ-_JTM+3&ƥJ&\\6UVʌ}H{/)	h'=S&k;U791%-ߡ>{7հƔl5v8`SFеuq_$E{pr	_,_~ףIlOmկ~e0Gl^Tׅ~UHbZG?)x>cs?CWgq<ۨw!(W{6ڽ3突!xfeˬ֎wNqoۣXadꐿx}8h)(Xxe=Hgj7
ٗ'+F"ϽF0K=󬅲(|ssB^?K/V	2[]'<y־0=X)(uvؗb
aD{qU(sf)mJ~lc`[p/qЃTx<|uZP<VM(3Aj88C?}VdVޛ{,R	kpKxG8GNMB&`K?<q7;|H(L♾ZVA<G[Sg쀯oEc_r|gFw.1˵H]Lռk67~J[Ҫܙת)V*;woğ\iyn}NtB]:_`-*i;d|u/6ɦ4='{X+4ۓMwF/}[
3Wt]>[UigA*϶Ϯ~JM;v+¼Y@SZ5-V$i=1}<+H}R"*b/T\/744߮Hr%K<)D?Ӿ!5T ͺ#̵lR|Y
gӑwGx#G¼lsiKPe{3̬w8`_D;)`>Nv>ۢp?Q3`%XWWzRCՃtaYڊ gRW{{q|iQ2E@z2y(<OML߹$%('ډ>W7u	χ/G$3>oc)vt^&b:zʶ6N%u2?p¯CK*Z玶<[rh5xWzva_qhxP@ml]Wx9<ˉ7%ޔ|xn_/a WXON"wcbqsMqɻ[
t[o'9AXْNc.YVzjü3p_puڣ%OZ EM],/I4I%/!NOxx!1o<oZM\.GL>{0ǒXH;W|!sBnӯ)xli]yļC_]띉o<FL#,E^kiFi4)Mg]lk-UZ?cjy'hE_kڧL[漈qOp!REtZ
Z[VlZY;nZit{-j"dyMǲ[LY>Q{;^{Z07贞HC[X<_d%E&Qa<)y}QW{>J~W#w	xr"Ԃ$opA3jͭƾ{|S&y6Q$}|M]0!qJj{Qf?98?_
D}AW:x!'ɽޘ	g9Dy򼿧?9{=Ļ\9n=#_XiXi8OJh/*P,B|)kZ61Ž9V17:d	tmu|^2舏k}}+,L.7'2=~#(`4N7%=}wѮ|
lg<*m4g?L<iB{RA
C<x^G/p<H,nsC2ٶ:c;ݦg)|rZn~}4,+tY\&n|z<SwH_)̛QF_2U>;0~ۻXoF;5nS=woGH'aOI?w;\Gle{Uý-*otRa"F8c{<4$k!gzEv+%9t{	y?@"gwXm,3jWK:Jٟہx O2yO<0/5G,4A+Dugef;0^£Kþ|7ϣG',xxG7B( <wX62l FPA}5Tuuad193ЈlEP0
uȱƞ7Z|8LOu{Eڟ5O(}t^l(Fݧ#9YmF}Kex}^FОbHgќ/j t
QțҴet},s3a"QTxއgK?ߙ]""LѬ􋛑A\sRuH"Ӯ4̙+ǻow ZQe]ޣs<-tF]7P}9	N_SAk~gֻՏf~4 
?Zs.27K>_&80X'.lw>쁤2i
H[܁<XFퟱ6𙍹8zM^hs4:1kjkFonH4cAqݪ,A8>TteH3QyV<v3yR5}@ 8!?A.7&r3|	Үi+sn\+De:#3[9_`ן*ti<Ť~	y
zW7%Zʇfh!?O(k}L7@	Cb|ރs;TGueH/CBO74ec::/cH݄}|@?t̏"N?i㞏}Nϼu;ҷ"Q'DDsHo wF&u:ʟBz-ҟDuzi7!λ=H#'˹Q9ٹ\|ǎsz0ai?TK/6_ƶn"_j}L_v%wkq*0ҹ_爣t]e<,cᗡz/sܣ3v}6Zf3ϐJx?:7hk,~;]mө~WF΋6-SXm;?uSg}9$U:mPnJ_ɏڷu[E7}{ή;Ads7ξ:ޣͻ6Tun`&¨`00Ot
󲓄y`'ch,sڀO@u}W!9Ѿ=gULW~êrm:Z教뿾@su:EYJsw)ު뺝$uH/+ SVە)J_]\$ZK!gW_}:Pn<pf%s'FcoCX:
yhphW)i4_bVWQ Vy9.yr}2;-k{c&oBsW{_=AgF{-mma2Ϸ=C\kx&G%7C}ף܇?6o3c,Svo};:dًܔ#z_bE3
*OElśQV)KE(+|ʶ+=$2Ntyk.Ӥ^syNb6W8r0Ҳm(OQd?OnPJ{uwwVGR#}H~^}\ڵpN
ӰZ}mme2vI}X"혫T!-Gs7ld%Ƒ^x:2ô<MlET=ywdCٿix$'~=F70FWW|/.PO%+?{4s˽=p[yg$P- |Yq1z?a|2mbκ-Kӻic$vDurYO| +^1
om_*uεdK3O|khobg}Pk8m.Uv綂a}H;z9"5ʖ^j]>se൧14M(MXw)ݜdң%>R_ۯZg]!w~vh㈶uy~(9]mU
E?qYʏ<n+c8W%5_{qeʱ+xפ/|Sĳ7gPQ4_3$yCF*v:]+җˏWjeFQ[Gޅq_;wD^=9@w`-ȧ/<r_s=D1^SrR;G"m\QZ;+aGwRwpN2}^]0^ȶ7uqKL_AGnnV©E^2!:ҋUz!}Xuby\UXpr+bxoviW)	:ƻk]]>8F:C;gDv:$ީy?EX|׽x٥:#ߥ!riOlҵh"Ǟ=m6Or݋VЮ$kMM2M}/3O 6CX"nC#_+?v]f
/.u-ָF[o3'IuYˣ^K|kSNbWa6 u;wBN蛓ﯡeUR\r8|ȶ+:B]OR&mȫY9c-V{
CSz5,}K72yOz^=˦<G皂9lX
is~\qy(h.'.ǰ_ 0&̥1A5iXt>NF0C=U"}4
~`ݓ6#U9H{];G{`!|T(}7,uuiDw5ox7(M(QYeu;<*k]4Jxx}*K<lU<wY%u$&D\J_z}JrϹL.Fϙ*S2[oPK[+k%KǺuҿ0-O<w9NuKͼ++m-˓˰%J]ilS}iSvY?'(喪є.~xQw|K<#>u+9?,uPyƗ=lUqlMwKPԦ00PRF",	K3ܘ`)IMzLaj|Fexi;XkZ]]}2Foӓ^8&W]{_o|jO26g
vbSt #>)BJ-PxyiEh+*0+~7#,g
"߱}@ۖ0s8\Y7.==s<U~0]{AB'^}5*ρg{c?.Y{ݬ`3f/] qQ'}[HuO:g?Gw
B}[g8~H,۵@Gf6_2hOmXsvY4$M4Ox41>Ҥt*2;Uz	GsOakCg;g6q).ҟ֩o7W~A?1qw/}@7a;5JG`ML`s-A)=ݏ^{	̻e| 1>2B=us/"w|'OXRhn׵fsmҿQk!깼s9X@H߶ZMJyp=V{qi_Vv)]wRAd:}VG1n=͇/rm*3cgi;$o8H~J~N#R{@楮]dZjʕCm^8`}}Rf)g칛~'¿P{~8}1nb!roثlS+5x5d{(}!3yKbR:	Dg)Sas\%
?iMouڎ*<_Jc}_eJwA	@6i}IqRqB梏yNgu:hS >Pr_&kR>]t(.^{i@A2s.눚M0\
˽%x/G}euNa__Wa1c5cT??m[;or@1!wCY!B=Nb9JYϖ?W

RmǟmKsS|!ewŝ-W3j_,Oh{1ΥF͔/sa]Ȟ?
JrvJ=FY[%FϽϼm8Ej'׺F}樢WNsLگ\DNi|G5.ޗw ),lT4%]4~W8we_i _R<ƫo;W|:mnI7~0[FY7|cdsΫW_yŽ:
}e
.K,Qk^V)vReQHvg\{N߷!=p_i*17u4yNK4Z__C
\Sh|gl˻)g.{${F4)#Zg_yŕ	wV;a|"NYas6˯^I/_i>K7'$j{PWi,QSi oz%jϜnk%ԻNQ߲EB[0~IdtJIҲ<_,K0^l#-mѷ
=~ÇcW {k׎H9تJR^S~4,Oϥ|Sa]v~|w K*rj[u=GS`/񝴁2tvejބ O?S!+WC|6hSny^`
FZն|mcek~ԗFU\{iP]T+wۉkb=Qn4lӡ\SwSmhUd>{Sa݆COwz+lFs)ˉ`W*s̓6QYY?\uΜyןH3"5}c|HU߭[2~G`Ts *J0Jڻ:Fsr}i6zxfz11{oFU0l>Q6`?DFZ	h1	@d|Ч/hZPa}D>u\}6yEt=HIS[b!hLo{::@]곔!,l
ɯoH!u

:
Iq|?Ä1#-;y Q򓒡 [%NOtA^upw-C?c],C}'9
ma~vJ6L"}}v<{4#3RyfR(_ZCmNmVFՈߊ>j]7!ءq%qTqt
5|č[	v*?^$n~Gln)l7"bv3BVy}?"|z,@Q-xw?҉݌F[|?cT8 *;Y<- L%({-昘m	F3v8_@XWe9 {ټ35;	}=7ڜjvy*$ogAOv7<L]bZ%ޡcJ=1yye-Խx1~k+Iԕ9iiߒ>gb_C2w_|1c<!Nۇ؎}r]ܮ~y_ [X<l[^򞿢'KsK]x?륮~^pgEιEǻqx:|$]zyo6}TR[uY*>>	@Է=o_FqgVehwF!+^;|QWETޢQw{w=k6pQa߹%)yb3PWB&':\<u./J*Rvi0;EڀOwyO\th7x00Tw+GSwq
~+ɒJ;yY+Tt5RWvR޷18Jh}o7`jI{Jysub-~c	?}Pu]Kr<6i\0uP+ߌyxx[}[~,_ϰ"xoݟMk؞a+o`+lv7l-аۀЀ@BX	g[h5mAR>~՝$WӠp~G]θy0~6Ml[>\^zϓx-?}U}7YFJog^7+Gfvu<qyc\3Onew0fqITp[թӨxjbzĉ#n|
z)?FNColZ$zcWNgeQ2껴L;ޱL<_7wެ9y'Y,|f_:z|>Vu},XI{wb\#}=E/O]hNލIvtoZ^W{=U/=:I <OR#־ԏзSOou<5LV}[	|HW)'g~S'C;(;n`a~$a	D;G5Ow_0moY<U)ƪ(l"YyDvvwo>=y;Iy?/!݋Z/7:&%vyƸsM9]+zף}7
<uyxq0N_EiO{7W,箍ֶַ|S?anYj) vai`_hv@H_*.!,}f%^> k47^/ 23KhK=@xO}_&|h?86&ޟ&aoޘnlxg&<g۰ɷ|N&Ǳɷh;Q&%ݮS6IڎMW6	ƧIS-i,twko$muo8i?[lD&?߰/7ߚ͇0ɿOfo}M~Y;_=kHk;$&?Ԏ6wg_V	ɯ.}*6Ҧ$lOvAm0l7+kwI۳6w/qa`V#66&?pio56l#<-~Y6:?ȥUMm0l16*t ѳCl˔M~wr6z+6xq
^(yV(N;e?,=*SieS{){iihRv6RK}ڊѮ+kO6]aO\3h/%;Y{[~=~"kǿǧ>g$uu^_=hDv{J>=3#eY{|K^=Gv˻xx7G8ʺy/>~+8
ϧ<:9{
2WS%ؿ-AͶ-m]m	}[۷}2[a:ܹMl	.іml	~%ظ~<[^hK0a[ol	ykۺ%uǳ%x{[G[ඓ%іm͖ ѭ'%mm	
ؖ["-'%6eKsmCl	:C
{^CM=mgm'ZG!ǎeKW귝?Tnjzo^gmڱ"^?jc[OGjK}n|.p?ƞ'#rO#uɖ>RpW[NG^G|}<ԯuegG)[Gj#fkGW?[?GSH?NG*򑢾|t+$/XyI}nKG?3:?ur~Rũｎ~R}
?M''I]rr~Ro99?#-]x򵟔,'葮~Rw߽TGz{?G:IkRvttuU9<Cڽ|!5uZaC͔Sw~/#QjOOp>QCNSS"\D5^ާg[:Ct>u+]>-o͚P"z|[bmQ~*~ong!awpozOT#r&)$Vz)n[wp9-ji,}ƇO}~zG;<
_<y}n~]މ}~ҍ/ӆ>Oid>O{(>p{r>O|S<zO>Op|.~y:}yZƧ~tũyʼ}ti׏owy妷6e}re}ֽ穹ϓ<^tO7>O: v>{Y;{~~_
VvE'[}{s*_;ّag֎owv#hwکǾ6Ǳ?߉vǧ$_OQ?du=/OK
cw	
d_4}
׌,?_FͺͿ";
9uN=/Qߏ>i/ta۰^qrX6^h?I?
_ށ#_SdZk]#(#Ƿyٟ]6u=meˎߞVO՟%ZWR=3m-4KN@_oV4c~/)Oߤq%nM?$>-~?+v߰J"G*<IhwW?>=ዽic>LO_|?J]n.7w˂ћݜoW};c}k
\<GplAŃ¥)ۤ<Ϗ*<Rf$=Iuwطâ	eWXP6sXN̲g%v>!i8/p~[ܫ>d{ǻɍvoں_x3Lϼ>G<sM?g&s慠h}V跹p?.p6xo!"Ofk|q71#1iLEܘ37؆
]msz~mO}997򼴉H{D7
o .A[ k%\-B}W[8@^A\}'W~<`ZNis'S"/h]]6!ZZYe܋HbnZyN*e[+Ŋ~π㈏:ph-e9?YFߠ>X?eJ4ߤ3
GTF41iFn,:w7b?±yF@Sޙ:l7Q}$gy	ux6CiFK}!qer}]o֌~U`7QuO{-#+YǓծj?qW64u 'Z"Wo<RΛgy
W9c<6֋'>/t>\/wrtڬ]P{]b܏,.m[v-$x 
@bhaڼDY4y7D~-*}ufX\+ݿ=^ +&og3JJϻi#zWtTwu.u^>,HB[q>DXhYݐPVhݻ܈[!Gz<'u0-Y톒kuʎMyh~<U(SU_1&].퉖H@0p{]i
}:J0x'sj6
DYb}Щv⺦Xitʥ]-Qƾ7Ǟn8MLKo =Żfm'Ynr/YZ7X$9ۯ]sn*ui7+\ڦaGwJ	#ZG=r.kױwm|O{WUu$L 5T/-AdQZP@/ʠ%&3ә	Hk(b55JZk?]j; _KU$ö?ϖ;M?ܵf==7JyΣ`Q=in6l68ןg>
hԯ,kL7ս87?f׭UgV3>[	]B=0
zE=?kz>4@"{W/pɯHik&)/YϫHCz:4phq,ve
-횠.:,f1ב=MwoL][-zGk3_iU޹Ru5&Rol騟W!Ԙ=Gͥ?M)]:іE_(/ғ/ga:eFW %u&moƍ<<Ycܛql{
W
+1'I;$58ܼㄲir&hVs<5[ӊ/~gt㍎
cmpiF~Q
877+77^W҆:X_$Λk)zM=sҁ@)BW>F/PЦ:]FJarWGS2v[#q*<|6-*?+}0%K])L'~.*J/`ܫj2;w߸&y橤MҾlK5o\9x˵}c|ۧyC?joCŧ޳>Mu{nG}s1l*AIorCЗkSݯK9tU̝x'{kOߧ~{w7˻O8D<',vu6UP}k2K.Muxy\38<ik$=ݜ2hSƽnsׯۉyږkMfsrye&=l2
{Uȟr0ְgÈ_OWT63Ї<OuЮ\,u~
ɻ>iXnmE޵puM8iLO5jΓun&Ӹ<:^G~Wr[,Ӗ*:迋Cؙb|_r9~u:;["_4
ףwJ=k_mSPv<Ղ[Pvn1+Q
]twkeC\֝.Wqw}R53=E{h7߸SR>R>ף?~~nyC~.}}V-5Gm\SʶP^jRkx52;y҇ЎTs8x͵/bmawȳ
Xn0<k2c?|s)[;Y5gxX	<פl[ȋUΕ=_%ɻ
0Fk zVsڛ5ұ<3`زA-]cӁL&F>|$M3i؆Aj?6SQD݈gSo45"w7vs.EoQk&?8=,]dmRerU`Ǽݮ~etGc"j+iÂ=X.q48_nKoY*zKz꯳ܶs1}B˔"7]eNb6\e))ߊLAq`/ycmQ)wZ\S^փY]k36={1py.vH=QX4]y?}𨢋<K,Z$%*C<-~7Pֹ%=f=Wt(4}Mª'\!_=Oiu=Bǩ3rδSQ9C>m}˛,'-}nOfU曀ON~/CN/vqΥwt{wsa?#ӿ[n@N;'6E&#6҄ϰ/G\ٕJes.hh%(Z16s
Oc*RWKT@i/ǲ@=-Rʐ/MG\lxvQx\E4QlK.餳ȓ2}WoeU!9Wi,֋uz$Mقon,k 
4 hbM!.
ԗdl3吿	G(x։`ް}
߿k0WO`|~{|w|]Ytkw+S~3
7VxWt|Q& |OI|w`»\siD|@j;8O\*'5c]1
zm1ߛY|ͧO<MYu
֒W?>Zo\̄\ȓǎE~³oۥk~!tgF!:d^h>`̷yߖ`ZRɋ 'U_*Էxc(Uoyh\ͩgaȒS?"}ιu+׫\]['rўj/<eaFvkx訹syIXREy{ןb
:Ϻ^S.eyr+hóc[?W"u@7 ډ7ZݼU/.U.Zu-&mxB.mKi>m콭[dZ5{#;8CӒ3.ULMKݏt\I+^xBMƀt)bHk1>Erjj2cjzN \hx
^uFΚfҾ{9quۥ0s/e3m3=ݏ1p>KRӇo?xzgiƈ37j3
y8I|?rH;=@yKQ\rz\t[rߎ:|\nvtm$5ڝGtkpKS;U9~%X3,.Se>2vyBe	۩h$Ε0f<9{>PX1zYcf]Grj9~3?7n{w
V,0go2V{S<7{+u7YNmadax9QtӉmڨ	%gVw @|rg\@tڮ:oJ	wʰ=ǋS/ipIDN}ȳ\碑[${~/WGw8gMt86z܊i2MMf?>7Q~anM笸h$7tX:[#$m}G_y17nZ,uS\[JCOO= ߣry<Sny4)Ͳ,وf#fi+>fQn!-&_rכV=g+-ފGU_9e_5pW+wq}e?^ߕ̥U}g7=V~bwI܊Tr@_5exN]ʶn龥uZ=n #k0vď7ڌ:FON9噀Xt}=H=%X߱h6wݜLϛ(Լu}/Ϧ8vΊRźomСMċV~+`Z+_&bCooOeǭ)/׈%c-f{Ի55}F**4bxVq\ޣ,}ԝ>٧vj;%Z\p"Z)A=vYDN==>eãiflz[(_ZȒR_Fw~9aYv(SWreOQf?'mYhl6tZzvJ~MsFOof'ڮ`9O"<LHƿC5̳^܇Vvhвܢ+nLyvZ7*Ҕp~i~y<y(ͽ ۀ~jmz%(s?]aټy:~/^Bhޡ`Xw[C LeM6wʝGYvi%,(Mc>۩C
x#kg/im(ͺ_]HJ-K)U;w|*dV=sf*7t~M+ڞ<#94
kb;r6Ajo||@דgƷe͂%*?/2=*6s}+C(3:(M7VRs&VYg[G9VNއjnޅ{0 a0}Ni3C&5Äs0u6`^0<oyYx0lN߳6gsfӳX>a9%$|c1k
<a?:N>|TkxµG͛o{Cox!*W_~E q(x!b܇அ
܍p=?iZz2pL'~p/xn=hzG^W3֙NE/oat3Kr}R]ҵg<}?rI].o]Ƭ歝Գh6[Nil4.wmSN%V2̺F(iP*e9eC!"#SaA'_6tVڡi~>47}S[|
mt]AcפM3lH"k2߅7ט.lxN<l<:ӄg_9+2|k{6~Ɛ7 k	".q#}֢_%<[Ku?pޱ9"w;2l~Jӛ㽧vUԗ$	X8]/ ĚK	,~y#4~ȏW0Ϲ\Vuc=1ݽ{{J܂U
~;7.P!`#2qT(j_F!rB!#7#d(h4	1%hA8B?K1ǂˍP(I6JXC Ϳpn,6gN}<ևD(rbقi
8 )SSA#MX(bI-	V,Z\Pp"9G!g}5m0/$z 7_;h	%iS~?C~W!KY?j|:.|_w%(|+CqjǊP100РXGB1%a,c<ƪpѸvX쥍
8,0ppҗK#WΟ8RB%PpR_&{!. r~40gN0W,@w0b5lR*HF
 Ig\AˌX4YEehd2Y#Q6t <
dն׆V$I[DWGlP}WU#=F1	GVL?Y, 0)aTW<GϖV3d9'x?ƕޟHΨl=,ΟL65&C:p$HED26.
@MYj_ΨgqdHЛp0Yw|TpCtR'F6ZmHgko膲{X!XORu~0_uqi?4/_	6f4@O*c+éX<(IFK%X(Dx4BQ>ytu<FBtXDA^QFЛ,l6=	0iJ9^_4\q%cY_u^ )jGq8.1{JpH{.G 7XQ+PrZ!fUrJ92`Y-cE<͊Gbcr
PڟHƃd*r$1C.,9$_['.9L Isx^4<oHyH T6b9IGfhNƤ~Az24#OyŘp\Ͱ|w`5堛#}nrDpQCe-bp<6gm>
=_IAE"u]s<N-
<#3{=<o.v-7:¬xEnQr?Tǵ;ar?ݖv:vڽ\WkWniʽFܙgNp'?b\cA\ZP".3A߇tPenUQ{/'ocBhhGeFYyeTdYu?F~=͛cL]xiƬⲑDjI(rƘ(`X<HW:NWG╡x2"g'z'sr?YDE_-B$X.%%/c%Pr	ep QdM 6mgO!#$C
?X;vp.P"S⯄#
cN]6ȃ}`^J0%Bag
ZB[-7GşNJ]gn|./O!Dx{;&Uknu嚃kl568I[ p]k߆xb]뢡pD
Wui'bywpwX{5<!p/߱  pag+\Q{T	2 Px`1Zp\HΏmp9
tKz=dM;E۶ ͵UGc"S\ҘP^_"I9>K[ZV&]Re3o̲3q?B'8!BPC"<Q,]G#ҙ WZ6k aYK}}(gg7[xgzg_62sO]ey8>9kV0'yFgyFgyFU, h 
control.tar.gz/ 1178355028  1000  100   100644  421       `
 TE<F MK0)"K׮ЛEPJ̢IyM7|xiʒqγ(V[.|ӾHʄ^ӗ$I׭w4}_)gf5
o?˸H7|R={]ӭN:/:]q`SE\IZwiKil\`스j͓u}TFiEE\KϴW`Z$~Gjҹ!v?C*ƆaAʆZ؝igZ؉MVv2:~8(NƘ|0p|neN5aMw<O06O?hc}p?c8>|ϧ!B!B!BQ1в (  
