import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SwitchCalTA {


	private static final int numberOfLines= 50000;
	/**
	 * @param args
	 * @throws IOException 
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws FileNotFoundException, IOException {
		if (args.length!=2){
			System.out.println("Please input a directory or text file and a directory for logs.");
			return;
		}
		String s= args[0];
		String log= args[1];
		if (s!=null&&new File(s).isDirectory()&&new File(log).isDirectory()){
			File[] list= new File[numberOfLines];
			int num= getNumberOfFiles(new File(s), list, 0);
			System.out.println("I have "+num+" files to process");
			System.out.println();
			System.out.println();
			if (num>0)
				switchFiles(list, num, log);

		} else if (s!=null&&new File(s).isFile()&&s.matches("(.+).[Tt][Xx][Tt]")&&new File(log).isDirectory()){
			String[] sList= readFile(s);
			File[] list= new File[sList.length];
			System.out.println("I have "+sList.length+" files to process");
			System.out.println();
			System.out.println();
			for (int i= 0;i<sList.length;i++)
				list[i]= new File(sList[i]);
			switchFiles(list, sList.length, log);
		} else {
			System.out.println("I only eat folders or txt files and you fed me something else, please feed me either item");
		}
	}

	public static void switchFiles(File[] files, int num, String log){
		Runtime rt= Runtime.getRuntime();
		Process pr;
		String[] cmd= {"cmd", "/c",""};
		String line;
		String[] output;
		String author;
		String title;
		log= log + File.separator+"ebook-meta title-author switch log.txt";
		BufferedReader input;
		Pattern p1 = Pattern.compile("Title               : (.+)");
		Pattern p2 = Pattern.compile("Author\\(s\\)           : (.+)");
		Matcher m1, m2;

		for (int i = 0;i<num&&i<files.length;i++){
			System.out.println("File: "+i);
			if (files[i].isFile()){
				output= new String[100];
				author= null;
				title= null;
				
				
				//read metadata
				cmd[2]= "\"ebook-meta \""+files[i].getAbsolutePath()+"\"\"";
				System.out.println("");
				System.out.println("");
				System.out.println(cmd[2]);
				writeFile(new String[]{"",cmd[2]}, log, true);
				try {
					pr= rt.exec(cmd);
					input= new BufferedReader(new InputStreamReader(pr.getInputStream()));
					for (int j= 0;(line = input.readLine()) != null&&j<100;j++) {
						System.out.println(line);
						writeFile(new String[]{line}, log, true);
						output[j]= line;
						
					}
					input.close();
					pr.waitFor();
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				
				//find metadata
				for (int j= 0;j<100&&output[j]!=null;j++){
					m1 = p1.matcher(output[j]);
					m2 = p2.matcher(output[j]);
					if (title==null&&m1.matches()){
						title= m1.group(1);
					} else if (author==null&&m2.matches()){
						author= m2.group(1);
					} else if (title!=null&author!=null)
						break;
				}
				
				//write metadata
				if (author!=null&title!=null){
					output= new String[100];
					cmd[2]= "\"ebook-meta \""+files[i].getAbsolutePath()+"\" -t \""+author+"\"\"";
					System.out.println(cmd[2]);
					writeFile(new String[]{cmd[2]}, log, true);
					try {
						pr= rt.exec(cmd);
						input= new BufferedReader(new InputStreamReader(pr.getInputStream()));
						for (int j= 0;(line = input.readLine()) != null&&j<100;j++) {
							System.out.println(line);
							writeFile(new String[]{line}, log, true);
							
						}
						input.close();
						pr.waitFor();
					} catch (Exception e) {
						e.printStackTrace();
					}
					
					
					
					output= new String[100];
					cmd[2]= "\"ebook-meta \""+files[i].getAbsolutePath()+"\" -a \""+title+"\"\"";
					System.out.println(cmd[2]);
					writeFile(new String[]{cmd[2]}, log, true);
					try {
						pr= rt.exec(cmd);
						input= new BufferedReader(new InputStreamReader(pr.getInputStream()));
						for (int j= 0;(line = input.readLine()) != null&&j<100;j++) {
							System.out.println(line);
							writeFile(new String[]{line}, log, true);
							
						}
						input.close();
						pr.waitFor();
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else
					System.out.println("Skipped File, continueing...");
				
			}
		}
	}


	/** Given directory dir, this calculates the total number of files in it including files in its sub-directories but doesn't count the directories themselves. 
	 * It also places each file into the fileList array. So that you end up with all the sub-files in the directory present in the fileList[].
	 * @param dir The directory where the files are present.
	 * @param fileList a File[] with size at least as big as the probable total number of files in the directory. But it should not contain anything yet.
	 * @param listPosition Where in fileList to add the next file. It's used to keep track because this is recursive. When calling this method it should be 0, unless you want to start later in the array.
	 * @return The total number of files in the directory and its sub-directories excluding the directories themselves.
	 */
	private static int getNumberOfFiles(File dir, File[] fileList, int listPosition){
		//System.out.println(dir.getAbsolutePath());
		if (dir.isFile()){
			fileList[listPosition]= dir;
			return 1;
		} else if (dir.isDirectory()){
			File[] list= dir.listFiles();
			int j= 0;
			for (int i= 0;i<list.length;i++){
				//System.out.println("  "+(listPosition+j)+"      "+list[i].getAbsolutePath());
				j+= getNumberOfFiles(list[i], fileList, listPosition+j);
			}
			return j;
		}
		return 0;
	}

	/**
	 * Reads data from file. Capacity - numberOfLines lines.
	 * @paramfileName the full path and filename of the file to read.
	 * @return a String[] where each line is in a different index. The length of String[] is the exact number of lines used in creating String[]. There no unused [i]
	 * @throws IOException
	 */
	private static String[] readFile(String fileName) throws IOException, FileNotFoundException {
		String[] s1 = new String[numberOfLines];
		BufferedReader br = null;
		int i = 0;
		FileReader fr = new FileReader(fileName);
		br = new BufferedReader(fr);
		while (br.ready() & i < numberOfLines) {
			s1[i] = br.readLine();
			i++;
		}
		String[] list = new String[i];
		i--;
		for (; i >= 0; i--)
			list[i] = s1[i];
		return list;
	}

	/** Writes a String[] to file, each index is a new line. Skips null lines.
	 * @param s The String[] to write to the file
	 * @param filenme The name and full path of the output text file.
	 * @param append true if you wish to append the array to the end of the text file, false to replace and create a new text file.
	 */
	private static void writeFile(String[] s, String filenme, boolean append) {
		PrintWriter pw;
		try {
			pw = new PrintWriter(new FileOutputStream(filenme, append));
			for (int i = 0; i < s.length; i++) {
				if (s[i] != null)
					pw.println(s[i]);
			}
			pw.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}
}
