/*
 * MainFrame.java
 *
 * Created on 29 maart 2007, 21:38
 */

package iliadmanifestcreator;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author  Bert
 */
public class MainFrame extends javax.swing.JFrame implements DropTargetListener {
    final Color[] iLiadColors = {new Color(0x000000), new Color(0x111111), new Color(0x222222), new Color(0x333333), new Color(0x444444), new Color(0x555555), new Color(0x666666), new Color(0x777777), new Color(0x888888), new Color(0x999999), new Color(0xAAAAAA), new Color(0xBBBBBB), new Color(0xCCCCCC), new Color(0xDDDDDD), new Color(0xEEEEEE), new Color(0xFFFFFF)};
    ILiadManifest imCurrentManifest;
    String strCurrentManifest;
    boolean isExistingManifest;
    boolean isSourceDirectory;
    File[] arrSourceFiles;
    File fStartPage;
    
    DropTarget dtSource, dtImage;
    
    /** Creates new form MainFrame */
    public MainFrame() {
        initComponents();
        lblStartPage.setVisible(false);
        cmbStartPage.setVisible(false);
        chkResetPosition.setVisible(true);
        lblWarning.setVisible(false);
        lblImageExampleNote.setVisible(false);
        btnCreateManifest.setEnabled(false);
        updateSize();
        
        // This class will handle drop events
        dtSource = new DropTarget(lstSourceFiles, this);
        dtImage = new DropTarget(tfImage, this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        pnlSource = new javax.swing.JPanel();
        lblExplanation = new javax.swing.JLabel();
        lblSource = new javax.swing.JLabel();
        scrSourceFiles = new javax.swing.JScrollPane();
        lstSourceFiles = new javax.swing.JList();
        btnSourceBrowse = new javax.swing.JLabel();
        lblStartPage = new javax.swing.JLabel();
        cmbStartPage = new javax.swing.JComboBox();
        pnlManifest = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        lblDescription = new javax.swing.JLabel();
        lblIcon = new javax.swing.JLabel();
        tfTitle = new javax.swing.JTextField();
        scrDescription = new javax.swing.JScrollPane();
        taDescription = new javax.swing.JTextArea();
        tfImage = new javax.swing.JTextField();
        btnImageBrowse = new javax.swing.JLabel();
        chkImageResize = new javax.swing.JCheckBox();
        chkImageConvertToGray = new javax.swing.JCheckBox();
        chkFillBackground = new javax.swing.JCheckBox();
        cmbFillBackgroundColor = new javax.swing.JComboBox();
        chkNegative = new javax.swing.JCheckBox();
        lblImageExample = new javax.swing.JLabel();
        lblImageExampleNote = new javax.swing.JLabel();
        chkResetPosition = new javax.swing.JCheckBox();
        btnCreateManifest = new javax.swing.JButton();
        btnExit = new javax.swing.JButton();
        lblWarning = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("iLiad Manifest Creator (v2.0)");
        setResizable(false);
        pnlSource.setBorder(javax.swing.BorderFactory.createTitledBorder("Source"));
        pnlSource.setToolTipText("Browse ...");
        lblExplanation.setText("<html>Notes:<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- To edit a manifest: select the directory containing the manifest, or the manifest file itself.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- To create a manifest: select the directory or file(s).<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- If the selection contains a manifest, that one will be edited.\n</html>");

        lblSource.setText("Source(s):");
        lblSource.setMaximumSize(new java.awt.Dimension(50, 16));
        lblSource.setMinimumSize(new java.awt.Dimension(50, 16));
        lblSource.setPreferredSize(new java.awt.Dimension(50, 16));

        lstSourceFiles.setVisibleRowCount(1);
        scrSourceFiles.setViewportView(lstSourceFiles);

        btnSourceBrowse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/folder_magnify.png")));
        btnSourceBrowse.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                btnSourceBrowseMouseClicked(evt);
            }
        });

        lblStartPage.setText("Start Page: ");

        org.jdesktop.layout.GroupLayout pnlSourceLayout = new org.jdesktop.layout.GroupLayout(pnlSource);
        pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlSourceLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblExplanation, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 606, Short.MAX_VALUE)
                    .add(pnlSourceLayout.createSequentialGroup()
                        .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(lblStartPage)
                            .add(lblSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(scrSourceFiles, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 524, Short.MAX_VALUE)
                            .add(cmbStartPage, 0, 524, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnSourceBrowse)))
                .addContainerGap())
        );
        pnlSourceLayout.setVerticalGroup(
            pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlSourceLayout.createSequentialGroup()
                .add(lblExplanation)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(btnSourceBrowse)
                    .add(pnlSourceLayout.createSequentialGroup()
                        .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(scrSourceFiles, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(lblSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlSourceLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(lblStartPage)
                            .add(cmbStartPage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlManifest.setBorder(javax.swing.BorderFactory.createTitledBorder("Manifest"));
        lblTitle.setLabelFor(tfTitle);
        lblTitle.setText("Title:");

        lblDescription.setLabelFor(taDescription);
        lblDescription.setText("Description:");

        lblIcon.setLabelFor(tfImage);
        lblIcon.setText("Image:");

        scrDescription.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        taDescription.setColumns(20);
        taDescription.setFont(new java.awt.Font("Tahoma", 0, 11));
        taDescription.setRows(3);
        taDescription.setMargin(new java.awt.Insets(1, 5, 2, 4));
        scrDescription.setViewportView(taDescription);

        tfImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfImageActionPerformed(evt);
            }
        });

        btnImageBrowse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/folder_magnify.png")));
        btnImageBrowse.setToolTipText("Browse ...");
        btnImageBrowse.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                btnImageBrowseMouseClicked(evt);
            }
        });

        chkImageResize.setSelected(true);
        chkImageResize.setText("Resize to 69 x 93 pixels");
        chkImageResize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkImageResize.setMargin(new java.awt.Insets(0, 0, 0, 0));

        chkImageConvertToGray.setSelected(true);
        chkImageConvertToGray.setText("Convert to ILiad grayscale");
        chkImageConvertToGray.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkImageConvertToGray.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkImageConvertToGray.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkImageConvertToGrayActionPerformed(evt);
            }
        });

        chkFillBackground.setText("Fill background with");
        chkFillBackground.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkFillBackground.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkFillBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkFillBackgroundActionPerformed(evt);
            }
        });

        cmbFillBackgroundColor.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "#000000 (Black)", "#111111", "#222222", "#333333", "#444444", "#555555 (Dark Grey)", "#666666", "#777777", "#888888", "#999999", "#AAAAAA (Light Grey)", "#BBBBBB", "#CCCCCC", "#DDDDDD", "#EEEEEE", "#FFFFFF (White)" }));
        cmbFillBackgroundColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbFillBackgroundColorActionPerformed(evt);
            }
        });

        chkNegative.setText("Negative");
        chkNegative.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkNegative.setMargin(new java.awt.Insets(0, 0, 0, 0));
        chkNegative.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkNegativeActionPerformed(evt);
            }
        });

        lblImageExample.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblImageExample.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/cross.png")));
        lblImageExample.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 255)));
        lblImageExample.setMaximumSize(new java.awt.Dimension(69, 93));
        lblImageExample.setMinimumSize(new java.awt.Dimension(69, 93));
        lblImageExample.setPreferredSize(new java.awt.Dimension(69, 93));

        lblImageExampleNote.setText("<html>Note: the image preview is  the 69 x 93 px format.</html>");

        org.jdesktop.layout.GroupLayout pnlManifestLayout = new org.jdesktop.layout.GroupLayout(pnlManifest);
        pnlManifest.setLayout(pnlManifestLayout);
        pnlManifestLayout.setHorizontalGroup(
            pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlManifestLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblTitle)
                    .add(lblDescription)
                    .add(lblIcon))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblImageExampleNote, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 254, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, pnlManifestLayout.createSequentialGroup()
                        .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, tfTitle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 523, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, scrDescription, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 523, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, pnlManifestLayout.createSequentialGroup()
                                .add(lblImageExample, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 69, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(chkNegative)
                                    .add(pnlManifestLayout.createSequentialGroup()
                                        .add(chkFillBackground)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(cmbFillBackgroundColor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 111, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                    .add(chkImageResize)
                                    .add(chkImageConvertToGray)))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, tfImage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 523, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnImageBrowse)))
                .addContainerGap())
        );
        pnlManifestLayout.setVerticalGroup(
            pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnlManifestLayout.createSequentialGroup()
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblTitle)
                    .add(tfTitle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblDescription)
                    .add(scrDescription, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 54, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblIcon)
                    .add(tfImage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnImageBrowse))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnlManifestLayout.createSequentialGroup()
                        .add(chkImageResize)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(chkImageConvertToGray)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnlManifestLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(chkFillBackground)
                            .add(cmbFillBackgroundColor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(chkNegative))
                    .add(lblImageExample, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lblImageExampleNote, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        chkResetPosition.setText("Reset current position");
        chkResetPosition.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        chkResetPosition.setMargin(new java.awt.Insets(0, 0, 0, 0));

        btnCreateManifest.setText("Create manifest");
        btnCreateManifest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCreateManifestActionPerformed(evt);
            }
        });

        btnExit.setText("Exit");
        btnExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnExitActionPerformed(evt);
            }
        });

        lblWarning.setIcon(new javax.swing.ImageIcon(getClass().getResource("/iliadmanifestcreator/res/exclamation.png")));
        lblWarning.setText("The selected file(s) will be moved to a subdirectory!");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, pnlSource, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(chkResetPosition)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(lblWarning))
                    .add(layout.createSequentialGroup()
                        .add(btnCreateManifest)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnExit))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, pnlManifest, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {btnCreateManifest, btnExit}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(pnlSource, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnlManifest, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(chkResetPosition)
                    .add(lblWarning))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 23, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(btnExit)
                    .add(btnCreateManifest))
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnImageBrowseMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_btnImageBrowseMouseClicked
        //get the currently entered path
        File fileSource = new File(tfImage.getText());
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setSelectedFile(fileSource);
        FileFilter ff = new FileFilter() {
            public boolean accept(File f) {
                return f.isDirectory() /*we have to accept directories because otherwise browsing is impossible*/
                       || f.getName().toLowerCase().endsWith(".png")
                       || f.getName().toLowerCase().endsWith(".bmp")
                       || f.getName().toLowerCase().endsWith(".jpg")
                       || f.getName().toLowerCase().endsWith(".gif");
            }
            
            public String getDescription() {
                return "Supported icon files";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        //set the source
        if (nReturnValue==fc.APPROVE_OPTION && fc.getSelectedFile().isFile()) {
            setImage(fc.getSelectedFile().getAbsolutePath(), true);
        }
    }//GEN-LAST:event_btnImageBrowseMouseClicked

    private void btnSourceBrowseMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_btnSourceBrowseMouseClicked
        if (evt.getButton() != evt.BUTTON1)
            return;
        
        //show the file chooser
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setMultiSelectionEnabled(true);
        fc.setSelectedFiles(arrSourceFiles);
        int nReturnValue = fc.showOpenDialog(this);
        //set the source
        if (nReturnValue==fc.APPROVE_OPTION) {
            setSource(fc.getSelectedFiles());
        }
    }//GEN-LAST:event_btnSourceBrowseMouseClicked

    private void tfImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfImageActionPerformed
        setImage(tfImage.getText(), true);
    }//GEN-LAST:event_tfImageActionPerformed

    private void cmbFillBackgroundColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbFillBackgroundColorActionPerformed
        //refresh image if necessary
        if (chkFillBackground.isSelected())
            setImage(tfImage.getText(), false);
    }//GEN-LAST:event_cmbFillBackgroundColorActionPerformed

    private void chkNegativeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkNegativeActionPerformed
        //refresh image
        setImage(tfImage.getText(), false);
    }//GEN-LAST:event_chkNegativeActionPerformed

    private void chkFillBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkFillBackgroundActionPerformed
        //refresh image
        setImage(tfImage.getText(), false);
    }//GEN-LAST:event_chkFillBackgroundActionPerformed

    private void chkImageConvertToGrayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkImageConvertToGrayActionPerformed
        //refresh image
        setImage(tfImage.getText(), false);
    }//GEN-LAST:event_chkImageConvertToGrayActionPerformed

    private void btnCreateManifestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateManifestActionPerformed
        if (imCurrentManifest == null || (isExistingManifest && strCurrentManifest == null))
            return;

        File fileSource = null;
        if (isSourceDirectory)
            fileSource = arrSourceFiles[0];
        else
            fileSource = fStartPage;
        
        if (imCurrentManifest == null || (isExistingManifest && strCurrentManifest == null))
            return;

        //move file/dir & create manifest if necessary
        File[] arrNewSources = null; //to reset the sources at the end
        String strContent = fileSource.isFile() ? imCurrentManifest.strStartPage : ".";
        File dirWithContent = null; //dir with image, manifest and content dir/file
        if (!isExistingManifest ) { //move file(s) to subdir
            if (!isSourceDirectory) {
                //create paths
                dirWithContent = new File(fStartPage.getParentFile(), getFileTitle(fStartPage));
                strContent = fStartPage.getName();

                //set manifest path
                strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();

                //create subdir
                if (!dirWithContent.mkdirs()) {
                    JOptionPane.showMessageDialog(this, "Error while creating the new directory", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }

                //move files to sub dir
                boolean bSuccess = true;
                File fToMove = null, fMoved = null;
                ArrayList lstMovedFiles = new ArrayList();
                for (int nFile = 0; nFile < arrSourceFiles.length; nFile++) {
                    fToMove = arrSourceFiles[nFile];
                    fMoved = new File(dirWithContent, fToMove.getName());
                    lstMovedFiles.add(fMoved);
                    if (!fToMove.renameTo(fMoved)) {
                        bSuccess = false;
                        break;
                    }
                }
                
                if (bSuccess) {
                    arrNewSources = new File[lstMovedFiles.size()];
                    arrNewSources = (File[])lstMovedFiles.toArray(arrNewSources);
                } else {
                    JOptionPane.showMessageDialog(this, "Couldn't move file \"" + fToMove!=null ? fToMove.getAbsolutePath() : "?" + "\" to subdirectory", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            } else {
                arrNewSources = arrSourceFiles; //sources don't change
                dirWithContent = fileSource;
                //set manifest path
                strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();
            }
        } else {
            arrNewSources = arrSourceFiles; //sources don't change
            dirWithContent = new File(strCurrentManifest).getParentFile();
            strContent = fileSource.isFile() ? imCurrentManifest.strStartPage : imCurrentManifest.strDirectoryContent;
        }


        //create image if necessary
        File fileImage = new File(tfImage.getText());
        String strImage = null;
        if (fileImage != null && fileImage.exists()) {
            //save only the filename (not the path)
            strImage = fileImage.getName();
            
            //make sure it starts with a '.' (so it will be hidden)
            if (strImage.charAt(0) != '.')
                strImage = '.' + strImage;

            //create the image
            BufferedImage img = ImageTools.readImage(fileImage);
            if (chkImageResize.isSelected())
                img = ImageTools.scaleImage(img, 69, 93);
            if (chkNegative.isSelected())
                img = ImageTools.negative(img);
            if (chkFillBackground.isSelected())
                img = ImageTools.replaceAlphaByColor(img, iLiadColors[cmbFillBackgroundColor.getSelectedIndex()]);
            if (chkImageConvertToGray.isSelected())
                img = ImageTools.convertTo4bitGrayScale(img);
            
            //save the image
            String strImageDest = new File(dirWithContent, strImage).getAbsolutePath();
            if (!ImageTools.writeImage(img, "png", strImageDest))
                strImage = null;
        }
        
        //update manifest
        imCurrentManifest.strTitle = tfTitle.getText();
        imCurrentManifest.strDescription = taDescription.getText();
        imCurrentManifest.strImage = strImage;
        if (isSourceDirectory)
            imCurrentManifest.strDirectoryContent = strContent;
        else
            imCurrentManifest.strStartPage = strContent;

        if (isExistingManifest && chkResetPosition.isSelected())
            imCurrentManifest.resetCurrentPosition();
        
        //save it
        if ( !imCurrentManifest.save(strCurrentManifest) ) {
            JOptionPane.showMessageDialog(this, "Error while writing manifest file", "Error", JOptionPane.ERROR_MESSAGE);
            setSource(null);
            return;
        } else {
            //refresh sources (they could have been moved)
            //add manifest to the source files
            File[] arr = new File[arrNewSources.length+1];
            arr[0] = new File(strCurrentManifest);
            for (int nFile=0; nFile<arrNewSources.length; nFile++)
                arr[nFile+1] = arrNewSources[nFile];
            setSource(arr);
        }
    }//GEN-LAST:event_btnCreateManifestActionPerformed

    private void btnExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnExitActionPerformed
        //post a WINDOW_CLOSING msg to simulate click on 'close' button (in the title bar)
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }//GEN-LAST:event_btnExitActionPerformed
    
    /**
     *Sets the source file/directory, reads the manifest if there is already one present, 
     *and updates all fields accordingly.
     *@param arrSources array with source files.<br>
     */
    private void setSource(File[] arrSources) {
        //clear current data
        DefaultListModel dlm = new DefaultListModel();
        dlm.removeAllElements();
        lstSourceFiles.setModel(dlm);
        DefaultComboBoxModel cmStartPages = ((DefaultComboBoxModel)cmbStartPage.getModel());
        cmStartPages.removeAllElements();
        
        //check sources
        if (arrSources == null || arrSources.length == 0) {
            chkResetPosition.setVisible(true);
            lblWarning.setVisible(false);
            setImage("", true);
            btnCreateManifest.setEnabled(false);
            return;
        }
            
        //check if the selection is a directory
        boolean bSourceIsDir = (arrSources.length == 1 && arrSources[0].isDirectory());
        
        //check if we are editing a manifest
        boolean bEditManifest = false;
        File fExistingManifest = null;
        if (bSourceIsDir) {
            //check if the dir contains a manifest
            File fTemp = new File(arrSources[0], "manifest.xml");
            bEditManifest = fTemp.isFile();
            if (bEditManifest)
                fExistingManifest = fTemp;
        }
        else {
            //check if one of the selected files is a manifest
            for (int nFile = 0; nFile < arrSources.length; nFile++) {
                bEditManifest = arrSources[nFile].getName().equalsIgnoreCase("manifest.xml");
                if (bEditManifest) {
                    fExistingManifest = arrSources[nFile];
                    break;
                }
            }
        }
        
        //if we are editing a manifest, change the sources accordingly
        ILiadManifest imExisting = null;
        if (bEditManifest) {
            imExisting = new ILiadManifest(fExistingManifest.getAbsolutePath());
            
            //check if the manifest describes a dir
            if ((imExisting.strStartPage==null || imExisting.strStartPage.length()==0) && 
                    (imExisting.strDirectoryContent!=null && imExisting.strDirectoryContent.length()>0)) {
                //set the source to the manifest's parent dir
                bSourceIsDir = true;
                arrSources = new File[1];
                arrSources[0] = fExistingManifest.getParentFile();
                //note: we don't check if the DirectoryContent is actually valid ... should we do this?
            } else {
                //sources = all files in dir (except manifest & icon)
                bSourceIsDir = false;
                File fDir = fExistingManifest.getParentFile();
                final File fManifest = fExistingManifest;
                final File fImage;
                if (imExisting.strImage != null && imExisting.strImage.length() > 0)
                    fImage = new File(fExistingManifest.getParentFile().getAbsolutePath(), imExisting.strImage);
                else
                    fImage = null;
                
                arrSources = fDir.listFiles(new java.io.FileFilter() {
                    public boolean accept(File f) {
                        return !f.equals(fImage) && !f.equals(fManifest);
                    }
                });
            }
        }
        
        //add files to list & combobox
        for (int nFile=0; nFile<arrSources.length; nFile++) {
            dlm.addElement(arrSources[nFile]);
            cmStartPages.addElement(arrSources[nFile]);
        }
        
        //show startpage selection if necessary
        boolean bShowSelectStartPage = (!bSourceIsDir && arrSources.length > 0);
        cmbStartPage.setVisible(bShowSelectStartPage);
        lblStartPage.setVisible(bShowSelectStartPage);
        cmbStartPage.setEnabled(arrSources.length > 1);
            
        
        //select start page
        File fStartPage = null;
        if (bEditManifest && imExisting != null) {
            if (imExisting.strStartPage != null && imExisting.strStartPage.length() > 0)
                fStartPage = new File(fExistingManifest.getParentFile(), imExisting.strStartPage);
        } else {
            if (arrSources.length == 1) {
                //select item and disable combo
                fStartPage = arrSources[0];
                cmbStartPage.setEnabled(false);
            } else {
                cmbStartPage.setEnabled(true);
                //make a guess:
                // select .pdf if any
                for (int nFile = 0; nFile < arrSources.length; nFile++) {
                    if (arrSources[nFile].getName().toLowerCase().endsWith(".pdf"))
                        fStartPage = arrSources[nFile];
                }
                // select .mobi if any
                if (fStartPage == null) {
                    for (int nFile = 0; nFile < arrSources.length; nFile++) {
                        if (arrSources[nFile].getName().toLowerCase().endsWith(".pdf"))
                            fStartPage = arrSources[nFile];
                    }
                }
                // select .prc if any
                if (fStartPage == null) {
                    for (int nFile = 0; nFile < arrSources.length; nFile++) {
                        if (arrSources[nFile].getName().toLowerCase().endsWith(".pdf"))
                            fStartPage = arrSources[nFile];
                    }
                }
                // select first file otherwise
                if (fStartPage == null)
                    fStartPage = arrSources[0];
            }
        }
        cmbStartPage.setSelectedItem(fStartPage);
        
        //resize list
        scrSourceFiles.validate();
        if (arrSources.length == 1) {
            lstSourceFiles.setVisibleRowCount(scrSourceFiles.getHorizontalScrollBar().isVisible() ? 2 : 1);
            scrSourceFiles.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        } else {
            lstSourceFiles.setVisibleRowCount(5);
            scrSourceFiles.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        }
        
        
        //open / create manifest
        if (bEditManifest) {
            strCurrentManifest = fExistingManifest.getAbsolutePath();
            isExistingManifest = true;
            isSourceDirectory = bSourceIsDir;
            arrSourceFiles = arrSources;
            this.fStartPage = fStartPage;
            
            chkResetPosition.setVisible(!bSourceIsDir);
            lblWarning.setVisible(false);
            //set manifest
            imCurrentManifest = imExisting;
            //set display
            tfTitle.setText(imCurrentManifest.strTitle);
            taDescription.setText(imCurrentManifest.strDescription);
            setImage(fExistingManifest.getParent() + File.separator + imCurrentManifest.strImage, false);
            btnCreateManifest.setText("Save Manifest");
        } else {
            strCurrentManifest = null;
            isExistingManifest = false;
            isSourceDirectory = bSourceIsDir;
            arrSourceFiles = arrSources;
            this.fStartPage = fStartPage;
            
            chkResetPosition.setVisible(false);
            lblWarning.setVisible(!bSourceIsDir);
            //create new manifest
            imCurrentManifest = new ILiadManifest();
            //set display
            tfTitle.setText(getFileTitle(fStartPage));
            taDescription.setText("");
            setImage("", false);
            btnCreateManifest.setText("Create Manifest");
        }
        
        //enable save button
        btnCreateManifest.setEnabled(true);
        
        updateSize();
    }
    
    /**
     *Get the file title of the given file. This is the filename without extension
     *@param file A java.io.File object
     */
    private String getFileTitle(File file) {
        if (file == null)
            return null;
                
        String strFile = file.getName();
        int nExtPos = strFile.lastIndexOf('.');
        if (nExtPos >= 0)
            return strFile.substring(0, nExtPos);
        else
            return strFile;
    }

    /**
     *Sets the image, updates the preview and shows/hides warnings as necessary
     *@param strImage Full path to the image source
     */
    private void setImage(String strImage, boolean bResizeNow) {
        boolean bResize = false;
        if (new File(strImage).isFile()) { //it should exist and be a file
            tfImage.setText(strImage);
            bResize = !lblImageExampleNote.isVisible();
            lblImageExampleNote.setVisible(true);
            
            BufferedImage imgOrg = ImageTools.readImage(new File(strImage));
            //always scale the image
            BufferedImage imgPreview = ImageTools.scaleImage(imgOrg, 69, 93);
            if (chkNegative.isSelected())
                imgPreview = ImageTools.negative(imgPreview);
            if (chkFillBackground.isSelected())
                imgPreview = ImageTools.replaceAlphaByColor(imgPreview, iLiadColors[cmbFillBackgroundColor.getSelectedIndex()]);
            if (chkImageConvertToGray.isSelected())
                imgPreview = ImageTools.convertTo4bitGrayScale(imgPreview);
            
            lblImageExample.setIcon(new ImageIcon(imgPreview));
        }
        else {
            tfImage.setText("");
            lblImageExample.setIcon(new ImageIcon(getClass().getResource("/iliadmanifestcreator/res/cross.png")));
            bResize = lblImageExampleNote.isVisible();
            lblImageExampleNote.setVisible(false);
        }
        
        if (bResize && bResizeNow)
            updateSize();
    }
    
    private void updateSize() {
        pnlManifest.invalidate();
        invalidate();
        pack();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        pack();
    }

    // Drag & drop support
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        //note: dragging text is supported by swing, so we handle only dragging of files.
        try {
            //Get the dropped object and try to figure out what it is
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                // Accept copy drops...
                dtde.acceptDrop(DnDConstants.ACTION_COPY);

                // And set the sources
                List lst = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (lst != null && !lst.isEmpty()) {
                    if (dtde.getSource()==dtSource)
                        setSource((File[])lst.toArray());
                    else if (dtde.getSource()==dtImage)
                        setImage(((File)lst.get(0)).getAbsolutePath(), true);
                }

                // If we made it this far, everything worked.
                dtde.dropComplete(true);
            }
        } catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCreateManifest;
    private javax.swing.JButton btnExit;
    private javax.swing.JLabel btnImageBrowse;
    private javax.swing.JLabel btnSourceBrowse;
    private javax.swing.JCheckBox chkFillBackground;
    private javax.swing.JCheckBox chkImageConvertToGray;
    private javax.swing.JCheckBox chkImageResize;
    private javax.swing.JCheckBox chkNegative;
    private javax.swing.JCheckBox chkResetPosition;
    private javax.swing.JComboBox cmbFillBackgroundColor;
    private javax.swing.JComboBox cmbStartPage;
    private javax.swing.JLabel lblDescription;
    private javax.swing.JLabel lblExplanation;
    private javax.swing.JLabel lblIcon;
    private javax.swing.JLabel lblImageExample;
    private javax.swing.JLabel lblImageExampleNote;
    private javax.swing.JLabel lblSource;
    private javax.swing.JLabel lblStartPage;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JLabel lblWarning;
    private javax.swing.JList lstSourceFiles;
    private javax.swing.JPanel pnlManifest;
    private javax.swing.JPanel pnlSource;
    private javax.swing.JScrollPane scrDescription;
    private javax.swing.JScrollPane scrSourceFiles;
    private javax.swing.JTextArea taDescription;
    private javax.swing.JTextField tfImage;
    private javax.swing.JTextField tfTitle;
    // End of variables declaration//GEN-END:variables
    
}
