/*
 * Decompiled with CFR 0.152.
 */
package iliadmanifestcreator;

import iliadmanifestcreator.ILiadManifest;
import iliadmanifestcreator.ImageTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class MainFrame
extends JFrame
implements DropTargetListener {
    final Color[] iLiadColors = new Color[]{new Color(0), new Color(0x111111), new Color(0x222222), new Color(0x333333), new Color(0x444444), new Color(0x555555), new Color(0x666666), new Color(0x777777), new Color(0x888888), new Color(0x999999), new Color(0xAAAAAA), new Color(0xBBBBBB), new Color(0xCCCCCC), new Color(0xDDDDDD), new Color(0xEEEEEE), new Color(0xFFFFFF)};
    ILiadManifest imCurrentManifest;
    String strCurrentManifest;
    boolean isExistingManifest;
    boolean isSourceDirectory;
    File[] arrSourceFiles;
    File fStartPage;
    DropTarget dtSource;
    DropTarget dtImage;
    private JButton btnCreateManifest;
    private JButton btnExit;
    private JLabel btnImageBrowse;
    private JLabel btnSourceBrowse;
    private JCheckBox chkFillBackground;
    private JCheckBox chkImageConvertToGray;
    private JCheckBox chkImageResize;
    private JCheckBox chkNegative;
    private JCheckBox chkResetPosition;
    private JComboBox cmbFillBackgroundColor;
    private JComboBox cmbStartPage;
    private JLabel lblDescription;
    private JLabel lblExplanation;
    private JLabel lblIcon;
    private JLabel lblImageExample;
    private JLabel lblImageExampleNote;
    private JLabel lblSource;
    private JLabel lblStartPage;
    private JLabel lblTitle;
    private JLabel lblWarning;
    private JList lstSourceFiles;
    private JPanel pnlManifest;
    private JPanel pnlSource;
    private JScrollPane scrDescription;
    private JScrollPane scrSourceFiles;
    private JTextArea taDescription;
    private JTextField tfImage;
    private JTextField tfTitle;

    public MainFrame() {
        this.initComponents();
        this.lblStartPage.setVisible(false);
        this.cmbStartPage.setVisible(false);
        this.chkResetPosition.setVisible(true);
        this.lblWarning.setVisible(false);
        this.lblImageExampleNote.setVisible(false);
        this.btnCreateManifest.setEnabled(false);
        this.updateSize();
        this.dtSource = new DropTarget(this.lstSourceFiles, this);
        this.dtImage = new DropTarget(this.tfImage, this);
    }

    private void initComponents() {
        this.pnlSource = new JPanel();
        this.lblExplanation = new JLabel();
        this.lblSource = new JLabel();
        this.scrSourceFiles = new JScrollPane();
        this.lstSourceFiles = new JList();
        this.btnSourceBrowse = new JLabel();
        this.lblStartPage = new JLabel();
        this.cmbStartPage = new JComboBox();
        this.pnlManifest = new JPanel();
        this.lblTitle = new JLabel();
        this.lblDescription = new JLabel();
        this.lblIcon = new JLabel();
        this.tfTitle = new JTextField();
        this.scrDescription = new JScrollPane();
        this.taDescription = new JTextArea();
        this.tfImage = new JTextField();
        this.btnImageBrowse = new JLabel();
        this.chkImageResize = new JCheckBox();
        this.chkImageConvertToGray = new JCheckBox();
        this.chkFillBackground = new JCheckBox();
        this.cmbFillBackgroundColor = new JComboBox();
        this.chkNegative = new JCheckBox();
        this.lblImageExample = new JLabel();
        this.lblImageExampleNote = new JLabel();
        this.chkResetPosition = new JCheckBox();
        this.btnCreateManifest = new JButton();
        this.btnExit = new JButton();
        this.lblWarning = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("iLiad Manifest Creator (v2.0)");
        this.setResizable(false);
        this.pnlSource.setBorder(BorderFactory.createTitledBorder("Source"));
        this.pnlSource.setToolTipText("Browse ...");
        this.lblExplanation.setText("<html>Notes:<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- To edit a manifest: select the directory containing the manifest, or the manifest file itself.<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- To create a manifest: select the directory or file(s).<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- If the selection contains a manifest, that one will be edited.\n</html>");
        this.lblSource.setText("Source(s):");
        this.lblSource.setMaximumSize(new Dimension(50, 16));
        this.lblSource.setMinimumSize(new Dimension(50, 16));
        this.lblSource.setPreferredSize(new Dimension(50, 16));
        this.lstSourceFiles.setVisibleRowCount(1);
        this.scrSourceFiles.setViewportView(this.lstSourceFiles);
        this.btnSourceBrowse.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/folder_magnify.png")));
        this.btnSourceBrowse.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.btnSourceBrowseMouseClicked(evt);
            }
        });
        this.lblStartPage.setText("Start Page: ");
        GroupLayout pnlSourceLayout = new GroupLayout(this.pnlSource);
        this.pnlSource.setLayout(pnlSourceLayout);
        pnlSourceLayout.setHorizontalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().addContainerGap().add(pnlSourceLayout.createParallelGroup(1).add(this.lblExplanation, -1, 606, Short.MAX_VALUE).add(pnlSourceLayout.createSequentialGroup().add(pnlSourceLayout.createParallelGroup(1).add(this.lblStartPage).add(this.lblSource, -2, -1, -2)).addPreferredGap(0).add(pnlSourceLayout.createParallelGroup(2).add(this.scrSourceFiles, -1, 524, Short.MAX_VALUE).add(this.cmbStartPage, 0, 524, Short.MAX_VALUE)).addPreferredGap(0).add(this.btnSourceBrowse))).addContainerGap()));
        pnlSourceLayout.setVerticalGroup(pnlSourceLayout.createParallelGroup(1).add(pnlSourceLayout.createSequentialGroup().add(this.lblExplanation).addPreferredGap(0).add(pnlSourceLayout.createParallelGroup(1).add(this.btnSourceBrowse).add(pnlSourceLayout.createSequentialGroup().add(pnlSourceLayout.createParallelGroup(1).add(this.scrSourceFiles, -2, -1, -2).add(this.lblSource, -2, -1, -2)).addPreferredGap(0).add(pnlSourceLayout.createParallelGroup(3).add(this.lblStartPage).add(this.cmbStartPage, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlManifest.setBorder(BorderFactory.createTitledBorder("Manifest"));
        this.lblTitle.setLabelFor(this.tfTitle);
        this.lblTitle.setText("Title:");
        this.lblDescription.setLabelFor(this.taDescription);
        this.lblDescription.setText("Description:");
        this.lblIcon.setLabelFor(this.tfImage);
        this.lblIcon.setText("Image:");
        this.scrDescription.setHorizontalScrollBarPolicy(31);
        this.taDescription.setColumns(20);
        this.taDescription.setFont(new Font("Tahoma", 0, 11));
        this.taDescription.setRows(3);
        this.taDescription.setMargin(new Insets(1, 5, 2, 4));
        this.scrDescription.setViewportView(this.taDescription);
        this.tfImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.tfImageActionPerformed(evt);
            }
        });
        this.btnImageBrowse.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/folder_magnify.png")));
        this.btnImageBrowse.setToolTipText("Browse ...");
        this.btnImageBrowse.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.btnImageBrowseMouseClicked(evt);
            }
        });
        this.chkImageResize.setSelected(true);
        this.chkImageResize.setText("Resize to 69 x 93 pixels");
        this.chkImageResize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkImageResize.setMargin(new Insets(0, 0, 0, 0));
        this.chkImageConvertToGray.setSelected(true);
        this.chkImageConvertToGray.setText("Convert to ILiad grayscale");
        this.chkImageConvertToGray.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkImageConvertToGray.setMargin(new Insets(0, 0, 0, 0));
        this.chkImageConvertToGray.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkImageConvertToGrayActionPerformed(evt);
            }
        });
        this.chkFillBackground.setText("Fill background with");
        this.chkFillBackground.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkFillBackground.setMargin(new Insets(0, 0, 0, 0));
        this.chkFillBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkFillBackgroundActionPerformed(evt);
            }
        });
        this.cmbFillBackgroundColor.setModel(new DefaultComboBoxModel<String>(new String[]{"#000000 (Black)", "#111111", "#222222", "#333333", "#444444", "#555555 (Dark Grey)", "#666666", "#777777", "#888888", "#999999", "#AAAAAA (Light Grey)", "#BBBBBB", "#CCCCCC", "#DDDDDD", "#EEEEEE", "#FFFFFF (White)"}));
        this.cmbFillBackgroundColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.cmbFillBackgroundColorActionPerformed(evt);
            }
        });
        this.chkNegative.setText("Negative");
        this.chkNegative.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkNegative.setMargin(new Insets(0, 0, 0, 0));
        this.chkNegative.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.chkNegativeActionPerformed(evt);
            }
        });
        this.lblImageExample.setHorizontalAlignment(0);
        this.lblImageExample.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/cross.png")));
        this.lblImageExample.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 255)));
        this.lblImageExample.setMaximumSize(new Dimension(69, 93));
        this.lblImageExample.setMinimumSize(new Dimension(69, 93));
        this.lblImageExample.setPreferredSize(new Dimension(69, 93));
        this.lblImageExampleNote.setText("<html>Note: the image preview is  the 69 x 93 px format.</html>");
        GroupLayout pnlManifestLayout = new GroupLayout(this.pnlManifest);
        this.pnlManifest.setLayout(pnlManifestLayout);
        pnlManifestLayout.setHorizontalGroup(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().addContainerGap().add(pnlManifestLayout.createParallelGroup(1).add(this.lblTitle).add(this.lblDescription).add(this.lblIcon)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(this.lblImageExampleNote, -2, 254, -2).add(2, pnlManifestLayout.createSequentialGroup().add(pnlManifestLayout.createParallelGroup(2).add(1, this.tfTitle, -1, 523, Short.MAX_VALUE).add(1, this.scrDescription, -1, 523, Short.MAX_VALUE).add(1, pnlManifestLayout.createSequentialGroup().add(this.lblImageExample, -2, 69, -2).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(this.chkNegative).add(pnlManifestLayout.createSequentialGroup().add(this.chkFillBackground).addPreferredGap(0).add(this.cmbFillBackgroundColor, -2, 111, -2)).add(this.chkImageResize).add(this.chkImageConvertToGray))).add(1, this.tfImage, -1, 523, Short.MAX_VALUE)).addPreferredGap(0).add(this.btnImageBrowse))).addContainerGap()));
        pnlManifestLayout.setVerticalGroup(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().add(pnlManifestLayout.createParallelGroup(3).add(this.lblTitle).add(this.tfTitle, -2, -1, -2)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(this.lblDescription).add(this.scrDescription, -2, 54, -2)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(3).add(this.lblIcon).add(this.tfImage, -2, -1, -2).add(this.btnImageBrowse)).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(1).add(pnlManifestLayout.createSequentialGroup().add(this.chkImageResize).addPreferredGap(0).add(this.chkImageConvertToGray).addPreferredGap(0).add(pnlManifestLayout.createParallelGroup(3).add(this.chkFillBackground).add(this.cmbFillBackgroundColor, -2, -1, -2)).addPreferredGap(0).add(this.chkNegative)).add(this.lblImageExample, -2, 93, -2)).addPreferredGap(0).add(this.lblImageExampleNote, -1, -1, Short.MAX_VALUE)));
        this.chkResetPosition.setText("Reset current position");
        this.chkResetPosition.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkResetPosition.setMargin(new Insets(0, 0, 0, 0));
        this.btnCreateManifest.setText("Create manifest");
        this.btnCreateManifest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCreateManifestActionPerformed(evt);
            }
        });
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnExitActionPerformed(evt);
            }
        });
        this.lblWarning.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/exclamation.png")));
        this.lblWarning.setText("The selected file(s) will be moved to a subdirectory!");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.pnlSource, -1, -1, Short.MAX_VALUE).add(1, layout.createSequentialGroup().add(10, 10, 10).add(this.chkResetPosition).addPreferredGap(0).add(this.lblWarning)).add(layout.createSequentialGroup().add(this.btnCreateManifest).addPreferredGap(0).add(this.btnExit)).add(1, this.pnlManifest, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.btnCreateManifest, this.btnExit}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.pnlSource, -2, -1, -2).addPreferredGap(0).add(this.pnlManifest, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.chkResetPosition).add(this.lblWarning)).addPreferredGap(0, 23, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.btnExit).add(this.btnCreateManifest)).addContainerGap()));
        this.pack();
    }

    private void btnImageBrowseMouseClicked(MouseEvent evt) {
        File fileSource = new File(this.tfImage.getText());
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(2);
        fc.setSelectedFile(fileSource);
        javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".bmp") || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".gif");
            }

            public String getDescription() {
                return "Supported icon files";
            }
        };
        fc.setFileFilter(ff);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue == 0 && fc.getSelectedFile().isFile()) {
            this.setImage(fc.getSelectedFile().getAbsolutePath(), true);
        }
    }

    private void btnSourceBrowseMouseClicked(MouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setSelectedFiles(this.arrSourceFiles);
        int nReturnValue = fc.showOpenDialog(this);
        if (nReturnValue == 0) {
            this.setSource(fc.getSelectedFiles());
        }
    }

    private void tfImageActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText(), true);
    }

    private void cmbFillBackgroundColorActionPerformed(ActionEvent evt) {
        if (this.chkFillBackground.isSelected()) {
            this.setImage(this.tfImage.getText(), false);
        }
    }

    private void chkNegativeActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText(), false);
    }

    private void chkFillBackgroundActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText(), false);
    }

    private void chkImageConvertToGrayActionPerformed(ActionEvent evt) {
        this.setImage(this.tfImage.getText(), false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void btnCreateManifestActionPerformed(ActionEvent evt) {
        File dirWithContent;
        String strContent;
        File[] arrNewSources;
        block22: {
            ArrayList<File> lstMovedFiles;
            File fMoved;
            File fToMove;
            boolean bSuccess;
            block21: {
                File fileSource;
                block19: {
                    block20: {
                        if (this.imCurrentManifest == null || this.isExistingManifest && this.strCurrentManifest == null) {
                            return;
                        }
                        fileSource = null;
                        fileSource = this.isSourceDirectory ? this.arrSourceFiles[0] : this.fStartPage;
                        if (this.imCurrentManifest == null || this.isExistingManifest && this.strCurrentManifest == null) {
                            return;
                        }
                        arrNewSources = null;
                        strContent = fileSource.isFile() ? this.imCurrentManifest.strStartPage : ".";
                        dirWithContent = null;
                        if (this.isExistingManifest) break block19;
                        if (this.isSourceDirectory) break block20;
                        dirWithContent = new File(this.fStartPage.getParentFile(), this.getFileTitle(this.fStartPage));
                        strContent = this.fStartPage.getName();
                        this.strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();
                        if (!dirWithContent.mkdirs()) {
                            JOptionPane.showMessageDialog(this, "Error while creating the new directory", "Error", 0);
                            return;
                        }
                        bSuccess = true;
                        fToMove = null;
                        fMoved = null;
                        lstMovedFiles = new ArrayList<File>();
                        break block21;
                    }
                    arrNewSources = this.arrSourceFiles;
                    dirWithContent = fileSource;
                    this.strCurrentManifest = new File(dirWithContent, "manifest.xml").getAbsolutePath();
                    break block22;
                }
                arrNewSources = this.arrSourceFiles;
                dirWithContent = new File(this.strCurrentManifest).getParentFile();
                strContent = fileSource.isFile() ? this.imCurrentManifest.strStartPage : this.imCurrentManifest.strDirectoryContent;
                break block22;
            }
            for (int nFile = 0; nFile < this.arrSourceFiles.length; ++nFile) {
                fToMove = this.arrSourceFiles[nFile];
                fMoved = new File(dirWithContent, fToMove.getName());
                lstMovedFiles.add(fMoved);
                if (fToMove.renameTo(fMoved)) continue;
                bSuccess = false;
                break;
            }
            if (bSuccess) {
                arrNewSources = new File[lstMovedFiles.size()];
                arrNewSources = lstMovedFiles.toArray(arrNewSources);
            } else {
                JOptionPane.showMessageDialog(this, "Couldn't move file \"" + fToMove != null ? fToMove.getAbsolutePath() : "?\" to subdirectory", "Error", 0);
                return;
            }
        }
        File fileImage = new File(this.tfImage.getText());
        String strImage = null;
        if (fileImage != null && fileImage.exists()) {
            String strImageDest;
            strImage = fileImage.getName();
            if (strImage.charAt(0) != '.') {
                strImage = '.' + strImage;
            }
            BufferedImage img = ImageTools.readImage(fileImage);
            if (this.chkImageResize.isSelected()) {
                img = ImageTools.scaleImage(img, 69, 93);
            }
            if (this.chkNegative.isSelected()) {
                img = ImageTools.negative(img);
            }
            if (this.chkFillBackground.isSelected()) {
                img = ImageTools.replaceAlphaByColor(img, this.iLiadColors[this.cmbFillBackgroundColor.getSelectedIndex()]);
            }
            if (this.chkImageConvertToGray.isSelected()) {
                img = ImageTools.convertTo4bitGrayScale(img);
            }
            if (!ImageTools.writeImage(img, "png", strImageDest = new File(dirWithContent, strImage).getAbsolutePath())) {
                strImage = null;
            }
        }
        this.imCurrentManifest.strTitle = this.tfTitle.getText();
        this.imCurrentManifest.strDescription = this.taDescription.getText();
        this.imCurrentManifest.strImage = strImage;
        if (this.isSourceDirectory) {
            this.imCurrentManifest.strDirectoryContent = strContent;
        } else {
            this.imCurrentManifest.strStartPage = strContent;
        }
        if (this.isExistingManifest && this.chkResetPosition.isSelected()) {
            this.imCurrentManifest.resetCurrentPosition();
        }
        if (!this.imCurrentManifest.save(this.strCurrentManifest)) {
            JOptionPane.showMessageDialog(this, "Error while writing manifest file", "Error", 0);
            this.setSource(null);
            return;
        }
        File[] arr = new File[arrNewSources.length + 1];
        arr[0] = new File(this.strCurrentManifest);
        int nFile = 0;
        while (true) {
            if (nFile >= arrNewSources.length) {
                this.setSource(arr);
                return;
            }
            arr[nFile + 1] = arrNewSources[nFile];
            ++nFile;
        }
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        Toolkit t = Toolkit.getDefaultToolkit();
        EventQueue eq = t.getSystemEventQueue();
        eq.postEvent(new WindowEvent(this, 201));
    }

    private void setSource(File[] arrSources) {
        File fExistingManifest;
        boolean bEditManifest;
        boolean bSourceIsDir;
        DefaultComboBoxModel cmStartPages;
        DefaultListModel<File> dlm;
        block22: {
            block21: {
                dlm = new DefaultListModel<File>();
                dlm.removeAllElements();
                this.lstSourceFiles.setModel(dlm);
                cmStartPages = (DefaultComboBoxModel)this.cmbStartPage.getModel();
                cmStartPages.removeAllElements();
                if (arrSources == null || arrSources.length == 0) {
                    this.chkResetPosition.setVisible(true);
                    this.lblWarning.setVisible(false);
                    this.setImage("", true);
                    this.btnCreateManifest.setEnabled(false);
                    return;
                }
                bSourceIsDir = arrSources.length == 1 && arrSources[0].isDirectory();
                bEditManifest = false;
                fExistingManifest = null;
                if (!bSourceIsDir) break block21;
                File fTemp = new File(arrSources[0], "manifest.xml");
                bEditManifest = fTemp.isFile();
                if (!bEditManifest) break block22;
                fExistingManifest = fTemp;
                break block22;
            }
            for (int nFile = 0; nFile < arrSources.length; ++nFile) {
                bEditManifest = arrSources[nFile].getName().equalsIgnoreCase("manifest.xml");
                if (!bEditManifest) continue;
                fExistingManifest = arrSources[nFile];
                break;
            }
        }
        ILiadManifest imExisting = null;
        if (bEditManifest) {
            imExisting = new ILiadManifest(fExistingManifest.getAbsolutePath());
            if ((imExisting.strStartPage == null || imExisting.strStartPage.length() == 0) && imExisting.strDirectoryContent != null && imExisting.strDirectoryContent.length() > 0) {
                bSourceIsDir = true;
                arrSources = new File[]{fExistingManifest.getParentFile()};
            } else {
                bSourceIsDir = false;
                File fDir = fExistingManifest.getParentFile();
                final File fManifest = fExistingManifest;
                final File fImage = imExisting.strImage != null && imExisting.strImage.length() > 0 ? new File(fExistingManifest.getParentFile().getAbsolutePath(), imExisting.strImage) : null;
                arrSources = fDir.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return !f.equals(fImage) && !f.equals(fManifest);
                    }
                });
            }
        }
        for (int nFile = 0; nFile < arrSources.length; ++nFile) {
            dlm.addElement(arrSources[nFile]);
            cmStartPages.addElement(arrSources[nFile]);
        }
        boolean bShowSelectStartPage = !bSourceIsDir && arrSources.length > 0;
        this.cmbStartPage.setVisible(bShowSelectStartPage);
        this.lblStartPage.setVisible(bShowSelectStartPage);
        this.cmbStartPage.setEnabled(arrSources.length > 1);
        File fStartPage = null;
        if (bEditManifest && imExisting != null) {
            if (imExisting.strStartPage != null && imExisting.strStartPage.length() > 0) {
                fStartPage = new File(fExistingManifest.getParentFile(), imExisting.strStartPage);
            }
        } else if (arrSources.length == 1) {
            fStartPage = arrSources[0];
            this.cmbStartPage.setEnabled(false);
        } else {
            int nFile;
            this.cmbStartPage.setEnabled(true);
            for (nFile = 0; nFile < arrSources.length; ++nFile) {
                if (!arrSources[nFile].getName().toLowerCase().endsWith(".pdf")) continue;
                fStartPage = arrSources[nFile];
            }
            if (fStartPage == null) {
                for (nFile = 0; nFile < arrSources.length; ++nFile) {
                    if (!arrSources[nFile].getName().toLowerCase().endsWith(".pdf")) continue;
                    fStartPage = arrSources[nFile];
                }
            }
            if (fStartPage == null) {
                for (nFile = 0; nFile < arrSources.length; ++nFile) {
                    if (!arrSources[nFile].getName().toLowerCase().endsWith(".pdf")) continue;
                    fStartPage = arrSources[nFile];
                }
            }
            if (fStartPage == null) {
                fStartPage = arrSources[0];
            }
        }
        this.cmbStartPage.setSelectedItem(fStartPage);
        this.scrSourceFiles.validate();
        if (arrSources.length == 1) {
            this.lstSourceFiles.setVisibleRowCount(this.scrSourceFiles.getHorizontalScrollBar().isVisible() ? 2 : 1);
            this.scrSourceFiles.setVerticalScrollBarPolicy(21);
        } else {
            this.lstSourceFiles.setVisibleRowCount(5);
            this.scrSourceFiles.setVerticalScrollBarPolicy(20);
        }
        if (bEditManifest) {
            this.strCurrentManifest = fExistingManifest.getAbsolutePath();
            this.isExistingManifest = true;
            this.isSourceDirectory = bSourceIsDir;
            this.arrSourceFiles = arrSources;
            this.fStartPage = fStartPage;
            this.chkResetPosition.setVisible(!bSourceIsDir);
            this.lblWarning.setVisible(false);
            this.imCurrentManifest = imExisting;
            this.tfTitle.setText(this.imCurrentManifest.strTitle);
            this.taDescription.setText(this.imCurrentManifest.strDescription);
            this.setImage(fExistingManifest.getParent() + File.separator + this.imCurrentManifest.strImage, false);
            this.btnCreateManifest.setText("Save Manifest");
        } else {
            this.strCurrentManifest = null;
            this.isExistingManifest = false;
            this.isSourceDirectory = bSourceIsDir;
            this.arrSourceFiles = arrSources;
            this.fStartPage = fStartPage;
            this.chkResetPosition.setVisible(false);
            this.lblWarning.setVisible(!bSourceIsDir);
            this.imCurrentManifest = new ILiadManifest();
            this.tfTitle.setText(this.getFileTitle(fStartPage));
            this.taDescription.setText("");
            this.setImage("", false);
            this.btnCreateManifest.setText("Create Manifest");
        }
        this.btnCreateManifest.setEnabled(true);
        this.updateSize();
    }

    private String getFileTitle(File file) {
        if (file == null) {
            return null;
        }
        String strFile = file.getName();
        int nExtPos = strFile.lastIndexOf(46);
        if (nExtPos >= 0) {
            return strFile.substring(0, nExtPos);
        }
        return strFile;
    }

    private void setImage(String strImage, boolean bResizeNow) {
        boolean bResize = false;
        if (new File(strImage).isFile()) {
            this.tfImage.setText(strImage);
            bResize = !this.lblImageExampleNote.isVisible();
            this.lblImageExampleNote.setVisible(true);
            BufferedImage imgOrg = ImageTools.readImage(new File(strImage));
            BufferedImage imgPreview = ImageTools.scaleImage(imgOrg, 69, 93);
            if (this.chkNegative.isSelected()) {
                imgPreview = ImageTools.negative(imgPreview);
            }
            if (this.chkFillBackground.isSelected()) {
                imgPreview = ImageTools.replaceAlphaByColor(imgPreview, this.iLiadColors[this.cmbFillBackgroundColor.getSelectedIndex()]);
            }
            if (this.chkImageConvertToGray.isSelected()) {
                imgPreview = ImageTools.convertTo4bitGrayScale(imgPreview);
            }
            this.lblImageExample.setIcon(new ImageIcon(imgPreview));
        } else {
            this.tfImage.setText("");
            this.lblImageExample.setIcon(new ImageIcon(this.getClass().getResource("/iliadmanifestcreator/res/cross.png")));
            bResize = this.lblImageExampleNote.isVisible();
            this.lblImageExampleNote.setVisible(false);
        }
        if (bResize && bResizeNow) {
            this.updateSize();
        }
    }

    private void updateSize() {
        this.pnlManifest.invalidate();
        this.invalidate();
        this.pack();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.pack();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                List lst = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (lst != null && !lst.isEmpty()) {
                    if (dtde.getSource() == this.dtSource) {
                        this.setSource((File[])lst.toArray());
                    } else if (dtde.getSource() == this.dtImage) {
                        this.setImage(((File)lst.get(0)).getAbsolutePath(), true);
                    }
                }
                dtde.dropComplete(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }
}

