/*
 * Decompiled with CFR 0.152.
 */
package iliadmanifestcreator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ILiadManifest {
    static final int MANIFEST_NO_TYPE = 0;
    static final int MANIFEST_FILE = 1;
    static final int MANIFEST_DIRECTORY = 2;
    static final Pattern TagsPattern = Pattern.compile("\\</?[a-zA-Z\\-]+ ?/?\\>", 136);
    static final SimpleDateFormat sdfDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    XPath xPath = XPathFactory.newInstance().newXPath();
    public String strTitle = null;
    public String strDescription = null;
    public Date dDate = null;
    public String strStartPage = null;
    public String strImage = null;
    public String strDirectoryContent = null;
    private Document docManifestXml = null;

    public ILiadManifest(int nManifestType) {
        this.createEmptyDocument(nManifestType);
    }

    public ILiadManifest() {
        this.dDate = new Date();
    }

    public ILiadManifest(String strManifestFile) {
        this.readFromFile(strManifestFile);
    }

    public boolean save(String fullPathFilename) {
        if (!this.checkDocument()) {
            return false;
        }
        return this.writeToFile(fullPathFilename);
    }

    public void resetCurrentPosition() {
        if (this.docManifestXml == null) {
            return;
        }
        try {
            Element ePosition = (Element)this.xPath.evaluate("/package/last-location/pagenumber", this.docManifestXml, XPathConstants.NODE);
            if (ePosition != null) {
                ePosition.setTextContent("1");
            }
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
    }

    protected boolean createEmptyDocument(int nManifestType) {
        if (nManifestType != 1 && nManifestType != 2) {
            return false;
        }
        try {
            if (this.docManifestXml == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.docManifestXml = db.newDocument();
            } else {
                this.docManifestXml.removeChild(this.docManifestXml.getDocumentElement());
            }
            Element eRoot = this.docManifestXml.createElement("package");
            this.docManifestXml.appendChild(eRoot);
            Element eMetaData = this.docManifestXml.createElement("metadata");
            eRoot.appendChild(eMetaData);
            Element eDcMetaData = this.docManifestXml.createElement("dc-metadata");
            eMetaData.appendChild(eDcMetaData);
            eDcMetaData.appendChild(this.docManifestXml.createElement("Title"));
            eDcMetaData.appendChild(this.docManifestXml.createElement("Description"));
            eDcMetaData.appendChild(this.docManifestXml.createElement("Date"));
            Element eYMetaData = this.docManifestXml.createElement("y-metadata");
            eMetaData.appendChild(eYMetaData);
            eYMetaData.appendChild(this.docManifestXml.createElement("image"));
            switch (nManifestType) {
                case 1: {
                    eYMetaData.appendChild(this.docManifestXml.createElement("startpage"));
                    break;
                }
                case 2: {
                    Element eDirectory = this.docManifestXml.createElement("directory");
                    eRoot.appendChild(eDirectory);
                    eDirectory.appendChild(this.docManifestXml.createElement("content"));
                }
            }
            this.dDate = new Date();
            return true;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected boolean checkDocument() {
        try {
            Element eStartPage;
            Element eImage;
            Element eYMetaData;
            Element eDate;
            Element eDescription;
            Element eTitle;
            Element eDcMetaData;
            Element eMetaData;
            Element eRoot;
            if (this.docManifestXml == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.docManifestXml = db.newDocument();
            }
            if ((eRoot = (Element)this.xPath.evaluate("/package", this.docManifestXml, XPathConstants.NODE)) == null) {
                eRoot = (Element)this.docManifestXml.appendChild(this.docManifestXml.createElement("package"));
            }
            if ((eMetaData = (Element)this.xPath.evaluate("/package/metadata", this.docManifestXml, XPathConstants.NODE)) == null) {
                eMetaData = (Element)eRoot.appendChild(this.docManifestXml.createElement("metadata"));
            }
            if ((eDcMetaData = (Element)this.xPath.evaluate("/package/metadata/dc-metadata", this.docManifestXml, XPathConstants.NODE)) == null) {
                eDcMetaData = (Element)eMetaData.appendChild(this.docManifestXml.createElement("dc-metadata"));
            }
            if ((eTitle = (Element)this.xPath.evaluate("/package/metadata/dc-metadata/Title", this.docManifestXml, XPathConstants.NODE)) == null && this.strTitle != null && this.strTitle.length() > 0) {
                eTitle = (Element)eDcMetaData.appendChild(this.docManifestXml.createElement("Title"));
            }
            if ((eDescription = (Element)this.xPath.evaluate("/package/metadata/dc-metadata/Description", this.docManifestXml, XPathConstants.NODE)) == null && this.strDescription != null && this.strDescription.length() > 0) {
                eDescription = (Element)eDcMetaData.appendChild(this.docManifestXml.createElement("Description"));
            }
            if ((eDate = (Element)this.xPath.evaluate("/package/metadata/dc-metadata/Date", this.docManifestXml, XPathConstants.NODE)) == null && this.dDate != null) {
                eDate = (Element)eDcMetaData.appendChild(this.docManifestXml.createElement("Date"));
            }
            if ((eYMetaData = (Element)this.xPath.evaluate("/package/metadata/y-metadata", this.docManifestXml, XPathConstants.NODE)) == null) {
                eYMetaData = (Element)eMetaData.appendChild(this.docManifestXml.createElement("y-metadata"));
            }
            if ((eImage = (Element)this.xPath.evaluate("/package/metadata/y-metadata/image", this.docManifestXml, XPathConstants.NODE)) == null && this.strImage != null && this.strImage.length() > 0) {
                eImage = (Element)eYMetaData.appendChild(this.docManifestXml.createElement("image"));
            }
            if ((eStartPage = (Element)this.xPath.evaluate("/package/metadata/y-metadata/startpage", this.docManifestXml, XPathConstants.NODE)) == null && this.strStartPage != null && this.strStartPage.length() > 0) {
                eStartPage = (Element)eYMetaData.appendChild(this.docManifestXml.createElement("startpage"));
            }
            if (this.strDirectoryContent != null && this.strDirectoryContent.length() > 0) {
                Element eContent;
                Element eDirectory = (Element)this.xPath.evaluate("/package/directory", this.docManifestXml, XPathConstants.NODE);
                if (eDirectory == null) {
                    eDirectory = (Element)eRoot.appendChild(this.docManifestXml.createElement("directory"));
                }
                if ((eContent = (Element)this.xPath.evaluate("/package/directory/content", this.docManifestXml, XPathConstants.NODE)) == null) {
                    eContent = (Element)eDirectory.appendChild(this.docManifestXml.createElement("content"));
                }
            }
            return true;
        }
        catch (DOMException ex) {
            ex.printStackTrace();
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    protected boolean writeToFile(String strFullPathFilename) {
        try {
            if (!this.saveParametersToManifest()) {
                return false;
            }
            this.docManifestXml.normalizeDocument();
            DOMSource source = new DOMSource(this.docManifestXml);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            FileOutputStream fos = new FileOutputStream(strFullPathFilename);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(writer.toString().replace("#####", "&#10;"));
            osw.close();
            return true;
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    protected boolean readFromFile(String strManifestXml) {
        if (strManifestXml == null || strManifestXml.length() == 0) {
            return false;
        }
        try {
            File file = new File(strManifestXml);
            if (!file.exists()) {
                return false;
            }
            String strManifestText = ILiadManifest.readTextFile(strManifestXml);
            strManifestText = strManifestText.trim();
            strManifestText = strManifestText.replaceAll("[ \t\r\n]+", " ");
            strManifestText = strManifestText.replaceAll("> <", "><");
            strManifestText = strManifestText.replace("&#13;", "&#10;");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.docManifestXml = db.parse(new InputSource(new StringReader(strManifestText)));
            this.docManifestXml.getDocumentElement().normalize();
            return this.loadParametersFromManifest(this.docManifestXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean saveParametersToManifest() {
        try {
            Node node = null;
            node = (Node)this.xPath.evaluate("/package/metadata/dc-metadata/Title", this.docManifestXml, XPathConstants.NODE);
            if (node != null) {
                node.setTextContent(this.strTitle.replace("\n", "#####"));
            }
            if ((node = (Node)this.xPath.evaluate("/package/metadata/dc-metadata/Description", this.docManifestXml, XPathConstants.NODE)) != null) {
                node.setTextContent(this.strDescription.replace("\n", "#####"));
            }
            if ((node = (Node)this.xPath.evaluate("/package/metadata/dc-metadata/Date", this.docManifestXml, XPathConstants.NODE)) != null && this.dDate != null) {
                node.setTextContent(sdfDateFormat.format(this.dDate));
            }
            if ((node = (Node)this.xPath.evaluate("/package/metadata/y-metadata/startpage", this.docManifestXml, XPathConstants.NODE)) != null) {
                node.setTextContent(this.strStartPage);
            }
            if ((node = (Node)this.xPath.evaluate("/package/metadata/y-metadata/image", this.docManifestXml, XPathConstants.NODE)) != null) {
                node.setTextContent(this.strImage);
            }
            if ((node = (Node)this.xPath.evaluate("/package/directory/content", this.docManifestXml, XPathConstants.NODE)) != null) {
                node.setTextContent(this.strDirectoryContent);
            }
            return true;
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean loadParametersFromManifest(Document docManifestXml) {
        try {
            Object xResult = null;
            this.strTitle = (String)this.xPath.evaluate("/package/metadata/dc-metadata/Title/text()", docManifestXml, XPathConstants.STRING);
            this.strDescription = (String)this.xPath.evaluate("/package/metadata/dc-metadata/Description/text()", docManifestXml, XPathConstants.STRING);
            xResult = this.xPath.evaluate("/package/metadata/dc-metadata/Date/text()", docManifestXml, XPathConstants.STRING);
            if (xResult != null) {
                try {
                    this.dDate = sdfDateFormat.parse((String)xResult);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.strStartPage = (String)this.xPath.evaluate("/package/metadata/y-metadata/startpage/text()", docManifestXml, XPathConstants.STRING);
            this.strImage = (String)this.xPath.evaluate("package/metadata/y-metadata/image/text()", docManifestXml, XPathConstants.STRING);
            this.strDirectoryContent = (String)this.xPath.evaluate("/package/directory/content/text()", docManifestXml, XPathConstants.STRING);
            return true;
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static String readTextFile(String fullPathFilename) {
        try {
            FileInputStream fis = new FileInputStream(fullPathFilename);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            StringBuffer sb = new StringBuffer(1024);
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) > -1) {
                sb.append(String.valueOf(chars));
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static String replaceTagseWithLowerCase(String strSource) {
        StringBuffer sbSource = new StringBuffer();
        Matcher TagMatcher = TagsPattern.matcher(strSource);
        while (TagMatcher.find()) {
            TagMatcher.appendReplacement(sbSource, TagMatcher.group().toLowerCase());
        }
        TagMatcher.appendTail(sbSource);
        return sbSource.toString();
    }
}

