/*
 * Decompiled with CFR 0.152.
 */
package iliadmanifestcreator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageTools {
    static byte[] baILiadColors = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -120, -103, -86, -69, -52, -35, -18, -1};

    public static BufferedImage scaleImage(BufferedImage imgSource, int nFitWidth, int nFitHeight) {
        int nWidth;
        int nHeight;
        double nFitRatio;
        if (nFitWidth <= 0 || nFitHeight <= 0) {
            throw new IllegalArgumentException("width and height must be larger than 0!");
        }
        int nImgWidth = imgSource.getWidth();
        int nImgHeight = imgSource.getHeight();
        double nImgRatio = 1.0 * (double)nImgHeight / (double)nImgWidth;
        if (nImgRatio > (nFitRatio = 1.0 * (double)nFitHeight / (double)nFitWidth)) {
            nHeight = nFitHeight;
            nWidth = (int)((double)nFitHeight / nImgRatio);
        } else {
            nHeight = (int)((double)nFitWidth * nImgRatio);
            nWidth = nFitWidth;
        }
        int nXPos = (nFitWidth - nWidth) / 2;
        int nYPos = (nFitHeight - nHeight) / 2;
        Image imgScaled = imgSource.getScaledInstance(nWidth, nHeight, 4);
        BufferedImage biScaled = new BufferedImage(nFitWidth, nFitHeight, 2);
        Graphics2D big = biScaled.createGraphics();
        big.drawImage(imgScaled, nXPos, nYPos, nWidth, nHeight, null);
        big.dispose();
        return biScaled;
    }

    public static BufferedImage replaceAlphaByColor(BufferedImage imgSource, Color c) {
        int nWidth = imgSource.getWidth();
        int nHeight = imgSource.getHeight();
        BufferedImage biNew = new BufferedImage(nWidth, nHeight, 1);
        Graphics2D g = biNew.createGraphics();
        g.setColor(c);
        g.fillRect(0, 0, nWidth, nHeight);
        g.drawImage(imgSource, 0, 0, nWidth, nHeight, null);
        g.dispose();
        return biNew;
    }

    public static BufferedImage negative(BufferedImage imgSource) {
        byte[] reverse = new byte[256];
        for (int i = 0; i < 256; ++i) {
            reverse[i] = (byte)(255 - i);
        }
        ByteLookupTable lookupTable = new ByteLookupTable(0, reverse);
        LookupOp lop = new LookupOp(lookupTable, null);
        return lop.filter(imgSource, null);
    }

    public static BufferedImage convertTo4bitGrayScale(BufferedImage imgSource) {
        BufferedImage imgGray = ImageTools.convertToGrayScale(imgSource);
        IndexColorModel icm = new IndexColorModel(4, 16, baILiadColors, baILiadColors, baILiadColors);
        BufferedImage bi4Bit = new BufferedImage(imgSource.getWidth(), imgSource.getHeight(), 12, icm);
        Graphics2D g = bi4Bit.createGraphics();
        g.drawRenderedImage(imgGray, null);
        g.dispose();
        return bi4Bit;
    }

    public static BufferedImage convertToGrayScale(BufferedImage imgSource) {
        int nWidth = imgSource.getWidth();
        int nHeight = imgSource.getHeight();
        BufferedImage imgGray = new BufferedImage(nWidth, nHeight, 10);
        WritableRaster raster = imgGray.getRaster().createCompatibleWritableRaster();
        for (int y = 0; y < nHeight; ++y) {
            for (int x = 0; x < nWidth; ++x) {
                int rgb = imgSource.getRGB(x, y);
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                int gray = (int)(0.212671 * (double)r + 0.71516 * (double)g + 0.072169 * (double)b);
                raster.setSample(x, y, 0, gray);
            }
        }
        imgGray.setData(raster);
        return imgGray;
    }

    public static BufferedImage convertToGrayScale_old(BufferedImage imgSource) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage biTemp = op.filter(imgSource, null);
        return biTemp;
    }

    public static BufferedImage readImage(File file) {
        try {
            BufferedImage biOrg = ImageIO.read(file);
            int w = biOrg.getWidth();
            int h = biOrg.getHeight();
            BufferedImage biNew = new BufferedImage(w, h, 1);
            Graphics2D g = biNew.createGraphics();
            g.drawRenderedImage(biOrg, null);
            g.dispose();
            return biNew;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean writeImage(BufferedImage img, String strFormat, String strFile) {
        try {
            return ImageIO.write((RenderedImage)img, strFormat, new FileOutputStream(strFile));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

