/*
 * Decompiled with CFR 0.152.
 */
package jecomics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jecomics.ImagesTableModel;
import jecomics.JEAboutBox;
import jecomics.JECEngine.JECCallBack;
import jecomics.JECEngine.JECComicProject;
import jecomics.JECEngine.JECImage;
import jecomics.JECEngine.JECImageZip;
import jecomics.JECEngine.JECOutputA4;
import jecomics.JECEngine.JECOutputIliad;
import jecomics.JECEngine.JECOutputIliadFullScreen;
import jecomics.JECEngine.JECOutputSonyPRS500;
import jecomics.JECEngine.JECOutputSonyPRS505;
import jecomics.JECEngine.JECOutputType;
import jecomics.JECEngine.JECThreadedEngine;
import jecomics.JECZipFile;
import jecomics.JEImagePanel;
import jecomics.JESupportedFilesFilter;
import jecomics.JESupportedPackagesFilter;
import jecomics.MainFrameCB;
import jecomics.PDFFilesFilter;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MainFrame
extends JFrame {
    protected JECImage csel = null;
    private MainFrameCB CB = null;
    private boolean working = false;
    public static final String AppName = "JE-Comics " + JECComicProject.getEngineVersion();
    public JECComicProject Project = null;
    private JMenuItem AboutMenuItem;
    private JButton AddDirectoryButton;
    private JMenuItem AddDirectoryMenuItem;
    private JButton AddFilesButton;
    private JMenuItem AddFilesMenuItem;
    private JButton AddPackageButton;
    private JMenuItem AddPackageMenuItem;
    private JPanel BrightnessPanel;
    private JSlider BrightnessSlider;
    private JMenuItem ClearListItem;
    private JToggleButton ComicsMode;
    private ButtonGroup CompressionModeGroup;
    private JRadioButton ContrEnLow;
    private JRadioButton ContrEnMild;
    private JRadioButton ContrEnNone;
    private JRadioButton ContrEnStrong;
    private ButtonGroup ContrastEnhance;
    private JPanel ContrastPanel;
    private JMenuItem DeleteMenuItem;
    private JTextField DocumentAuthorText;
    private JTextField DocumentTitleText;
    private JCheckBox ErrorDiffCB;
    private JMenuItem ExitMenuItem;
    private JMenu FileMenu;
    private JPanel FilesPanel;
    private JPanel FilterPrefsPanel;
    private JPanel FiltersPanel;
    private JButton GenerateButton;
    private JMenu HelpMenu;
    private JTable ImagesList;
    private JPopupMenu ImagesMenu;
    private JLabel InfoBoxLabel;
    private JScrollPane ListScrollPanel;
    private JRadioButton LosslessRadio;
    private JRadioButton LossyRadio;
    private JTabbedPane MainFrameTabs;
    private JMenuBar MainMenuBar;
    private JProgressBar MainProgressBar;
    private JToolBar MainToolBar;
    private JToggleButton MangaMode;
    private JPanel OtherPrefs;
    private JComboBox OutPutType;
    private JPanel OutTextPanel;
    private JTextArea OutputText;
    private JScrollPane OutputTextScroll;
    private JButton PreviewButton;
    private JPanel PreviewPanel;
    private JScrollPane PreviewScroll;
    private JPanel PreviewSizedPanel;
    private JPanel ProgressPanel;
    private JPanel PropertiesPanel;
    private ButtonGroup RotateGroup;
    private JSeparator RotateSeparator;
    private JMenuItem SelectAllMenu;
    private JSeparator SelectSeparator;
    private JMenuItem SetRotateLeftToSelectedMenu;
    private JMenuItem SetRotateRightToSelectedMenu;
    private JMenuItem SetSplitToSelectedMenuItem;
    private JCheckBox SharpCB;
    private JCheckBox SmoothCB;
    private ButtonGroup SplitModeGroup;
    private JPanel SplitModePanel;
    private JSeparator SplitSeparator;
    private JPanel StatusPanel;
    private JMenuItem UnSetRotateToSelectedMenu;
    private JMenuItem UnSetSplitToSelectedMenuItem;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public void addOutputLine(String line) {
        if (line != null) {
            this.OutputText.setText(this.OutputText.getText() + line + "\n");
        }
        this.OutputText.setCaretPosition(this.OutputText.getText().length());
        this.repaint();
    }

    public void setProgress(int progress) {
        this.MainProgressBar.setValue(progress);
    }

    public void setInfoBoxLabel(String text) {
        this.InfoBoxLabel.setText(text);
    }

    public JECCallBack getCB() {
        return this.CB;
    }

    public void updateList() {
        this.ImagesList.setModel(new ImagesTableModel(this.Project));
        this.initColumnSizes(this.ImagesList);
    }

    public MainFrame() {
        this.initComponents();
        this.CB = new MainFrameCB(this);
        this.Project = new JECComicProject(this.CB);
        this.OutPutType.addItem(new JECOutputIliad());
        this.OutPutType.addItem(new JECOutputIliadFullScreen());
        this.OutPutType.addItem(new JECOutputA4());
        this.OutPutType.addItem(new JECOutputSonyPRS500());
        this.OutPutType.addItem(new JECOutputSonyPRS505());
        this.OutPutType.setSelectedIndex(0);
        this.updateList();
    }

    private void initComponents() {
        this.ImagesMenu = new JPopupMenu();
        this.SelectAllMenu = new JMenuItem();
        this.SelectSeparator = new JSeparator();
        this.SetRotateLeftToSelectedMenu = new JMenuItem();
        this.SetRotateRightToSelectedMenu = new JMenuItem();
        this.UnSetRotateToSelectedMenu = new JMenuItem();
        this.RotateSeparator = new JSeparator();
        this.SetSplitToSelectedMenuItem = new JMenuItem();
        this.UnSetSplitToSelectedMenuItem = new JMenuItem();
        this.SplitSeparator = new JSeparator();
        this.DeleteMenuItem = new JMenuItem();
        this.SplitModeGroup = new ButtonGroup();
        this.RotateGroup = new ButtonGroup();
        this.CompressionModeGroup = new ButtonGroup();
        this.ContrastEnhance = new ButtonGroup();
        this.MainFrameTabs = new JTabbedPane();
        this.FilesPanel = new JPanel();
        this.ListScrollPanel = new JScrollPane();
        this.ImagesList = new JTable(){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e2) {
                        Object tip = null;
                        Point p2 = e2.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p2.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return ImagesTableModel.getColumnHint(realIndex);
                    }
                };
            }
        };
        this.PreviewPanel = new JEImagePanel();
        this.PropertiesPanel = new JPanel();
        this.DocumentTitleText = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.DocumentAuthorText = new JTextField();
        this.jPanel1 = new JPanel();
        this.LossyRadio = new JRadioButton();
        this.LosslessRadio = new JRadioButton();
        this.SplitModePanel = new JPanel();
        this.ComicsMode = new JToggleButton();
        this.MangaMode = new JToggleButton();
        this.FiltersPanel = new JPanel();
        this.FilterPrefsPanel = new JPanel();
        this.BrightnessPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.BrightnessSlider = new JSlider();
        this.jLabel5 = new JLabel();
        this.ContrastPanel = new JPanel();
        this.ContrEnNone = new JRadioButton();
        this.ContrEnLow = new JRadioButton();
        this.ContrEnMild = new JRadioButton();
        this.ContrEnStrong = new JRadioButton();
        this.OtherPrefs = new JPanel();
        this.SharpCB = new JCheckBox();
        this.ErrorDiffCB = new JCheckBox();
        this.SmoothCB = new JCheckBox();
        this.PreviewButton = new JButton();
        this.PreviewScroll = new JScrollPane();
        this.PreviewSizedPanel = new JEImagePanel(false);
        this.MainToolBar = new JToolBar();
        this.AddFilesButton = new JButton();
        this.AddDirectoryButton = new JButton();
        this.AddPackageButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.GenerateButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.OutPutType = new JComboBox();
        this.StatusPanel = new JPanel();
        this.OutTextPanel = new JPanel();
        this.OutputTextScroll = new JScrollPane();
        this.OutputText = new JTextArea();
        this.ProgressPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.InfoBoxLabel = new JLabel();
        this.MainProgressBar = new JProgressBar();
        this.MainMenuBar = new JMenuBar();
        this.FileMenu = new JMenu();
        this.AddFilesMenuItem = new JMenuItem();
        this.AddPackageMenuItem = new JMenuItem();
        this.AddDirectoryMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.ClearListItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.ExitMenuItem = new JMenuItem();
        this.HelpMenu = new JMenu();
        this.AboutMenuItem = new JMenuItem();
        this.ImagesMenu.setInvoker(this.ImagesList);
        this.SelectAllMenu.setMnemonic('a');
        this.SelectAllMenu.setText("Select All");
        this.SelectAllMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.SelectAllMenuActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.SelectAllMenu);
        this.ImagesMenu.add(this.SelectSeparator);
        this.SetRotateLeftToSelectedMenu.setText("Set rotate left");
        this.SetRotateLeftToSelectedMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.SetRotateLeftToSelectedMenuActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.SetRotateLeftToSelectedMenu);
        this.SetRotateRightToSelectedMenu.setText("Set rotate right");
        this.SetRotateRightToSelectedMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.SetRotateRightToSelectedMenuActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.SetRotateRightToSelectedMenu);
        this.UnSetRotateToSelectedMenu.setText("Unset Rotate");
        this.UnSetRotateToSelectedMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.UnSetRotateToSelectedMenuActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.UnSetRotateToSelectedMenu);
        this.ImagesMenu.add(this.RotateSeparator);
        this.SetSplitToSelectedMenuItem.setText("Set split");
        this.SetSplitToSelectedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.SetSplitToSelectedMenuItemActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.SetSplitToSelectedMenuItem);
        this.UnSetSplitToSelectedMenuItem.setText("Unset split ");
        this.UnSetSplitToSelectedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.UnSetSplitToSelectedMenuItemActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.UnSetSplitToSelectedMenuItem);
        this.ImagesMenu.add(this.SplitSeparator);
        this.DeleteMenuItem.setText("Delete selected");
        this.DeleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.DeleteMenuItemActionPerformed(evt);
            }
        });
        this.ImagesMenu.add(this.DeleteMenuItem);
        this.setDefaultCloseOperation(3);
        this.setTitle(AppName);
        this.FilesPanel.setLayout(new BorderLayout());
        this.ImagesList.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.ImagesList.setAutoResizeMode(4);
        this.ImagesList.setTableHeader(this.ImagesList.getTableHeader());
        this.ImagesList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainFrame.this.ImagesListKeyReleased(evt);
            }
        });
        this.ImagesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.ImagesListMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                MainFrame.this.ImagesListMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                MainFrame.this.ImagesListMouseReleased(evt);
            }
        });
        this.ListScrollPanel.setViewportView(this.ImagesList);
        this.FilesPanel.add((Component)this.ListScrollPanel, "West");
        this.PreviewPanel.setMinimumSize(new Dimension(150, 10));
        this.PreviewPanel.setPreferredSize(new Dimension(300, 10));
        this.FilesPanel.add((Component)this.PreviewPanel, "Center");
        this.MainFrameTabs.addTab("Images", this.FilesPanel);
        this.PropertiesPanel.setLayout(new AbsoluteLayout());
        this.PropertiesPanel.setMinimumSize(new Dimension(330, 220));
        this.PropertiesPanel.setPreferredSize(new Dimension(330, 220));
        this.DocumentTitleText.setText("Document");
        this.PropertiesPanel.add((Component)this.DocumentTitleText, new AbsoluteConstraints(130, 17, 200, 20));
        this.jLabel1.setDisplayedMnemonic('t');
        this.jLabel1.setLabelFor(this.DocumentTitleText);
        this.jLabel1.setText("Document title:");
        this.PropertiesPanel.add((Component)this.jLabel1, new AbsoluteConstraints(20, 20, -1, -1));
        this.jLabel3.setDisplayedMnemonic('h');
        this.jLabel3.setLabelFor(this.DocumentAuthorText);
        this.jLabel3.setText("Author:");
        this.PropertiesPanel.add((Component)this.jLabel3, new AbsoluteConstraints(20, 40, -1, -1));
        this.PropertiesPanel.add((Component)this.DocumentAuthorText, new AbsoluteConstraints(130, 40, 200, -1));
        this.jPanel1.setBorder(new TitledBorder("Compression Mode"));
        this.CompressionModeGroup.add(this.LossyRadio);
        this.LossyRadio.setMnemonic('y');
        this.LossyRadio.setText("Lossy");
        this.jPanel1.add(this.LossyRadio);
        this.CompressionModeGroup.add(this.LosslessRadio);
        this.LosslessRadio.setMnemonic('s');
        this.LosslessRadio.setSelected(true);
        this.LosslessRadio.setText("Lossless");
        this.jPanel1.add(this.LosslessRadio);
        this.PropertiesPanel.add((Component)this.jPanel1, new AbsoluteConstraints(20, 60, 210, -1));
        this.SplitModePanel.setBorder(new TitledBorder("Split Mode"));
        this.SplitModeGroup.add(this.ComicsMode);
        this.ComicsMode.setIcon(new ImageIcon("/home/kirys/Developing/JE-Comics/Graphics/ComicMode.gif"));
        this.ComicsMode.setMnemonic('S');
        this.ComicsMode.setSelected(true);
        this.ComicsMode.setText("Standard");
        this.ComicsMode.setDoubleBuffered(true);
        this.SplitModePanel.add(this.ComicsMode);
        this.SplitModeGroup.add(this.MangaMode);
        this.MangaMode.setIcon(new ImageIcon("/home/kirys/Developing/JE-Comics/Graphics/MangaMode.gif"));
        this.MangaMode.setMnemonic('M');
        this.MangaMode.setText("Manga");
        this.MangaMode.setDoubleBuffered(true);
        this.SplitModePanel.add(this.MangaMode);
        this.PropertiesPanel.add((Component)this.SplitModePanel, new AbsoluteConstraints(20, 140, 440, 110));
        this.MainFrameTabs.addTab("Properties", this.PropertiesPanel);
        this.FiltersPanel.setLayout(new BorderLayout());
        this.FiltersPanel.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        this.FilterPrefsPanel.setLayout(new GridBagLayout());
        this.FilterPrefsPanel.setMaximumSize(new Dimension(3500, Short.MAX_VALUE));
        this.FilterPrefsPanel.setMinimumSize(new Dimension(300, 72));
        this.FilterPrefsPanel.setPreferredSize(new Dimension(300, 150));
        this.BrightnessPanel.setBorder(new TitledBorder("Brigtness"));
        this.jLabel4.setText("Darker");
        this.BrightnessPanel.add(this.jLabel4);
        this.BrightnessSlider.setMajorTickSpacing(1);
        this.BrightnessSlider.setMaximum(10);
        this.BrightnessSlider.setMinimum(-10);
        this.BrightnessSlider.setPaintTicks(true);
        this.BrightnessSlider.setSnapToTicks(true);
        this.BrightnessSlider.setValue(0);
        this.BrightnessSlider.setPreferredSize(new Dimension(150, 27));
        this.BrightnessPanel.add(this.BrightnessSlider);
        this.jLabel5.setText("Lighter");
        this.BrightnessPanel.add(this.jLabel5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.FilterPrefsPanel.add((Component)this.BrightnessPanel, gridBagConstraints);
        this.ContrastPanel.setBorder(new TitledBorder("Contrast enhance"));
        this.ContrastEnhance.add(this.ContrEnNone);
        this.ContrEnNone.setSelected(true);
        this.ContrEnNone.setText("None");
        this.ContrastPanel.add(this.ContrEnNone);
        this.ContrastEnhance.add(this.ContrEnLow);
        this.ContrEnLow.setText("Low");
        this.ContrastPanel.add(this.ContrEnLow);
        this.ContrastEnhance.add(this.ContrEnMild);
        this.ContrEnMild.setText("Mild");
        this.ContrastPanel.add(this.ContrEnMild);
        this.ContrastEnhance.add(this.ContrEnStrong);
        this.ContrEnStrong.setText("Strong");
        this.ContrastPanel.add(this.ContrEnStrong);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.FilterPrefsPanel.add((Component)this.ContrastPanel, gridBagConstraints);
        this.OtherPrefs.setBorder(new TitledBorder("Other enhancements"));
        this.OtherPrefs.setMinimumSize(new Dimension(100, 58));
        this.OtherPrefs.setPreferredSize(new Dimension(250, 120));
        this.SharpCB.setSelected(true);
        this.SharpCB.setText("Sharpening");
        this.OtherPrefs.add(this.SharpCB);
        this.ErrorDiffCB.setSelected(true);
        this.ErrorDiffCB.setText("Error diffusion shading");
        this.OtherPrefs.add(this.ErrorDiffCB);
        this.SmoothCB.setSelected(true);
        this.SmoothCB.setText("Smart Smooth");
        this.OtherPrefs.add(this.SmoothCB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.FilterPrefsPanel.add((Component)this.OtherPrefs, gridBagConstraints);
        this.PreviewButton.setMnemonic('p');
        this.PreviewButton.setText("Preview");
        this.PreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.PreviewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 14;
        this.FilterPrefsPanel.add((Component)this.PreviewButton, gridBagConstraints);
        this.FiltersPanel.add((Component)this.FilterPrefsPanel, "West");
        this.PreviewScroll.setViewportView(this.PreviewSizedPanel);
        this.FiltersPanel.add((Component)this.PreviewScroll, "Center");
        this.MainFrameTabs.addTab("Filters", this.FiltersPanel);
        this.getContentPane().add((Component)this.MainFrameTabs, "Center");
        this.AddFilesButton.setMnemonic('a');
        this.AddFilesButton.setText("Add files");
        this.AddFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddFilesButtonActionPerformed(evt);
            }
        });
        this.MainToolBar.add(this.AddFilesButton);
        this.AddDirectoryButton.setMnemonic('d');
        this.AddDirectoryButton.setText("Add directory");
        this.AddDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddDirectoryButtonActionPerformed(evt);
            }
        });
        this.MainToolBar.add(this.AddDirectoryButton);
        this.AddPackageButton.setMnemonic('z');
        this.AddPackageButton.setText("Add Zip/Cbz");
        this.AddPackageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddPackageButtonActionPerformed(evt);
            }
        });
        this.MainToolBar.add(this.AddPackageButton);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMaximumSize(new Dimension(3, Short.MAX_VALUE));
        this.jSeparator1.setPreferredSize(new Dimension(3, 0));
        this.MainToolBar.add(this.jSeparator1);
        this.GenerateButton.setMnemonic('g');
        this.GenerateButton.setText("Generate");
        this.GenerateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.GenerateButtonActionPerformed(evt);
            }
        });
        this.MainToolBar.add(this.GenerateButton);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setMaximumSize(new Dimension(2, 1000));
        this.MainToolBar.add(this.jSeparator3);
        this.jLabel2.setDisplayedMnemonic('t');
        this.jLabel2.setLabelFor(this.OutPutType);
        this.jLabel2.setText(" Output type:");
        this.MainToolBar.add(this.jLabel2);
        this.MainToolBar.add(this.OutPutType);
        this.getContentPane().add((Component)this.MainToolBar, "North");
        this.StatusPanel.setLayout(new BorderLayout());
        this.OutTextPanel.setLayout(new BorderLayout());
        this.OutTextPanel.setPreferredSize(new Dimension(10, 90));
        this.OutputTextScroll.setViewportBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.OutputTextScroll.setAutoscrolls(true);
        this.OutputTextScroll.setDoubleBuffered(true);
        this.OutputTextScroll.setPreferredSize(new Dimension(3, 90));
        this.OutputText.setLineWrap(true);
        this.OutputTextScroll.setViewportView(this.OutputText);
        this.OutTextPanel.add((Component)this.OutputTextScroll, "Center");
        this.StatusPanel.add((Component)this.OutTextPanel, "Center");
        this.ProgressPanel.setLayout(new BorderLayout());
        this.jPanel6.setMaximumSize(new Dimension(110, Short.MAX_VALUE));
        this.jPanel6.setMinimumSize(new Dimension(110, 10));
        this.jPanel6.setPreferredSize(new Dimension(110, 10));
        this.InfoBoxLabel.setFont(new Font("Dialog", 0, 10));
        this.jPanel6.add(this.InfoBoxLabel);
        this.ProgressPanel.add((Component)this.jPanel6, "East");
        this.MainProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.MainProgressBar.setMinimumSize(new Dimension(10, 20));
        this.MainProgressBar.setPreferredSize(new Dimension(148, 20));
        this.ProgressPanel.add((Component)this.MainProgressBar, "Center");
        this.StatusPanel.add((Component)this.ProgressPanel, "South");
        this.getContentPane().add((Component)this.StatusPanel, "South");
        this.FileMenu.setMnemonic('F');
        this.FileMenu.setText("File");
        this.AddFilesMenuItem.setMnemonic('A');
        this.AddFilesMenuItem.setText("Add Files");
        this.AddFilesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddFilesButtonActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.AddFilesMenuItem);
        this.AddPackageMenuItem.setMnemonic('z');
        this.AddPackageMenuItem.setText("Add Zip/Cbz");
        this.AddPackageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddPackageButtonActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.AddPackageMenuItem);
        this.AddDirectoryMenuItem.setMnemonic('d');
        this.AddDirectoryMenuItem.setText("Add Directory");
        this.AddDirectoryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AddDirectoryButtonActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.AddDirectoryMenuItem);
        this.FileMenu.add(this.jSeparator4);
        this.ClearListItem.setText("Clear List");
        this.ClearListItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ClearListItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ClearListItem);
        this.FileMenu.add(this.jSeparator2);
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ExitMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ExitMenuItem);
        this.MainMenuBar.add(this.FileMenu);
        this.HelpMenu.setMnemonic('H');
        this.HelpMenu.setText("Help");
        this.AboutMenuItem.setMnemonic('A');
        this.AboutMenuItem.setText("About");
        this.AboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.AboutMenuItemActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.AboutMenuItem);
        this.MainMenuBar.add(this.HelpMenu);
        this.setJMenuBar(this.MainMenuBar);
        this.pack();
    }

    private void AddPackage(String file) {
        this.CB.addMessage("Scanning " + file);
        try {
            JECZipFile zip = new JECZipFile(file);
            int i2 = 0;
            for (i2 = 0; i2 < zip.getCount(); ++i2) {
                this.Project.getImages().addFile(new JECImageZip(zip, i2));
                this.CB.addMessage("Found:" + zip.getFileName(i2));
            }
            this.CB.addMessage("Done.");
        }
        catch (Exception E) {
            this.CB.addMessage(E.getMessage());
        }
    }

    private void AddPackageButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        JESupportedPackagesFilter filter = new JESupportedPackagesFilter();
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this.AddPackageButton);
        if (result == 0) {
            int i2 = 0;
            File[] files = fc.getSelectedFiles();
            for (i2 = 0; i2 < files.length; ++i2) {
                this.AddPackage(files[i2].getAbsolutePath());
            }
            this.Project.getImages().sortMe();
        }
        this.updateList();
    }

    private void PreviewButtonActionPerformed(ActionEvent evt) {
        int i2 = 0;
        if (this.Project.getImages().size() > 0) {
            i2 = this.ImagesList.getSelectedRow();
            if (i2 > this.Project.getImages().size() || i2 < 0) {
                i2 = 0;
            }
            try {
                JECImage input = this.Project.getImages().getFile(i2);
                if (this.storePrefs()) {
                    BufferedImage im = this.Project.generatePreview(input);
                    ((JEImagePanel)this.PreviewSizedPanel).setImage(im);
                } else {
                    ((JEImagePanel)this.PreviewSizedPanel).setImage((BufferedImage)null);
                }
            }
            catch (Exception Ex) {
                this.CB.addMessage(Ex.getMessage());
            }
        }
    }

    private void SetRotateRightToSelectedMenuActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                this.Project.getImages().getFile(k2).setRotateRight(true);
            }
        }
        this.ImagesList.updateUI();
    }

    private void UnSetSplitToSelectedMenuItemActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                this.Project.getImages().getFile(k2).setSplit(false);
            }
        }
        this.ImagesList.updateUI();
    }

    private void SetSplitToSelectedMenuItemActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                this.Project.getImages().getFile(k2).setSplit(true);
            }
        }
        this.ImagesList.updateUI();
    }

    private void ImagesListKeyReleased(KeyEvent evt) {
        this.updateImage();
    }

    private void DeleteMenuItemActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        ArrayList<JECImage> l2 = new ArrayList<JECImage>();
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                l2.add(this.Project.getImages().getFile(k2));
            }
            Iterator it = l2.iterator();
            while (it.hasNext()) {
                this.Project.getImages().remove(it.next());
            }
        }
        this.ImagesList.updateUI();
    }

    private void AboutMenuItemActionPerformed(ActionEvent evt) {
        JEAboutBox Abox = new JEAboutBox((Frame)this, true);
        Abox.setLocationRelativeTo(this);
        Abox.show();
    }

    private void UnSetRotateToSelectedMenuActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                this.Project.getImages().getFile(k2).setRotateLeft(false);
                this.Project.getImages().getFile(k2).setRotateRight(false);
            }
        }
        this.ImagesList.updateUI();
    }

    private void SetRotateLeftToSelectedMenuActionPerformed(ActionEvent evt) {
        int i2 = 0;
        int k2 = 0;
        if (this.ImagesList.getSelectedRowCount() > 0) {
            for (i2 = 0; i2 < this.ImagesList.getSelectedRowCount(); ++i2) {
                k2 = this.ImagesList.getSelectedRows()[i2];
                this.Project.getImages().getFile(k2).setRotateLeft(true);
            }
        }
        this.ImagesList.updateUI();
    }

    private void SelectAllMenuActionPerformed(ActionEvent evt) {
        this.ImagesList.selectAll();
    }

    private void ImagesListMouseReleased(MouseEvent evt) {
        this.showImagesPopup(evt);
    }

    private void ImagesListMousePressed(MouseEvent evt) {
        this.showImagesPopup(evt);
    }

    private void AddDirectoryButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose a directory");
        fc.setFileSelectionMode(1);
        int result = fc.showOpenDialog(this.AddFilesButton);
        if (result == 0) {
            int i2 = 0;
            File f2 = fc.getSelectedFile();
            if (f2.isDirectory()) {
                JESupportedFilesFilter flt = new JESupportedFilesFilter();
                File[] files = f2.listFiles();
                for (i2 = 0; i2 < files.length; ++i2) {
                    if (!files[i2].isFile() || !flt.accept(files[i2])) continue;
                    this.Project.getImages().addFile(files[i2].getAbsolutePath());
                }
                this.Project.getImages().sortMe();
            }
        }
        this.updateList();
    }

    private void ClearListItemActionPerformed(ActionEvent evt) {
        this.Project.getImages().clear();
        this.updateList();
    }

    public void showImagesPopup(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.ImagesMenu.show(e2.getComponent(), e2.getX(), e2.getY());
        }
    }

    public void setWorking(boolean yn) {
        this.repaint();
        this.working = yn;
        this.AddFilesButton.setEnabled(!yn);
        this.AddFilesMenuItem.setEnabled(!yn);
        this.AddDirectoryButton.setEnabled(!yn);
        this.AddDirectoryMenuItem.setEnabled(!yn);
        this.AddPackageButton.setEnabled(!yn);
        this.AddPackageMenuItem.setEnabled(!yn);
        this.GenerateButton.setEnabled(!yn);
        this.ImagesMenu.setEnabled(!yn);
        this.ClearListItem.setEnabled(!yn);
        if (yn) {
            // empty if block
        }
    }

    private boolean isWorking() {
        return this.working;
    }

    private void initColumnSizes(JTable table) {
        ImagesTableModel model = (ImagesTableModel)table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i2 = 0; i2 < model.getColumnCount(); ++i2) {
            column = table.getColumnModel().getColumn(i2);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            cellWidth = model.getPreferredSize(i2);
            column.setPreferredWidth(model.getPreferredSize(i2));
            column.setMaxWidth(model.getMaxSize(i2));
            column.setMinWidth(model.getMinSize(i2));
        }
    }

    private void updateImage() {
        if (this.ImagesList.getSelectedRow() >= 0 && this.Project.getImages().getFile(this.ImagesList.getSelectedRow()) != this.csel) {
            this.csel = this.Project.getImages().getFile(this.ImagesList.getSelectedRow());
            try {
                BufferedImage img = this.Project.getImages().getFile(this.ImagesList.getSelectedRow()).getImage();
                ((JEImagePanel)this.PreviewPanel).setImage(img);
            }
            catch (Exception E) {
                this.CB.addMessage(E.getMessage());
            }
        }
    }

    private void ImagesListMouseClicked(MouseEvent evt) {
        this.updateImage();
    }

    private void ExitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private boolean ConfirmOverwrite(String filename) {
        int response;
        return !new File(filename).exists() || (response = JOptionPane.showConfirmDialog(null, "File '" + filename + "' exists! \nOverwrite existing file?", "Confirm Overwrite", 2, 3)) != 2;
    }

    private boolean storePrefs() {
        this.Project.setTitle(this.DocumentTitleText.getText());
        this.Project.setAuthor(this.DocumentAuthorText.getText());
        this.Project.setLossless(this.LosslessRadio.isSelected());
        this.Project.setBrightness(this.BrightnessSlider.getValue());
        this.Project.setMangaMode(this.MangaMode.isSelected());
        if (this.ContrEnNone.isSelected()) {
            this.Project.setContrast(0);
        } else if (this.ContrEnLow.isSelected()) {
            this.Project.setContrast(1);
        } else if (this.ContrEnMild.isSelected()) {
            this.Project.setContrast(2);
        } else if (this.ContrEnStrong.isSelected()) {
            this.Project.setContrast(3);
        }
        this.Project.setSmartSmooth(this.SmoothCB.isSelected());
        this.Project.setSharpening(this.SharpCB.isSelected());
        this.Project.setErrorDiffusion(this.ErrorDiffCB.isSelected());
        if (this.OutPutType.getSelectedItem() instanceof JECOutputType) {
            this.Project.setOutputType((JECOutputType)this.OutPutType.getSelectedItem());
            return true;
        }
        return false;
    }

    private void GenerateButtonActionPerformed(ActionEvent evt) {
        if (this.Project.getImages().size() <= 0) {
            JOptionPane.showMessageDialog(null, "There is no image to process!");
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        PDFFilesFilter filter = new PDFFilesFilter();
        fc.setFileFilter(filter);
        int result = fc.showSaveDialog(this.AddFilesButton);
        if (result == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath();
            if (filename.toLowerCase().indexOf(".pdf") < filename.length() - 5) {
                filename = filename + ".pdf";
            }
            if (this.ConfirmOverwrite(filename)) {
                this.setWorking(true);
                if (this.storePrefs()) {
                    JECThreadedEngine Engine = new JECThreadedEngine(filename, this.Project);
                    Engine.start();
                } else {
                    this.CB.addMessage("Could not start :(");
                }
            }
        }
    }

    private void AddFilesButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        JESupportedFilesFilter filter = new JESupportedFilesFilter();
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this.AddFilesButton);
        if (result == 0) {
            int i2 = 0;
            File[] files = fc.getSelectedFiles();
            for (i2 = 0; i2 < files.length; ++i2) {
                this.Project.getImages().addFile(files[i2].getAbsolutePath());
            }
            this.Project.getImages().sortMe();
        }
        this.updateList();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

