/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ChunkHandler;
import com.sixlegs.image.png.Chunk_IDAT;
import com.sixlegs.image.png.Chunk_IEND;
import com.sixlegs.image.png.Chunk_IHDR;
import com.sixlegs.image.png.Chunk_PLTE;
import com.sixlegs.image.png.Chunk_tRNS;
import com.sixlegs.image.png.DummyImageConsumer;
import com.sixlegs.image.png.EmptyEnumeration;
import com.sixlegs.image.png.IDATInputStream;
import com.sixlegs.image.png.Interlacer;
import com.sixlegs.image.png.PixelReader;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import com.sixlegs.image.png.TextChunk;
import com.sixlegs.image.png.UnfilterInputStream;
import com.sixlegs.image.png.UserChunk;
import java.awt.Color;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PngImage
implements ImageProducer {
    static boolean allFatal = false;
    static final int BUFFER_SIZE = 8192;
    private static boolean progressive = true;
    private static Hashtable prototypes = new Hashtable();
    static final String ASCII_ENCODING = "US-ASCII";
    static final String LATIN1_ENCODING = "8859_1";
    static final String UTF8_ENCODING = "UTF8";
    static final long DEFAULT_GAMMA = 45455L;
    private static double DISPLAY_EXPONENT = 2.2;
    private static double USER_EXPONENT = 1.0;
    Data data = new Data();
    private Vector errorList;
    public static final int COLOR_TYPE_GRAY = 0;
    public static final int COLOR_TYPE_GRAY_ALPHA = 4;
    public static final int COLOR_TYPE_PALETTE = 3;
    public static final int COLOR_TYPE_RGB = 2;
    public static final int COLOR_TYPE_RGB_ALPHA = 6;
    public static final int INTERLACE_TYPE_NONE = 0;
    public static final int INTERLACE_TYPE_ADAM7 = 1;
    public static final int FILTER_TYPE_BASE = 0;
    public static final int FILTER_TYPE_INTRAPIXEL = 64;
    public static final int COMPRESSION_TYPE_BASE = 0;
    public static final int UNIT_UNKNOWN = 0;
    public static final int UNIT_METER = 1;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_MICROMETER = 1;
    public static final int UNIT_RADIAN = 2;
    public static final int SRGB_PERCEPTUAL = 0;
    public static final int SRGB_RELATIVE_COLORIMETRIC = 1;
    public static final int SRGB_SATURATION_PRESERVING = 2;
    public static final int SRGB_ABSOLUTE_COLORIMETRIC = 3;

    public PngImage(String string) throws IOException {
        this(new BufferedInputStream(new FileInputStream(string), 8192));
    }

    public PngImage(URL uRL) throws IOException {
        this(new BufferedInputStream(uRL.openConnection().getInputStream(), 8192));
    }

    public PngImage(InputStream inputStream) {
        this(inputStream, true);
    }

    public PngImage(InputStream inputStream, boolean bl) {
        this.data.close = bl;
        this.data.properties.put("gamma", new Long(45455L));
        this.data.in_idat = new IDATInputStream(this, inputStream, bl);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        if (this.data.consumers.contains(imageConsumer)) {
            return;
        }
        this.data.consumers.addElement(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return false;
        }
        return this.data.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        this.data.consumers.removeElement(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (this.data == null) {
            throw new IllegalStateException("Object has been flushed.");
        }
        this.addConsumer(imageConsumer);
        Object[] objectArray = new ImageConsumer[this.data.consumers.size()];
        this.data.consumers.copyInto(objectArray);
        this.produceHelper((ImageConsumer[])objectArray);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        if (this.data == null || this.data.pixels == null) {
            return;
        }
        this.startProduction(imageConsumer);
    }

    public static void setUserExponent(double d2) {
        USER_EXPONENT = d2;
    }

    public static void setDisplayExponent(double d2) {
        DISPLAY_EXPONENT = d2;
    }

    public boolean hasErrors() {
        if (this.errorList == null) {
            return false;
        }
        return this.errorList.size() > 0;
    }

    public boolean hasFatalError() {
        return this.hasErrors() && !(this.errorList.elementAt(this.errorList.size() - 1) instanceof PngExceptionSoft);
    }

    public Enumeration getErrors() {
        if (this.errorList == null) {
            return EmptyEnumeration.getInstance();
        }
        return this.errorList.elements();
    }

    public static void setAllErrorsFatal(boolean bl) {
        allFatal = bl;
    }

    public static void setProgressiveDisplay(boolean bl) {
        progressive = bl;
    }

    public Color getBackgroundColor() throws IOException {
        return (Color)this.getProperty("background");
    }

    public int getWidth() throws IOException {
        this.readToData();
        return this.data.header.width;
    }

    public int getHeight() throws IOException {
        this.readToData();
        return this.data.header.height;
    }

    public int getBitDepth() throws IOException {
        this.readToData();
        return this.data.header.depth;
    }

    public int getInterlaceType() throws IOException {
        this.readToData();
        return this.data.header.interlace;
    }

    public int getColorType() throws IOException {
        this.readToData();
        return this.data.header.colorType;
    }

    public boolean hasAlphaChannel() throws IOException {
        this.readToData();
        return this.data.header.alphaUsed;
    }

    public boolean isGrayscale() throws IOException {
        this.readToData();
        return !this.data.header.colorUsed;
    }

    public boolean isIndexedColor() throws IOException {
        this.readToData();
        return this.data.header.paletteUsed;
    }

    public Object getProperty(String string) throws IOException {
        this.readToData();
        return this.data.properties.get(string);
    }

    public Enumeration getProperties() throws IOException {
        this.readToData();
        return this.data.properties.keys();
    }

    public void getEverything() {
        this.startProduction(new DummyImageConsumer());
    }

    public void getEverything(boolean bl) throws IOException {
        this.startProduction(new DummyImageConsumer());
        if (this.hasFatalError()) {
            throw (IOException)this.errorList.elementAt(this.errorList.size() - 1);
        }
    }

    public boolean hasChunk(String string) throws IOException {
        this.readToData();
        return this.data.chunks.get(new Integer(Chunk.stringToType(string))) != null;
    }

    public static void registerChunk(ChunkHandler chunkHandler, String string) throws PngException {
        if (string.length() < 4) {
            throw new PngException("Invalid chunk type length.");
        }
        int n2 = Chunk.stringToType(string);
        if (prototypes.containsKey(new Integer(n2))) {
            throw new PngException("Chunk type already registered.");
        }
        if ((n2 & 0x20000000) == 0) {
            throw new PngException("Chunk must be ancillary.");
        }
        PngImage.registerChunk(new UserChunk(chunkHandler, n2));
    }

    public Enumeration getSuggestedPalettes() throws IOException {
        this.readToData();
        return this.data.palettes.keys();
    }

    public int[][] getSuggestedPalette(String string) throws IOException {
        this.readToData();
        return (int[][])this.data.palettes.get(string);
    }

    public TextChunk getTextChunk(String string) throws IOException {
        this.readToData();
        return (TextChunk)this.data.textChunks.get(string);
    }

    public Enumeration getTextChunks() throws IOException {
        this.readToData();
        return this.data.textChunks.elements();
    }

    public Enumeration getGifExtensions() throws IOException {
        this.readToData();
        return this.data.gifExtensions.elements();
    }

    public void setFlushAfterNextProduction(boolean bl) {
        this.data.useFlush = bl;
    }

    public void setBuffer(int[] nArray) throws IOException {
        if (this.data == null) {
            throw new IllegalStateException("Object has been flushed.");
        }
        int n2 = this.getWidth() * this.getHeight();
        if (nArray.length < n2) {
            throw new IllegalArgumentException("Buffer size must be at least " + n2 + " (W * H)");
        }
        this.data.pixels = nArray;
    }

    private void flush() {
        if (this.data != null) {
            try {
                if (this.data.close) {
                    this.data.in_idat.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = null;
        }
    }

    private synchronized void readToData() throws IOException {
        try {
            if (this.data == null) {
                throw new EOFException("Object has been flushed.");
            }
            this.data.in_idat.readToData();
        }
        catch (PngException pngException) {
            this.addError(pngException);
            throw pngException;
        }
    }

    private static void registerChunk(Chunk chunk) {
        prototypes.put(new Integer(chunk.type), chunk);
    }

    static Chunk getRegisteredChunk(int n2) {
        Integer n3 = new Integer(n2);
        if (prototypes.containsKey(n3)) {
            return ((Chunk)prototypes.get(n3)).copy();
        }
        try {
            String string = "com.sixlegs.image.png.Chunk_" + Chunk.typeToString(n2);
            PngImage.registerChunk((Chunk)Class.forName(string).newInstance());
            return PngImage.getRegisteredChunk(n2);
        }
        catch (Exception exception) {
            return new Chunk(n2);
        }
    }

    Chunk getChunk(int n2) {
        return (Chunk)this.data.chunks.get(new Integer(n2));
    }

    void putChunk(int n2, Chunk chunk) {
        this.data.chunks.put(new Integer(n2), chunk);
    }

    void addError(IOException iOException) {
        if (this.errorList == null) {
            this.errorList = new Vector();
        }
        this.errorList.addElement(iOException);
    }

    void fillGammaTable() {
        try {
            long l2 = (Long)this.getProperty("gamma");
            int n2 = this.data.header.paletteUsed ? 255 : (1 << this.data.header.outputDepth) - 1;
            double d2 = USER_EXPONENT * 100000.0 / ((double)l2 * DISPLAY_EXPONENT);
            for (int i2 = 0; i2 <= n2; ++i2) {
                int n3 = (int)(Math.pow((double)i2 / (double)n2, d2) * 255.0);
                this.data.gammaTable[i2] = !this.data.header.colorUsed ? n3 | n3 << 8 | n3 << 16 : n3;
            }
            if (this.data.palette != null) {
                this.data.palette.calculate();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void produceHelper(ImageConsumer[] imageConsumerArray) {
        try {
            int n2;
            this.readToData();
            for (n2 = 0; n2 < imageConsumerArray.length; ++n2) {
                imageConsumerArray[n2].setDimensions(this.data.header.width, this.data.header.height);
                imageConsumerArray[n2].setProperties(this.data.properties);
                imageConsumerArray[n2].setColorModel(this.data.header.model);
                if (!this.data.produceFailed) continue;
                imageConsumerArray[n2].imageComplete(1);
            }
            if (this.data.produceFailed) {
                return;
            }
            if (!this.data.produced) {
                this.firstProduction(imageConsumerArray);
            } else {
                this.setHints(imageConsumerArray);
                for (n2 = 0; n2 < imageConsumerArray.length; ++n2) {
                    imageConsumerArray[n2].setPixels(0, 0, this.data.header.width, this.data.header.height, this.data.header.model, this.data.pixels, 0, this.data.header.width);
                    imageConsumerArray[n2].imageComplete(3);
                }
            }
        }
        catch (IOException iOException) {
            this.data.produceFailed = true;
            this.addError(iOException);
            for (int i2 = 0; i2 < imageConsumerArray.length; ++i2) {
                imageConsumerArray[i2].imageComplete(1);
            }
        }
        if (this.data.useFlush) {
            this.flush();
        }
    }

    private void firstProduction(ImageConsumer[] imageConsumerArray) throws IOException {
        this.data.produced = true;
        UnfilterInputStream unfilterInputStream = new UnfilterInputStream(this, this.data.in_idat);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(unfilterInputStream, 8192);
        PixelReader pixelReader = new PixelReader(this, bufferedInputStream);
        this.setHints(imageConsumerArray);
        if (this.data.header.interlace == 0) {
            this.produceNonInterlaced(imageConsumerArray, pixelReader);
        } else {
            this.produceInterlaced(imageConsumerArray, pixelReader);
        }
        for (int i2 = 0; i2 < imageConsumerArray.length; ++i2) {
            imageConsumerArray[i2].imageComplete(3);
        }
    }

    private void setHints(ImageConsumer[] imageConsumerArray) {
        for (int i2 = 0; i2 < imageConsumerArray.length; ++i2) {
            if (progressive && this.data.pixels == null && this.data.header.interlace != 0) {
                imageConsumerArray[i2].setHints(1);
                continue;
            }
            imageConsumerArray[i2].setHints(30);
        }
    }

    private void produceNonInterlaced(ImageConsumer[] imageConsumerArray, PixelReader pixelReader) throws IOException {
        int n2 = this.data.header.width;
        int n3 = this.data.header.height;
        if (!this.data.useFlush && this.data.pixels == null) {
            this.data.pixels = new int[n2 * n3];
        }
        int[] nArray = new int[n2 + 8];
        int n4 = n2;
        int n5 = n2 % pixelReader.fillSize;
        if (n5 > 0) {
            n4 += pixelReader.fillSize - n5;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            pixelReader.read(nArray, 0, n4);
            if (this.data.pixels != null) {
                System.arraycopy(nArray, 0, this.data.pixels, n2 * i2, n2);
            }
            for (int i3 = 0; i3 < imageConsumerArray.length; ++i3) {
                imageConsumerArray[i3].setPixels(0, i2, n2, 1, this.data.header.model, nArray, 0, n4);
            }
        }
    }

    private void produceInterlaced(ImageConsumer[] imageConsumerArray, PixelReader pixelReader) throws IOException {
        int n2;
        int n3 = this.data.header.width;
        int n4 = this.data.header.height;
        if (this.data.pixels == null) {
            this.data.pixels = new int[n3 * n4];
        }
        int[] nArray = new int[n3 + 8];
        int n5 = this.data.header.interlacer.numPasses();
        Interlacer interlacer = this.data.header.interlacer;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            int n7;
            int n8 = interlacer.getPassWidth(n2);
            int n9 = n8 % pixelReader.fillSize;
            if (n9 > 0) {
                n8 += pixelReader.fillSize - n9;
            }
            int n10 = progressive ? interlacer.getBlockWidth(n2) : 1;
            int n11 = progressive ? interlacer.getBlockHeight(n2) : 1;
            int n12 = interlacer.getSpacingY(n2);
            int n13 = interlacer.getSpacingX(n2);
            int n14 = n12 * n3;
            int n15 = interlacer.getOffsetX(n2);
            int n16 = n7 * n3;
            for (n7 = interlacer.getOffsetY(n2); n7 < n4; n7 += n12) {
                pixelReader.read(nArray, 0, n8);
                int n17 = 0;
                for (n6 = n15; n6 < n3; n6 += n13) {
                    int n18 = Math.min(n10, n3 - n6);
                    int n19 = Math.min(n11, n4 - n7);
                    int n20 = n16 + n6;
                    int n21 = nArray[n17++];
                    while (n19-- > 0) {
                        int n22 = n20 + n18;
                        while (n20 < n22) {
                            this.data.pixels[n20++] = n21;
                        }
                        n20 += n3 - n18;
                    }
                }
                n16 += n14;
            }
            if (!progressive) continue;
            for (n6 = 0; n6 < imageConsumerArray.length; ++n6) {
                imageConsumerArray[n6].setPixels(0, 0, n3, n4, this.data.header.model, this.data.pixels, 0, n3);
            }
        }
        if (!progressive) {
            for (n2 = 0; n2 < imageConsumerArray.length; ++n2) {
                imageConsumerArray[n2].setPixels(0, 0, n3, n4, this.data.header.model, this.data.pixels, 0, n3);
            }
        }
    }

    static {
        PngImage.registerChunk(new Chunk_IHDR());
        PngImage.registerChunk(new Chunk_PLTE());
        PngImage.registerChunk(new Chunk_IDAT());
        PngImage.registerChunk(new Chunk_IEND());
        PngImage.registerChunk(new Chunk_tRNS());
    }

    final class Data {
        Vector consumers = new Vector();
        Hashtable chunks = new Hashtable();
        int[] pixels;
        boolean produced;
        boolean produceFailed;
        boolean useFlush;
        boolean close;
        IDATInputStream in_idat;
        Chunk_IHDR header;
        Chunk_PLTE palette;
        int[] gammaTable = new int[256];
        Hashtable textChunks = new Hashtable();
        Hashtable properties = new Hashtable();
        Hashtable palettes = new Hashtable(1);
        Vector gifExtensions = new Vector();

        private Data() {
        }
    }
}

