/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.KeyValueChunk;
import com.sixlegs.image.png.TextChunk;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Hashtable;

abstract class AbstractTextChunk
extends KeyValueChunk
implements TextChunk {
    private static Hashtable special_keys = new Hashtable();

    public String toString() {
        return this.getText();
    }

    public String getKeyword() {
        return this.key;
    }

    public String getText() {
        return this.value;
    }

    public abstract String getTranslatedKeyword();

    public abstract String getLanguage();

    AbstractTextChunk(int n2) {
        super(n2);
    }

    protected String readKey() throws IOException {
        String string;
        Object v;
        String string2 = super.readKey();
        if (special_keys.containsKey(string2) && ((v = this.img.data.properties.get(string = string2.toLowerCase())) == null || ((Chunk)v).type != Chunk.iTXt)) {
            this.img.data.properties.put(string, this);
        }
        this.img.data.textChunks.put(string2, this);
        return string2;
    }

    protected String readValue() throws IOException {
        return AbstractTextChunk.repairValue(super.readValue());
    }

    private static String repairValue(String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length());
        try {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            int n3 = cArray.length;
            String string2 = System.getProperty("line.separator");
            while (n2 < n3) {
                char c2 = cArray[n2++];
                switch (c2) {
                    case '\r': {
                        if (n2 + 1 < n3 && cArray[n2 + 1] == '\n') break;
                    }
                    case '\n': {
                        charArrayWriter.write(string2);
                        break;
                    }
                    case '\t': {
                        charArrayWriter.write(9);
                        break;
                    }
                    default: {
                        if (c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f') {
                            charArrayWriter.write(92);
                            charArrayWriter.write(Integer.toOctalString(c2));
                            break;
                        }
                        charArrayWriter.write(c2);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return charArrayWriter.toString();
    }

    public String getChunkType() {
        return Chunk.typeToString(this.type);
    }

    static {
        special_keys.put("Title", Boolean.TRUE);
        special_keys.put("Author", Boolean.TRUE);
        special_keys.put("Description", Boolean.TRUE);
        special_keys.put("Copyright", Boolean.TRUE);
        special_keys.put("Creation Time", Boolean.TRUE);
        special_keys.put("Software", Boolean.TRUE);
        special_keys.put("Disclaimer", Boolean.TRUE);
        special_keys.put("Warning", Boolean.TRUE);
        special_keys.put("Source", Boolean.TRUE);
        special_keys.put("Comment", Boolean.TRUE);
    }
}

