/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.tools.arguments.DirFilter;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class PhotoAlbum
extends AbstractTool {
    static {
        PhotoAlbum.addVersion("$Id: PhotoAlbum.java,v 1.10 2006/09/15 21:00:25 xlv Exp $");
    }

    public PhotoAlbum() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcdir", "The directory containing the image files", false, new DirFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("PhotoAlbum", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== PhotoAlbum OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcdir") == null) {
                throw new InstantiationException("You need to choose a source directory");
            }
            File directory = (File)this.getValue("srcdir");
            if (directory.isFile()) {
                directory = directory.getParentFile();
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(pdf_file));
            writer.setViewerPreferences(64);
            PdfPageLabels pageLabels = new PdfPageLabels();
            TreeSet<File> images = new TreeSet<File>();
            File[] files = directory.listFiles();
            if (files == null) {
                throw new NullPointerException("listFiles() returns null");
            }
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].isFile()) {
                    images.add(files[i2]);
                }
                ++i2;
            }
            Iterator i3 = images.iterator();
            while (i3.hasNext()) {
                File image = (File)i3.next();
                System.out.println("Testing image: " + image.getName());
                try {
                    int dpiY;
                    Image img = Image.getInstance(image.getAbsolutePath());
                    int dpiX = img.getDpiX();
                    if (dpiX == 0) {
                        dpiX = 72;
                    }
                    if ((dpiY = img.getDpiY()) == 0) {
                        dpiY = 72;
                    }
                    float imgWidthPica = 72.0f * img.plainWidth() / (float)dpiX;
                    float imgHeightPica = 72.0f * img.plainHeight() / (float)dpiY;
                    img.scaleAbsolute(imgWidthPica, imgHeightPica);
                    document.setPageSize(new Rectangle(imgWidthPica, imgHeightPica));
                    if (document.isOpen()) {
                        document.newPage();
                    } else {
                        document.open();
                    }
                    img.setAbsolutePosition(0.0f, 0.0f);
                    document.add(img);
                    String label = image.getName();
                    if (label.lastIndexOf(46) > 0) {
                        label = label.substring(0, label.lastIndexOf(46));
                    }
                    pageLabels.addPageLabel(writer.getPageNumber(), 5, label);
                    System.out.println("Added image: " + image.getName());
                }
                catch (Exception e2) {
                    System.err.println(e2.getMessage());
                }
            }
            if (document.isOpen()) {
                writer.setPageLabels(pageLabels);
                document.close();
            } else {
                System.err.println("No images were found in directory " + directory.getAbsolutePath());
            }
        }
        catch (Exception e3) {
            JOptionPane.showMessageDialog(this.internalFrame, e3.getMessage(), e3.getClass().getName(), 0);
            System.err.println(e3.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        PhotoAlbum tool = new PhotoAlbum();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

