/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfColorList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_TABLE = "\\colortbl".getBytes();
    ArrayList colorList = new ArrayList();

    public RtfColorList(RtfDocument doc) {
        super(doc);
        this.colorList.add(new RtfColor(doc, 0, 0, 0, 0));
        this.colorList.add(new RtfColor(doc, 255, 255, 255, 1));
    }

    public int getColorNumber(RtfColor color) {
        int colorIndex = -1;
        int i2 = 0;
        while (i2 < this.colorList.size()) {
            if (this.colorList.get(i2).equals(color)) {
                colorIndex = i2;
            }
            ++i2;
        }
        if (colorIndex == -1) {
            colorIndex = this.colorList.size();
            this.colorList.add(color);
        }
        return colorIndex;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(OPEN_GROUP);
            result.write(COLOR_TABLE);
            int i2 = 0;
            while (i2 < this.colorList.size()) {
                RtfColor color = (RtfColor)this.colorList.get(i2);
                result.write(color.writeDefinition());
                ++i2;
            }
            result.write(CLOSE_GROUP);
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

