/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfListItem
extends RtfParagraph {
    private RtfList parentList = null;
    private boolean containsInnerList = false;

    public RtfListItem(RtfDocument doc, ListItem listItem) {
        super(doc, listItem);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int i2 = 0;
            while (i2 < this.chunks.size()) {
                RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i2);
                if (rtfElement instanceof RtfChunk) {
                    ((RtfChunk)rtfElement).setSoftLineBreaks(true);
                } else if (rtfElement instanceof RtfList) {
                    result.write(RtfParagraph.PARAGRAPH);
                    this.containsInnerList = true;
                }
                result.write(rtfElement.write());
                if (rtfElement instanceof RtfList) {
                    result.write(this.parentList.writeListBeginning());
                    result.write("\\tab".getBytes());
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i2);
            if (rtfElement instanceof RtfList) {
                return ((RtfList)rtfElement).writeDefinition();
            }
            ++i2;
        }
        return new byte[0];
    }

    public void inheritListSettings(int listNumber, int listLevel) {
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i2);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).setListNumber(listNumber);
                ((RtfList)rtfElement).setListLevel(listLevel);
                ((RtfList)rtfElement).setParent(this.parentList);
            }
            ++i2;
        }
    }

    protected void correctIndentation() {
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.chunks.get(i2);
            if (rtfElement instanceof RtfList) {
                ((RtfList)rtfElement).correctIndentation();
            }
            ++i2;
        }
    }

    public void setParent(RtfList parentList) {
        this.parentList = parentList;
    }

    public boolean isContainsInnerList() {
        return this.containsInnerList;
    }
}

