/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = "\\listlevel".getBytes();
    private static final byte[] LIST_LEVEL_TYPE = "\\levelnfc".getBytes();
    private static final byte[] LIST_LEVEL_TYPE_NEW = "\\levelnfcn".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT = "\\leveljc".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = "\\leveljcn".getBytes();
    private static final byte[] LIST_LEVEL_START_AT = "\\levelstartat".getBytes();
    private static final byte[] LIST_LEVEL_TEXT = "\\leveltext".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = "\\'02\\'".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = ".;".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_BULLETED = "\\'01\\u-3913 ?;".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = "\\levelnumbers".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = "\\'01".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_END = ";".getBytes();
    private static final byte[] LIST_LEVEL_FIRST_INDENT = "\\fi".getBytes();
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = "\\tx".getBytes();
    private static final byte[] LIST_LEVEL_NUMBER = "\\ilvl".getBytes();
    private static final byte[] TAB = "\\tab".getBytes();
    private static final byte[] LIST_TEXT = "\\listtext".getBytes();
    private static final byte[] LIST_NUMBER_END = ".".getBytes();
    private static final byte[] LIST_BULLET = "\\'b7".getBytes();
    private ArrayList items;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private int listNumber = this.document.getDocumentHeader().getListNumber(this);
    private boolean numbered = true;
    private RtfFont fontNumber;
    private RtfFont fontBullet;
    private int alignment = 0;
    private RtfList parentList = null;

    public RtfList(RtfDocument doc, List list) {
        super(doc);
        this.items = new ArrayList();
        if (list.symbolIndent() > 0.0f && list.indentationLeft() > 0.0f) {
            this.firstIndent = (int)((double)list.symbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0);
        } else if (list.symbolIndent() > 0.0f) {
            this.firstIndent = (int)((double)list.symbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)list.symbolIndent() * 20.0);
        } else if (list.indentationLeft() > 0.0f) {
            this.firstIndent = 0;
            this.leftIndent = (int)((double)list.indentationLeft() * 20.0);
        } else {
            this.firstIndent = 0;
            this.leftIndent = 0;
        }
        this.rightIndent = (int)((double)list.indentationRight() * 20.0);
        this.symbolIndent = (int)((double)(list.symbolIndent() + list.indentationLeft()) * 20.0);
        this.numbered = list.isNumbered();
        int i2 = 0;
        while (i2 < list.getItems().size()) {
            try {
                RtfBasicElement rtfElement;
                Element element = (Element)list.getItems().get(i2);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if (element instanceof ListItem) {
                    this.alignment = ((ListItem)element).alignment();
                }
                if ((rtfElement = doc.getMapper().mapElement(element)) instanceof RtfList) {
                    ((RtfList)rtfElement).setListNumber(this.listNumber);
                    ((RtfList)rtfElement).setListLevel(this.listLevel + 1);
                    ((RtfList)rtfElement).setParent(this);
                } else if (rtfElement instanceof RtfListItem) {
                    ((RtfListItem)rtfElement).setParent(this);
                    ((RtfListItem)rtfElement).inheritListSettings(this.listNumber, this.listLevel + 1);
                }
                this.items.add(rtfElement);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
            ++i2;
        }
        if (this.listLevel == 0) {
            this.correctIndentation();
        }
        this.fontNumber = new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0)));
        this.fontBullet = new RtfFont(this.document, new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    private byte[] writeIndentations() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(LIST_LEVEL_FIRST_INDENT);
            result.write(this.intToByteArray(this.firstIndent));
            result.write(RtfParagraphStyle.INDENT_LEFT);
            result.write(this.intToByteArray(this.leftIndent));
            result.write(RtfParagraphStyle.INDENT_RIGHT);
            result.write(this.intToByteArray(this.rightIndent));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(OPEN_GROUP);
            result.write(LIST_LEVEL);
            result.write(LIST_LEVEL_TYPE);
            if (this.numbered) {
                result.write(this.intToByteArray(0));
            } else {
                result.write(this.intToByteArray(23));
            }
            result.write(LIST_LEVEL_TYPE_NEW);
            if (this.numbered) {
                result.write(this.intToByteArray(0));
            } else {
                result.write(this.intToByteArray(23));
            }
            result.write(LIST_LEVEL_ALIGNMENT);
            result.write(this.intToByteArray(0));
            result.write(LIST_LEVEL_ALIGNMENT_NEW);
            result.write(this.intToByteArray(0));
            result.write(LIST_LEVEL_START_AT);
            result.write(this.intToByteArray(1));
            result.write(OPEN_GROUP);
            result.write(LIST_LEVEL_TEXT);
            if (this.numbered) {
                result.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
                if (this.listLevel < 10) {
                    result.write(this.intToByteArray(0));
                }
                result.write(this.intToByteArray(this.listLevel));
                result.write(LIST_LEVEL_STYLE_NUMBERED_END);
            } else {
                result.write(LIST_LEVEL_STYLE_BULLETED);
            }
            result.write(CLOSE_GROUP);
            result.write(OPEN_GROUP);
            result.write(LIST_LEVEL_NUMBERS_BEGIN);
            if (this.numbered) {
                result.write(LIST_LEVEL_NUMBERS_NUMBERED);
            }
            result.write(LIST_LEVEL_NUMBERS_END);
            result.write(CLOSE_GROUP);
            result.write(RtfFontList.FONT_NUMBER);
            if (this.numbered) {
                result.write(this.intToByteArray(this.fontNumber.getFontNumber()));
            } else {
                result.write(this.intToByteArray(this.fontBullet.getFontNumber()));
            }
            result.write(this.writeIndentations());
            result.write(LIST_LEVEL_SYMBOL_INDENT);
            result.write(this.intToByteArray(this.leftIndent));
            result.write(CLOSE_GROUP);
            result.write("\n".getBytes());
            int i2 = 0;
            while (i2 < this.items.size()) {
                byte[] data;
                RtfElement rtfElement = (RtfElement)this.items.get(i2);
                if (rtfElement instanceof RtfList) {
                    result.write(((RtfList)rtfElement).writeDefinition());
                    break;
                }
                if (rtfElement instanceof RtfListItem && (data = ((RtfListItem)rtfElement).writeDefinition()).length > 0) {
                    result.write(data);
                    break;
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected byte[] writeListBeginning() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(RtfParagraph.IN_TABLE);
            }
            switch (this.alignment) {
                case 0: {
                    result.write(RtfParagraphStyle.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(RtfParagraphStyle.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(RtfParagraphStyle.ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(RtfParagraphStyle.ALIGN_JUSTIFY);
                }
            }
            result.write(this.writeIndentations());
            result.write(RtfFont.FONT_SIZE);
            result.write(this.intToByteArray(this.fontNumber.getFontSize() * 2));
            if (this.symbolIndent > 0) {
                result.write("\\tx".getBytes());
                result.write(this.intToByteArray(this.leftIndent));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected byte[] writeListNumbers() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfListTable.LIST_NUMBER);
            result.write(this.intToByteArray(this.listNumber));
            if (this.listLevel > 0) {
                result.write(LIST_LEVEL_NUMBER);
                result.write(this.intToByteArray(this.listLevel));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.writeListBeginning());
            result.write(this.writeListNumbers());
            result.write(OPEN_GROUP);
            int itemNr = 0;
            int i2 = 0;
            while (i2 < this.items.size()) {
                RtfElement rtfElement = (RtfElement)this.items.get(i2);
                if (rtfElement instanceof RtfListItem) {
                    ++itemNr;
                    result.write(OPEN_GROUP);
                    result.write(LIST_TEXT);
                    result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                    if (this.inTable) {
                        result.write(RtfParagraph.IN_TABLE);
                    }
                    result.write(RtfFontList.FONT_NUMBER);
                    if (this.numbered) {
                        result.write(this.intToByteArray(this.fontNumber.getFontNumber()));
                    } else {
                        result.write(this.intToByteArray(this.fontBullet.getFontNumber()));
                    }
                    result.write(this.writeIndentations());
                    result.write(DELIMITER);
                    if (this.numbered) {
                        result.write(this.intToByteArray(itemNr));
                        result.write(LIST_NUMBER_END);
                    } else {
                        result.write(LIST_BULLET);
                    }
                    result.write(TAB);
                    result.write(CLOSE_GROUP);
                    result.write(rtfElement.write());
                    result.write(RtfParagraph.PARAGRAPH);
                    if (((RtfListItem)rtfElement).isContainsInnerList()) {
                        result.write(this.writeListNumbers());
                    }
                    result.write("\n".getBytes());
                } else if (rtfElement instanceof RtfList) {
                    result.write(rtfElement.write());
                    result.write(this.writeListBeginning());
                    result.write("\n".getBytes());
                }
                ++i2;
            }
            result.write(CLOSE_GROUP);
            if (!this.inTable) {
                result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int listLevel) {
        this.listLevel = listLevel;
        if (this.listLevel != 0) {
            this.document.getDocumentHeader().freeListNumber(this);
            int i2 = 0;
            while (i2 < this.items.size()) {
                if (this.items.get(i2) instanceof RtfList) {
                    ((RtfList)this.items.get(i2)).setListNumber(this.listNumber);
                    ((RtfList)this.items.get(i2)).setListLevel(this.listLevel + 1);
                }
                ++i2;
            }
        } else {
            this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        }
    }

    protected void setParent(RtfList parent) {
        this.parentList = parent;
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int listNumber) {
        this.listNumber = listNumber;
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i2 = 0;
        while (i2 < this.items.size()) {
            ((RtfBasicElement)this.items.get(i2)).setInTable(inTable);
            ++i2;
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i2 = 0;
        while (i2 < this.items.size()) {
            ((RtfBasicElement)this.items.get(i2)).setInHeader(inHeader);
            ++i2;
        }
    }

    protected void correctIndentation() {
        if (this.parentList != null) {
            this.leftIndent = this.leftIndent + this.parentList.getLeftIndent() + this.parentList.getFirstIndent();
        }
        int i2 = 0;
        while (i2 < this.items.size()) {
            if (this.items.get(i2) instanceof RtfList) {
                ((RtfList)this.items.get(i2)).correctIndentation();
            } else if (this.items.get(i2) instanceof RtfListItem) {
                ((RtfListItem)this.items.get(i2)).correctIndentation();
            }
            ++i2;
        }
    }

    private int getLeftIndent() {
        return this.leftIndent;
    }

    private int getFirstIndent() {
        return this.firstIndent;
    }
}

