/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;

public class Type3Glyph
extends PdfContentByte {
    private PageResources pageResources;
    private boolean colorized;

    private Type3Glyph() {
        super(null);
    }

    Type3Glyph(PdfWriter writer, PageResources pageResources, float wx, float llx, float lly, float urx, float ury, boolean colorized) {
        super(writer);
        this.pageResources = pageResources;
        this.colorized = colorized;
        if (colorized) {
            this.content.append(wx).append(" 0 d0\n");
        } else {
            this.content.append(wx).append(" 0 ").append(llx).append(' ').append(lly).append(' ').append(urx).append(' ').append(ury).append(" d1\n");
        }
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    public void addImage(Image image, float a2, float b2, float c2, float d2, float e2, float f2, boolean inlineImage) throws DocumentException {
        if (!this.colorized && (!image.isMask() || image.bpc() != 1 && image.bpc() <= 255)) {
            throw new DocumentException("Not colorized Typed3 fonts only accept mask images.");
        }
        super.addImage(image, a2, b2, c2, d2, e2, f2, inlineImage);
    }

    public PdfContentByte getDuplicate() {
        Type3Glyph dup = new Type3Glyph();
        dup.writer = this.writer;
        dup.pdf = this.pdf;
        dup.pageResources = this.pageResources;
        dup.colorized = this.colorized;
        return dup;
    }
}

