/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class Type3Font
extends BaseFont {
    private IntHashtable char2byte = new IntHashtable();
    private IntHashtable widths3 = new IntHashtable();
    private HashMap char2glyph = new HashMap<K, V>();
    private PdfWriter writer;
    private float llx = NaNf;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    /*
     * Unable to fully structure code
     */
    public Type3Font(PdfWriter writer, char[] chars, boolean colorized) {
        super();
        this.writer = writer;
        this.colorized = colorized;
        this.fontType = 5;
        if (chars.length == 0 || chars.length > 256) {
            throw new IllegalArgumentException("char array size must be > 0 and <= 256");
        }
        count = 255;
        hits = new boolean[chars.length];
        k = 0;
        while (k < chars.length) {
            c = chars[k];
            if (c >= ' ' && c < '\u0100') {
                if (this.char2byte.containsKey(c)) {
                    throw new IllegalArgumentException("duplicated char - " + c + ", index " + k);
                }
                this.char2byte.put(c, c);
                hits[k] = true;
            }
            ++k;
        }
        k = 0;
        while (k < hits.length) {
            block7: {
                if (!hits[k]) ** GOTO lbl30
                break block7;
lbl-1000:
                // 1 sources

                {
                    --count;
lbl30:
                    // 2 sources

                    ** while (this.char2byte.containsKey((int)count))
                }
lbl31:
                // 1 sources

                c = chars[k];
                if (this.char2byte.containsKey(c)) {
                    throw new IllegalArgumentException("duplicated char - " + c + ", index " + k);
                }
                this.char2byte.put(c, count--);
            }
            ++k;
        }
    }

    public PdfContentByte defineGlyph(char c2, float wx, float llx, float lly, float urx, float ury) {
        if (!this.char2byte.containsKey(c2)) {
            throw new IllegalArgumentException("The char " + c2 + " doesn't belong in this Type3 font");
        }
        Integer ck = new Integer(c2);
        Type3Glyph glyph = (Type3Glyph)this.char2glyph.get(ck);
        if (glyph != null) {
            return glyph;
        }
        this.widths3.put(c2, (int)wx);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = llx;
                this.lly = lly;
                this.urx = urx;
                this.ury = ury;
            } else {
                this.llx = Math.min(this.llx, llx);
                this.lly = Math.min(this.lly, lly);
                this.urx = Math.max(this.urx, urx);
                this.ury = Math.max(this.ury, ury);
            }
        }
        glyph = new Type3Glyph(this.writer, this.pageResources, wx, llx, lly, urx, ury, this.colorized);
        this.char2glyph.put(ck, glyph);
        return glyph;
    }

    public String[][] getFamilyFontName() {
        return new String[0][];
    }

    public float getFontDescriptor(int key, float fontSize) {
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[0][];
    }

    public int getKerning(char char1, char char2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return "";
    }

    protected int[] getRawCharBBox(int c2, String name) {
        return null;
    }

    int getRawWidth(int c2, String name) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    public boolean setKerning(char char1, char char2, int kern) {
        return false;
    }

    public void setPostscriptFontName(String name) {
    }

    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        if (this.writer != writer) {
            throw new IllegalArgumentException("Type3 font used with the wrong PdfWriter");
        }
        if (this.char2byte.size() != this.widths3.size()) {
            throw new DocumentException("Not all the glyphs in the Type3 font are defined");
        }
        IntHashtable inv = new IntHashtable();
        Iterator it = this.char2byte.getEntryIterator();
        while (it.hasNext()) {
            IntHashtable.IntHashtableEntry entry = (IntHashtable.IntHashtableEntry)it.next();
            inv.put(entry.getValue(), entry.getKey());
        }
        int[] invOrd = inv.toOrderedKeys();
        int firstChar = invOrd[0];
        int lastChar = invOrd[invOrd.length - 1];
        int[] widths = new int[lastChar - firstChar + 1];
        int k2 = 0;
        while (k2 < widths.length) {
            if (inv.containsKey(k2 + firstChar)) {
                widths[k2] = this.widths3.get(inv.get(k2 + firstChar));
            }
            ++k2;
        }
        PdfArray diffs = new PdfArray();
        PdfDictionary charprocs = new PdfDictionary();
        int last = -1;
        int k3 = 0;
        while (k3 < invOrd.length) {
            int c2 = invOrd[k3];
            if (c2 > last) {
                last = c2;
                diffs.add(new PdfNumber(last));
            }
            ++last;
            int c22 = inv.get(c2);
            String s2 = GlyphList.unicodeToName(c22);
            if (s2 == null) {
                s2 = "a" + c22;
            }
            PdfName n2 = new PdfName(s2);
            diffs.add(n2);
            Type3Glyph glyph = (Type3Glyph)this.char2glyph.get(new Integer(c22));
            PdfStream stream = new PdfStream(glyph.toPdf(null));
            stream.flateCompress();
            PdfIndirectReference refp = writer.addToBody(stream).getIndirectReference();
            charprocs.put(n2, refp);
            ++k3;
        }
        PdfDictionary font = new PdfDictionary(PdfName.FONT);
        font.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            font.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            font.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        font.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        font.put(PdfName.CHARPROCS, writer.addToBody(charprocs).getIndirectReference());
        PdfDictionary encoding = new PdfDictionary();
        encoding.put(PdfName.DIFFERENCES, diffs);
        font.put(PdfName.ENCODING, writer.addToBody(encoding).getIndirectReference());
        font.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
        font.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
        font.put(PdfName.WIDTHS, writer.addToBody(new PdfArray(widths)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            font.put(PdfName.RESOURCES, writer.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        writer.addToBody((PdfObject)font, ref);
    }

    byte[] convertToBytes(String text) {
        char[] cc = text.toCharArray();
        byte[] b2 = new byte[cc.length];
        int p2 = 0;
        int k2 = 0;
        while (k2 < cc.length) {
            char c2 = cc[k2];
            if (this.char2byte.containsKey(c2)) {
                b2[p2++] = (byte)this.char2byte.get(c2);
            }
            ++k2;
        }
        if (b2.length == p2) {
            return b2;
        }
        byte[] b22 = new byte[p2];
        System.arraycopy(b2, 0, b22, 0, p2);
        return b22;
    }

    public int getWidth(char char1) {
        if (!this.widths3.containsKey(char1)) {
            throw new IllegalArgumentException("The char " + char1 + " is not defined in a Type3 font");
        }
        return this.widths3.get(char1);
    }

    public int getWidth(String text) {
        char[] c2 = text.toCharArray();
        int total = 0;
        int k2 = 0;
        while (k2 < c2.length) {
            total += this.getWidth(c2[k2]);
            ++k2;
        }
        return total;
    }

    public int[] getCharBBox(char c2) {
        return null;
    }

    public boolean charExists(char c2) {
        return this.char2byte.containsKey(c2);
    }

    public boolean setCharAdvance(char c2, int advance) {
        return false;
    }
}

