/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;

public class PdfPages {
    private ArrayList pages = new ArrayList();
    private ArrayList parents = new ArrayList();
    private int leafSize = 10;
    private PdfWriter writer;
    private PdfIndirectReference topParent;

    PdfPages(PdfWriter writer) {
        this.writer = writer;
    }

    void addPage(PdfDictionary page) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            PdfIndirectReference parent = (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
            page.put(PdfName.PARENT, parent);
            PdfIndirectReference current = this.writer.getCurrentPage();
            this.writer.addToBody((PdfObject)page, current);
            this.pages.add(current);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    PdfIndirectReference addPageRef(PdfIndirectReference pageRef) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            this.pages.add(pageRef);
            return (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    PdfIndirectReference writePageTree() throws IOException {
        if (this.pages.isEmpty()) {
            throw new IOException("The document has no pages.");
        }
        int leaf = 1;
        ArrayList<PdfIndirectReference> tParents = this.parents;
        ArrayList tPages = this.pages;
        ArrayList<PdfIndirectReference> nextParents = new ArrayList<PdfIndirectReference>();
        while (true) {
            leaf *= this.leafSize;
            int stdCount = this.leafSize;
            int rightCount = tPages.size() % this.leafSize;
            if (rightCount == 0) {
                rightCount = this.leafSize;
            }
            int p2 = 0;
            while (p2 < tParents.size()) {
                int count;
                int thisLeaf = leaf;
                if (p2 == tParents.size() - 1) {
                    count = rightCount;
                    thisLeaf = this.pages.size() % leaf;
                    if (thisLeaf == 0) {
                        thisLeaf = leaf;
                    }
                } else {
                    count = stdCount;
                }
                PdfDictionary top = new PdfDictionary(PdfName.PAGES);
                top.put(PdfName.COUNT, new PdfNumber(thisLeaf));
                PdfArray kids = new PdfArray();
                ArrayList internal = kids.getArrayList();
                internal.addAll(tPages.subList(p2 * stdCount, p2 * stdCount + count));
                top.put(PdfName.KIDS, kids);
                if (tParents.size() > 1) {
                    if (p2 % this.leafSize == 0) {
                        nextParents.add(this.writer.getPdfIndirectReference());
                    }
                    top.put(PdfName.PARENT, (PdfIndirectReference)nextParents.get(p2 / this.leafSize));
                }
                this.writer.addToBody((PdfObject)top, (PdfIndirectReference)tParents.get(p2));
                ++p2;
            }
            if (tParents.size() == 1) {
                this.topParent = (PdfIndirectReference)tParents.get(0);
                return this.topParent;
            }
            tPages = tParents;
            tParents = nextParents;
            nextParents = new ArrayList();
        }
    }

    PdfIndirectReference getTopParent() {
        return this.topParent;
    }

    void setLinearMode(PdfIndirectReference topParent) {
        if (this.parents.size() > 1) {
            throw new RuntimeException("Linear page mode can only be called with a single parent.");
        }
        if (topParent != null) {
            this.topParent = topParent;
            this.parents.clear();
            this.parents.add(topParent);
        }
        this.leafSize = 10000000;
    }

    void addPage(PdfIndirectReference page) {
        this.pages.add(page);
    }

    int reorderPages(int[] order) throws DocumentException {
        if (order == null) {
            return this.pages.size();
        }
        if (this.parents.size() > 1) {
            throw new DocumentException("Page reordering requires a single parent in the page tree. Call PdfWriter.setLinearMode() after open.");
        }
        if (order.length != this.pages.size()) {
            throw new DocumentException("Page reordering requires an array with the same size as the number of pages.");
        }
        int max = this.pages.size();
        boolean[] temp = new boolean[max];
        int k2 = 0;
        while (k2 < max) {
            int p2 = order[k2];
            if (p2 < 1 || p2 > max) {
                throw new DocumentException("Page reordering requires pages between 1 and " + max + ". Found " + p2 + ".");
            }
            if (temp[p2 - 1]) {
                throw new DocumentException("Page reordering requires no page repetition. Page " + p2 + " is repeated.");
            }
            temp[p2 - 1] = true;
            ++k2;
        }
        Object[] copy = this.pages.toArray();
        int k3 = 0;
        while (k3 < max) {
            this.pages.set(k3, copy[order[k3] - 1]);
            ++k3;
        }
        return max;
    }
}

