/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodePostnet
extends Barcode {
    private static final byte[][] BARS;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        byArray[1] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[2] = 1;
        byArray3[4] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[2] = 1;
        byArray4[3] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[1] = 1;
        byArray5[4] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[1] = 1;
        byArray6[3] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[0] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[0] = 1;
        byArray10[2] = 1;
        byArrayArray[9] = byArray10;
        BARS = byArrayArray;
    }

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String text) {
        int total = 0;
        int k2 = text.length() - 1;
        while (k2 >= 0) {
            int n2 = text.charAt(k2) - 48;
            total += n2;
            --k2;
        }
        text = String.valueOf(text) + (char)((10 - total % 10) % 10 + 48);
        byte[] bars = new byte[text.length() * 5 + 2];
        bars[0] = 1;
        bars[bars.length - 1] = 1;
        int k3 = 0;
        while (k3 < text.length()) {
            int c2 = text.charAt(k3) - 48;
            System.arraycopy(BARS[c2], 0, bars, k3 * 5 + 1, 5);
            ++k3;
        }
        return bars;
    }

    public Rectangle getBarcodeSize() {
        float width = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(width, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        byte flip = 1;
        if (this.codeType == 8) {
            flip = 0;
            bars[0] = 0;
            bars[bars.length - 1] = 0;
        }
        float startX = 0.0f;
        int k2 = 0;
        while (k2 < bars.length) {
            cb.rectangle(startX, 0.0f, this.x - this.inkSpreading, bars[k2] == flip ? this.barHeight : this.size);
            startX += this.n;
            ++k2;
        }
        cb.fill();
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        int j2;
        int barTall;
        int barShort;
        int barDistance;
        int f2 = foreground.getRGB();
        int g2 = background.getRGB();
        Canvas canvas = new Canvas();
        int barWidth = (int)this.x;
        if (barWidth <= 0) {
            barWidth = 1;
        }
        if ((barDistance = (int)this.n) <= barWidth) {
            barDistance = barWidth + 1;
        }
        if ((barShort = (int)this.size) <= 0) {
            barShort = 1;
        }
        if ((barTall = (int)this.barHeight) <= barShort) {
            barTall = barShort + 1;
        }
        int width = ((this.code.length() + 1) * 5 + 1) * barDistance + barWidth;
        int[] pix = new int[width * barTall];
        byte[] bars = BarcodePostnet.getBarsPostnet(this.code);
        byte flip = 1;
        if (this.codeType == 8) {
            flip = 0;
            bars[0] = 0;
            bars[bars.length - 1] = 0;
        }
        int idx = 0;
        int k2 = 0;
        while (k2 < bars.length) {
            boolean dot = bars[k2] == flip;
            j2 = 0;
            while (j2 < barDistance) {
                pix[idx + j2] = dot && j2 < barWidth ? f2 : g2;
                ++j2;
            }
            idx += barDistance;
            ++k2;
        }
        int limit = width * (barTall - barShort);
        int k3 = width;
        while (k3 < limit) {
            System.arraycopy(pix, 0, pix, k3, width);
            k3 += width;
        }
        idx = limit;
        k3 = 0;
        while (k3 < bars.length) {
            j2 = 0;
            while (j2 < barDistance) {
                pix[idx + j2] = j2 < barWidth ? f2 : g2;
                ++j2;
            }
            idx += barDistance;
            ++k3;
        }
        k3 = limit + width;
        while (k3 < pix.length) {
            System.arraycopy(pix, limit, pix, k3, width);
            k3 += width;
        }
        Image img = canvas.createImage(new MemoryImageSource(width, barTall, pix, 0, width));
        return img;
    }
}

