/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class DespeckleFilter
extends WholeImageFilter {
    protected short pepperAndSalt(short c2, short v1, short v2) {
        if (c2 < v1) {
            c2 = (short)(c2 + 1);
        }
        if (c2 < v2) {
            c2 = (short)(c2 + 1);
        }
        if (c2 > v1) {
            c2 = (short)(c2 - 1);
        }
        if (c2 > v2) {
            c2 = (short)(c2 - 1);
        }
        return c2;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        short[][] r2 = new short[3][width];
        short[][] g2 = new short[3][width];
        short[][] b2 = new short[3][width];
        int[] outPixels = new int[width * height];
        for (int x = 0; x < width; ++x) {
            int rgb = inPixels[x];
            r2[1][x] = (short)(rgb >> 16 & 0xFF);
            g2[1][x] = (short)(rgb >> 8 & 0xFF);
            b2[1][x] = (short)(rgb & 0xFF);
        }
        for (int y = 0; y < height; ++y) {
            int x;
            boolean yIn = y > 0 && y < height - 1;
            int nextRowIndex = index + width;
            if (y < height - 1) {
                for (x = 0; x < width; ++x) {
                    int rgb = inPixels[nextRowIndex++];
                    r2[2][x] = (short)(rgb >> 16 & 0xFF);
                    g2[2][x] = (short)(rgb >> 8 & 0xFF);
                    b2[2][x] = (short)(rgb & 0xFF);
                }
            }
            for (x = 0; x < width; ++x) {
                boolean xIn = x > 0 && x < width - 1;
                short or = r2[1][x];
                short og = g2[1][x];
                short ob = b2[1][x];
                int w = x - 1;
                int e2 = x + 1;
                if (yIn) {
                    or = this.pepperAndSalt(or, r2[0][x], r2[2][x]);
                    og = this.pepperAndSalt(og, g2[0][x], g2[2][x]);
                    ob = this.pepperAndSalt(ob, b2[0][x], b2[2][x]);
                }
                if (xIn) {
                    or = this.pepperAndSalt(or, r2[1][w], r2[1][e2]);
                    og = this.pepperAndSalt(og, g2[1][w], g2[1][e2]);
                    ob = this.pepperAndSalt(ob, b2[1][w], b2[1][e2]);
                }
                if (yIn && xIn) {
                    or = this.pepperAndSalt(or, r2[0][w], r2[2][e2]);
                    og = this.pepperAndSalt(og, g2[0][w], g2[2][e2]);
                    ob = this.pepperAndSalt(ob, b2[0][w], b2[2][e2]);
                    or = this.pepperAndSalt(or, r2[2][w], r2[0][e2]);
                    og = this.pepperAndSalt(og, g2[2][w], g2[0][e2]);
                    ob = this.pepperAndSalt(ob, b2[2][w], b2[0][e2]);
                }
                outPixels[index] = inPixels[index] & 0xFF000000 | or << 16 | og << 8 | ob;
                ++index;
            }
            short[] t = r2[0];
            r2[0] = r2[1];
            r2[1] = r2[2];
            r2[2] = t;
            t = g2[0];
            g2[0] = g2[1];
            g2[1] = g2[2];
            g2[2] = t;
            t = b2[0];
            b2[0] = b2[1];
            b2[1] = b2[2];
            b2[2] = t;
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Despeckle...";
    }
}

