#!/bin/sh

export DISPLAY=:0
export scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# Find out in what file system this script resides
MOUNTPOINT=`df . | grep dev | tr -s " " | cut -f6 -d" "`

# If /usr/local exists and is not a symlink exit with an error code.
if [ -e /usr/local -a ! -L /usr/local ]; then
	test -x /usr/bin/error_usr-local_directory_exists.sh && /usr/bin/error_usr-local_directory_exists.sh
	exit 1
fi

# If /usr/local exists and is a symlink this script has probably already been
# run. If /usr/local/programs exists continue, if not remove the
# broken symlink since it points to a removed media card.
if [ -L /usr/local -a ! -d /usr/local/programs ]; then
	if [ -x /usr/bin/warning_usr-local_symlink_exists.sh ]; then
		/usr/bin/warning_usr-local_symlink_exists.sh
		test $? -eq 1 && exit 2
	fi

	rm /usr/local
	# Create directory structure in the current file system and make a
	# symlink from /usr/local to point to it.
	mkdir -p ${MOUNTPOINT}/_local/programs
	mkdir -p ${MOUNTPOINT}/_local/home
	ln -s ${MOUNTPOINT}/_local /usr/local
fi

# Write common environment variables to /usr/local/home/environment.
printf "%s\n" "HOME=/usr/local/home" > /usr/local/home/environment
printf "%s\n" "export HOME" >> /usr/local/home/environment
printf "%s\n" "LD_LIBRARY_PATH=/usr/local/lib:$LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "export LD_LIBRARY_PATH" >> /usr/local/home/environment
printf "%s\n" "PATH=/usr/local/bin:$PATH" >> /usr/local/home/environment
printf "%s\n" "export PATH" >> /usr/local/home/environment
 
# Extract embedded ipkg package and install it
tail -n +48 "$0" > ${scriptdir}/package.ipk

ipkg install ${scriptdir}/package.ipk
rm ${scriptdir}/package.ipk
exit $?

