; Copyright (c) 2007 Ashish Kulkarni (mods by Nick Rapallo - March 2008)
;
; Permission is hereby granted, free of charge, to any person obtaining a
; copy of this software and associated documentation files (the "Software"),
; to deal in the Software without restriction, including without limitation
; the rights to use, copy, modify, merge, publish, distribute, sublicense,
; and/or sell copies of the Software, and to permit persons to whom the
; Software is furnished to do so, subject to the following conditions:

; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.

; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

!include "MUI.nsh"

;--------------------------------
;General

!define VERSION 9.4
!define GUI "Mobi2IMP GUI ${VERSION}"
Name    "${GUI}"
OutFile "..\Mobi2IMP-gui.exe"
InstallButtonText "Convert"
AutoCloseWindow true
BrandingText "${GUI}"
Caption "${GUI}"

;--------------------------------
;Pages

Page custom GetConversionParameters

!insertmacro MUI_PAGE_INSTFILES
  
!insertmacro MUI_LANGUAGE "English"

ReserveFile "Mobi2IMP-gui.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

;--------------------------------
;Variables
Var F4
Var F9
Var F10
Var F11
Var F12
Var F13
Var F14
Var F16
Var F17
Var F18
Var F19
Var F20
Var F21
Var F22
Var F23
Var F24
Var F25
Var F26
Var F27
Var F28
Var F30
Var F31
Var F32
Var F33
Var F42
Var F43

;--------------------------------
;Installer Sections

Section "Main Section"
SectionEnd

!macro LoadParam num
  ReadIniStr $F${num} "\Program Files\Mobi2IMP\Mobi2IMP.ini"  "Field ${num}"  "State"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "Mobi2IMP-gui.ini" "Field ${num}"  "State" $F${num}
!macroend

!macro OptionalParam num param
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field ${num}" "State"
  Strcmp $R9 "" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro DefaultParam num param def
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field ${num}" "State"
  Strcmp $R9 "" +3
  Strcmp $R9 "${def}" +2
  StrCpy $R2 '$R2 ${param} "$R9"'
!macroend

!macro Flag num name
  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field ${num}" "State"
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field ${num}" "State" $R9
  IntCmpU $R9 0 +2
  StrCpy $R2 '$R2 ${name}'
!macroend

!macro Tip num tooltip
  FindWindow $3 "#32770" "" $HWNDPARENT
  IntOp $5 1199 + ${num}
  GetDlgItem $1 $3 $5
  ToolTips::Modern $1 0 "" "${tooltip}"
!macroend

Function .onInit
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "Mobi2IMP-gui.ini"

  ReadIniStr $F4 "\Program Files\Mobi2IMP\Mobi2IMP.ini"  "Field 4"  "State"
  StrCmp $F4 "" nooptfile
  
  !insertmacro LoadParam 4
  !insertmacro LoadParam 9
  !insertmacro LoadParam 10
  !insertmacro LoadParam 11
  !insertmacro LoadParam 12
  !insertmacro LoadParam 13
  !insertmacro LoadParam 14
  !insertmacro LoadParam 16
  !insertmacro LoadParam 17
  !insertmacro LoadParam 18
  !insertmacro LoadParam 19
  !insertmacro LoadParam 20
  !insertmacro LoadParam 21
  !insertmacro LoadParam 22
  !insertmacro LoadParam 23
  !insertmacro LoadParam 24
  !insertmacro LoadParam 25
  !insertmacro LoadParam 26
  !insertmacro LoadParam 27
  !insertmacro LoadParam 28
  !insertmacro LoadParam 30
  !insertmacro LoadParam 31
  !insertmacro LoadParam 32
  !insertmacro LoadParam 33
  !insertmacro LoadParam 42
  !insertmacro LoadParam 43

 nooptfile:
  Call GetParameters
  Pop  $R0
  StrCmp $R0 "" skip
  IfFileExists $R0 0 skip
  !insertmacro MUI_INSTALLOPTIONS_WRITE "Mobi2IMP-gui.ini" "Field 3" "State" $R0
skip:
FunctionEnd

Function GetConversionParameters
start:
  !insertmacro MUI_HEADER_TEXT "${GUI}" "Please enter the conversion details."
  !insertmacro MUI_INSTALLOPTIONS_INITDIALOG "Mobi2IMP-gui.ini"
  ; tooltips
  !insertmacro Tip 3  "This is the source file that you want to convert."
  !insertmacro Tip 4  "Browse to input file location."
  !insertmacro Tip 5  "Mobipocket (.prc/.mobi) or PalmDOC (.pdb) input format."
  !insertmacro Tip 6  "The output filename overrides default naming (ignores file extension)."
  !insertmacro Tip 7  "Browse to output file location."
  !insertmacro Tip 8  "Directory where to explode Mobipocket file (it's left behind!)"
  !insertmacro Tip 9  "Title of the generated eBook usually extracted from the source file."
  !insertmacro Tip 10 "Author of the generated eBook usually extracted from the source file."
  !insertmacro Tip 11 "Category of the generated eBook may be extracted from the source file."
  !insertmacro Tip 12 "Create the REB1200 .imp version along with the EBW1150 .imp."
  !insertmacro Tip 13 "Create the REB1100 .rp version along with the EBW1150 .imp."
  !insertmacro Tip 14 "Create the ETI .epub (or OEBFF .oeb) version along with the EBW1150 .imp."
  !insertmacro Tip 15 "Do not create the EBW1150 .IMP version; needs other output selected."
  !insertmacro Tip 16 "Printout messages about this conversion."
  !insertmacro Tip 18 "Use left-right margins of 2px,5%,8% instead of default 2%."
  !insertmacro Tip 19 "Set left-right margins to 0% instead of default 2%."
  !insertmacro Tip 20 "Do not pad/resize images to device's aspect ratio nor adjust image link/caption locations."
  !insertmacro Tip 21 "Printout more detailed messages about conversion."
  !insertmacro Tip 22 "Use 'x-small' font size for body text not default 'small'."
  !insertmacro Tip 23 "Use 'medium' font size for body text not default 'small'."
  !insertmacro Tip 24 "Do not 'justify' body text (i.e. left-aligned; no full justification)."
  !insertmacro Tip 25 "Do not use 'blank line' (1em) paragraph separation (i.e no paragraph separation)."
  !insertmacro Tip 26 "Set small (1em) indent (i.e no (0em) indent). Useful when select 'nopara' option."
  !insertmacro Tip 27 "Make BookDesigner (BD) notice at the end 'big print' again not small."
  !insertmacro Tip 28 "Put BookDesigner (BD) notice at the end on a new/separate page."
  !insertmacro Tip 29 "Remove BookDesigner (BD) notice at the end."
  !insertmacro Tip 30 "When using 'no para sep.', don't fix (broken) <br />'s issue."
  !insertmacro Tip 32 "Use color #FF80FF as background color for every page of the eBook."
  !insertmacro Tip 33 "Use header text 'Title   Author' followed by <hr>."
  !insertmacro Tip 34 "Use color #FF80FF as header background color only for every page."
  !insertmacro Tip 35 "Color '#B0C4DE' is LightSteelBlue; '#F5DEB3' is Wheat; '#FFFFFF' is White."
  !insertmacro Tip 43 "Created by Nick Rapallo (nrapallo) at mobileread.com."
  !insertmacro Tip 44 "Add cover image page using the existing cover embedded in source file."
  !insertmacro Tip 45 "Do not convert Mobipocket-specific width= & height= tags"
  
  !insertmacro MUI_INSTALLOPTIONS_SHOW
  StrCmp $MUI_TEMP1 "cancel" finish

  StrCpy $R2 ' '

  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field 4" "State"
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 4" "State" $R9

  !insertmacro Flag 10 '--1200'
  !insertmacro Flag 11 '--1100'
  !insertmacro Flag 12 '--oeb'
  !insertmacro Flag 13 '--1150'
  !insertmacro Flag 14 '--verbose'
  
  !insertmacro DefaultParam 16 '--LRmargins' '2%'
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 16" "State" $R9

  !insertmacro Flag 17 '--nomargins'
  !insertmacro Flag 18 '--noimagefix'
  !insertmacro Flag 19 '--debug'
  !insertmacro Flag 20 '--smallerfont'
  !insertmacro Flag 21 '--largerfont'
  !insertmacro Flag 22 '--nojustify'
  !insertmacro Flag 23 '--nopara'
  !insertmacro Flag 24 '--indent'
  !insertmacro Flag 25 '--BDbig'
  !insertmacro Flag 26 '--BDnewpage'
  !insertmacro Flag 27 '--BDremove'
  !insertmacro Flag 28 '--noBRfix'
  !insertmacro Flag 31 '--header_hr'
  !insertmacro Flag 42 '--cover'
  !insertmacro Flag 43 '--nomarginfix'

  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field 30" "State"
  Strcmp $R9 "" +3
  Strcmp $R9 "FFFFFF" +2
  StrCpy $R2 '$R2 --bgcolor #$R9'
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 30" "State" $R9

  !insertmacro MUI_INSTALLOPTIONS_READ $R9 "Mobi2IMP-gui.ini" "Field 32" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $R8 "Mobi2IMP-gui.ini" "Field 33" "State"
  IntCmpU $R9 0 +2
  StrCpy $R2 '$R2 --header_color #$R8'
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 32" "State" $R9
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 33" "State" $R8

  !insertmacro DefaultParam 5 '--out' 'Default naming (Author - Title.ext)'

  !insertmacro MUI_INSTALLOPTIONS_READ $R3 "Mobi2IMP-gui.ini" "Field 3" "State"
  Strcpy $R2 '$R2 "$R3"'

  !insertmacro DefaultParam 6 '--explodedir' 'Default'
  !insertmacro DefaultParam 9 '' 'Extracted'
  WriteIniStr "\Program Files\Mobi2IMP\Mobi2IMP.ini" "Field 9" "State" $R9
  !insertmacro DefaultParam 8 '' 'Extracted'
  !insertmacro DefaultParam 7 '' 'Extracted'

  Exec '"$EXEDIR\Mobi2IMP-run.cmd" $R2'
  Goto start
finish:
FunctionEnd

Function GetParameters
 
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  
  StrCpy $R2 1
  StrLen $R3 $CMDLINE
  
  ;Check for quote or space
  StrCpy $R0 $CMDLINE $R2
  StrCmp $R0 '"' 0 +3
    StrCpy $R1 '"'
    Goto loop
  StrCpy $R1 " "
  
  loop:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 get
    StrCmp $R2 $R3 get
    Goto loop
  
  get:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 " " get
    StrCpy $R0 $CMDLINE "" $R2
  
  Pop $R3
  Pop $R2
  Pop $R1
  Exch $R0
 
FunctionEnd