/*
 * Copyright (C) 2009  Trustin Heuiseung Lee
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package net.gleamynode.img2pdf;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import javax.imageio.ImageIO;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;

public class Main {

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Specify one or more image files.");
            return;
        }
        
        ImageProducer producer = new ImageProducer();

        Rectangle pageSize = new Rectangle(754/2.3f, 584/2.3f).rotate();
        Document doc = new Document(pageSize, 0, 0, 0, 0);
        PdfWriter.getInstance(doc, new FileOutputStream("out.pdf"));
        doc.open();

        String lastPath = null;
        for (int i = 0; i < args.length; i ++) {
            String path = args[i];
            System.err.format("(%3d%%) ", i * 100 / args.length);

            System.err.print(path);
            System.err.print(' ');
            System.err.flush();

            BufferedImage img = ImageIO.read(new File(path));
            if (img == null) {
                System.err.println(" unsupported type.");
                return;
            }
            System.err.print('.');
            System.err.flush();

            producer.offer(img);
            System.err.print('.');
            System.err.flush();

            for (;;) {
                BufferedImage output = producer.poll();
                if (output == null) {
                    break;
                }

                Image iTextImg = Image.getInstance(output, Color.WHITE);
                iTextImg.setAbsolutePosition(0, 0);
                iTextImg.scaleAbsolute(pageSize.getWidth(), pageSize.getHeight());
                iTextImg.setCompressionLevel(9);

                doc.newPage();
                doc.add(iTextImg);

                System.err.print('.');
                System.err.flush();
            }

            System.err.println(" done");

            lastPath = path;
        }

        if (lastPath != null) {
            producer.finish();

            BufferedImage output = producer.poll();
            if (output != null) {
                Image iTextImg = Image.getInstance(output, Color.WHITE);
                iTextImg.setAbsolutePosition(0, 0);
                iTextImg.scaleAbsolute(pageSize.getWidth(), pageSize.getHeight());
                iTextImg.setCompressionLevel(9);

                doc.setPageSize(pageSize);
                doc.newPage();
                doc.add(iTextImg);
            }
        }

        System.err.println("(100%) All done.");

        doc.close();
    }
}
