/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.img2pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import net.gleamynode.img2pdf.ImageProducer;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length == 0) {
            System.err.println("Specify one or more image files.");
            return;
        }
        ImageProducer imageProducer = new ImageProducer();
        Rectangle rectangle = new Rectangle(327.82608f, 253.91306f).rotate();
        Document document = new Document(rectangle, 0.0f, 0.0f, 0.0f, 0.0f);
        PdfWriter.getInstance(document, new FileOutputStream("out.pdf"));
        document.open();
        Object object2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            BufferedImage bufferedImage;
            object = stringArray[i];
            System.err.format("(%3d%%) ", i * 100 / stringArray.length);
            System.err.print((String)object);
            System.err.print(' ');
            System.err.flush();
            BufferedImage bufferedImage2 = ImageIO.read(new File((String)object));
            if (bufferedImage2 == null) {
                System.err.println(" unsupported type.");
                return;
            }
            System.err.print('.');
            System.err.flush();
            imageProducer.offer(bufferedImage2);
            System.err.print('.');
            System.err.flush();
            while ((bufferedImage = imageProducer.poll()) != null) {
                Image image = Image.getInstance(bufferedImage, Color.WHITE);
                image.setAbsolutePosition(0.0f, 0.0f);
                image.scaleAbsolute(rectangle.getWidth(), rectangle.getHeight());
                image.setCompressionLevel(9);
                document.newPage();
                document.add(image);
                System.err.print('.');
                System.err.flush();
            }
            System.err.println(" done");
            object2 = object;
        }
        if (object2 != null) {
            imageProducer.finish();
            BufferedImage bufferedImage = imageProducer.poll();
            if (bufferedImage != null) {
                object = Image.getInstance(bufferedImage, Color.WHITE);
                ((Image)object).setAbsolutePosition(0.0f, 0.0f);
                ((Image)object).scaleAbsolute(rectangle.getWidth(), rectangle.getHeight());
                ((Image)object).setCompressionLevel(9);
                document.setPageSize(rectangle);
                document.newPage();
                document.add((Element)object);
            }
        }
        System.err.println("(100%) All done.");
        document.close();
    }
}

