/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.img2pdf;

import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ImageProducer {
    private final int maxBlankHeight = 36;
    private final float topMargin = 0.1f;
    private final float bottomMargin = 0.1f;
    private final float leftMargin = 0.075f;
    private final float rightMargin = 0.075f;
    private final float leftCropThreshold = 0.005f;
    private final float rightCropThreshold = 0.005f;
    private final float leftCropAdjustment = 0.002f;
    private final float rightCropAdjustment = 0.0035f;
    private final float lineSeparatorMinWidth = 0.4f;
    private final float lineSeparatorColorTolerance = 128.0f;
    private final float cropImbalanceLimit = 0.3f;
    private final float minSplitHeight = 0.6f;
    private final float splitOverlap = 0.035f;
    private final int whiteThreshold = 236;
    private final int coverPages = 2;
    private final boolean rotate = true;
    private final boolean debug = false;
    private static final IndexColorModel COLOR_MODEL;
    private final BufferedImage buf = ImageProducer.newImage(754, 584);
    private final Queue<BufferedImage> output = new LinkedList<BufferedImage>();
    private boolean processingCoverPage = true;
    private boolean finished;
    private int dstY = 0;
    private boolean wasBlank;
    private int offerCount = 0;

    private static BufferedImage newImage(int n, int n2) {
        return new BufferedImage(n, n2, 10);
    }

    public ImageProducer() {
        Graphics graphics = this.buf.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.buf.getWidth(), this.buf.getHeight());
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(BufferedImage bufferedImage) {
        if (this.finished) {
            throw new IllegalStateException();
        }
        if (this.processingCoverPage) {
            this.processingCoverPage = this.offerCount++ < 2;
        }
        bufferedImage = ImageProducer.grayscale(bufferedImage);
        bufferedImage = this.crop(bufferedImage);
        bufferedImage = ImageProducer.scale(bufferedImage, this.buf.getWidth());
        List<Chunk> list = this.decompose(bufferedImage);
        list = this.cropLargeBlanks(list);
        Graphics graphics = this.buf.getGraphics();
        try {
            block3: for (int i = 0; i < list.size(); ++i) {
                Chunk chunk = list.get(i);
                if (chunk.isBlank()) {
                    if (this.dstY == 0 && chunk.isBlank()) {
                        this.wasBlank = false;
                        continue;
                    }
                    if (this.wasBlank) continue;
                }
                this.wasBlank = chunk.isBlank();
                BufferedImage bufferedImage2 = chunk.getImage();
                int n = this.buf.getHeight() - this.dstY;
                int n2 = (this.buf.getWidth() - bufferedImage2.getWidth()) / 2;
                boolean bl = false;
                while (bufferedImage2.getHeight() > n) {
                    if (bl || (float)bufferedImage2.getHeight() > (float)this.buf.getHeight() * 0.6f || this.processingCoverPage) {
                        bl = true;
                        graphics.drawImage(bufferedImage2, n2, this.dstY, null);
                        int n3 = Math.min(n, (int)((float)this.buf.getHeight() * 0.035f));
                        bufferedImage2 = bufferedImage2.getSubimage(0, n - n3, bufferedImage2.getWidth(), bufferedImage2.getHeight() - n + n3);
                    }
                    BufferedImage bufferedImage3 = ImageProducer.newImage(this.buf.getWidth(), this.buf.getHeight());
                    Graphics graphics2 = bufferedImage3.getGraphics();
                    graphics2.drawImage(this.buf, 0, 0, null);
                    graphics2.dispose();
                    this.output.offer(bufferedImage3);
                    this.dstY = 0;
                    n = this.buf.getHeight();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, this.buf.getWidth(), this.buf.getHeight());
                    if (!chunk.isBlank()) continue;
                    continue block3;
                }
                graphics.drawImage(bufferedImage2, n2, this.dstY, null);
                this.dstY += bufferedImage2.getHeight();
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public void finish() {
        this.finished = true;
        if (this.dstY != 0) {
            this.output.offer(this.buf);
        }
    }

    public BufferedImage poll() {
        BufferedImage bufferedImage = this.output.poll();
        if (bufferedImage == null) {
            return null;
        }
        bufferedImage = ImageProducer.darken(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12, COLOR_MODEL);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        bufferedImage = bufferedImage2;
        bufferedImage = this.rotate(bufferedImage);
        return bufferedImage;
    }

    private static BufferedImage grayscale(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageProducer.newImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        int[] nArray = new int[bufferedImage.getWidth()];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            bufferedImage.getRGB(0, i, bufferedImage.getWidth(), 1, nArray, 0, nArray.length);
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n;
                int n2;
                int n3;
                int n4 = nArray[j];
                int n5 = (n4 & 0xFF000000) >>> 24;
                if (n5 == 255) {
                    n3 = (n4 & 0xFF0000) >>> 16;
                    n2 = (n4 & 0xFF00) >>> 8;
                    n = n4 & 0xFF;
                } else {
                    n3 = ((n4 & 0xFF0000) >>> 16) * n5 / 255 + 255 - n5;
                    n2 = ((n4 & 0xFF00) >>> 8) * n5 / 255 + 255 - n5;
                    n = (n4 & 0xFF) * n5 / 255 + 255 - n5;
                }
                int n6 = Math.min(255, (int)(Math.sqrt(0.241 * (double)n3 * (double)n3 + 0.691 * (double)n2 * (double)n2 + 0.068 * (double)n * (double)n) + 0.5));
                nArray[j] = (n6 << 8 | n6) << 8 | n6 | 0xFF000000;
            }
            bufferedImage2.setRGB(0, i, bufferedImage.getWidth(), 1, nArray, 0, nArray.length);
        }
        return bufferedImage2;
    }

    private BufferedImage crop(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        assert (bufferedImage.getType() == 10);
        int n9 = (int)((float)bufferedImage.getHeight() * 0.1f);
        int n10 = (int)((float)bufferedImage.getHeight() * 0.9f);
        int n11 = (int)((float)bufferedImage.getWidth() * 0.075f);
        int n12 = (int)((float)bufferedImage.getWidth() * 0.925f);
        float f = bufferedImage.getHeight();
        this.getClass();
        int n13 = (int)(f * 0.005f);
        float f2 = bufferedImage.getHeight();
        this.getClass();
        int n14 = (int)(f2 * 0.005f);
        int n15 = (int)((float)bufferedImage.getWidth() * 0.4f);
        block0: for (n8 = n11; n8 < n12; ++n8) {
            n7 = 0;
            for (n6 = n9; n6 < n10; ++n6) {
                if (this.isWhite(bufferedImage.getRGB(n8, n6))) continue;
                n5 = 0;
                if (!this.processingCoverPage) {
                    n4 = bufferedImage.getRGB(n8, n6) & 0xFF;
                    for (n3 = n8; n3 < bufferedImage.getWidth() && !((float)Math.abs(n4 - (n2 = bufferedImage.getRGB(n3, n6) & 0xFF)) > 128.0f) && ++n5 < n15; ++n3) {
                    }
                }
                if (n5 < n15 && ++n7 == n13) break block0;
            }
        }
        block3: for (n = n12 - 1; n >= n11; --n) {
            n7 = 0;
            for (n6 = n9; n6 < n10; ++n6) {
                if (this.isWhite(bufferedImage.getRGB(n, n6))) continue;
                n5 = 0;
                if (!this.processingCoverPage) {
                    n4 = bufferedImage.getRGB(n, n6) & 0xFF;
                    for (n3 = n; n3 >= 0 && !((float)Math.abs(n4 - (n2 = bufferedImage.getRGB(n3, n6) & 0xFF)) > 128.0f) && ++n5 < n15; --n3) {
                    }
                }
                if (n5 < n15 && ++n7 == n14) break block3;
            }
        }
        if ((n8 = Math.max(n8 - (int)((float)bufferedImage.getWidth() * 0.002f), 0)) >= (n = Math.min(n + (int)((float)bufferedImage.getWidth() * 0.0035f), bufferedImage.getWidth() - 1))) {
            return bufferedImage;
        }
        n6 = n8;
        n5 = bufferedImage.getWidth() - n - 1;
        if ((float)Math.abs(n6 - n5) > (float)bufferedImage.getWidth() * 0.3f) {
            if (n6 > n5) {
                n8 = n5 + (int)((float)bufferedImage.getWidth() * 0.3f);
            } else {
                n = bufferedImage.getWidth() - (n6 + (int)((float)bufferedImage.getWidth() * 0.3f)) - 1;
            }
            n8 = Math.max(n8, 0);
            n = Math.min(n, bufferedImage.getWidth() - 1);
        }
        return bufferedImage.getSubimage(n8, 0, n - n8 + 1, bufferedImage.getHeight());
    }

    private static BufferedImage scale(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        if (n2 <= n) {
            return bufferedImage;
        }
        int n3 = bufferedImage.getHeight() * n / n2;
        if (n3 == 0) {
            return bufferedImage;
        }
        ResampleOp resampleOp = new ResampleOp(n, n3);
        resampleOp.setFilter(ResampleFilters.getLanczos3Filter());
        return resampleOp.filter(bufferedImage, null);
    }

    private BufferedImage rotate(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = ImageProducer.newImage(bufferedImage.getHeight(), bufferedImage.getWidth());
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                bufferedImage2.setRGB(j, bufferedImage.getWidth() - i - 1, bufferedImage.getRGB(i, j));
            }
        }
        return bufferedImage2;
    }

    private static BufferedImage darken(BufferedImage bufferedImage) {
        assert (bufferedImage.getType() == 10);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n = bufferedImage.getRGB(j, i) & 0xFF;
                n = n * n / 255;
                bufferedImage.setRGB(j, i, (n << 8 | n) << 8 | n | 0xFF000000);
            }
        }
        return bufferedImage;
    }

    private List<Chunk> decompose(BufferedImage bufferedImage) {
        int n;
        assert (bufferedImage.getType() == 10);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n2 = 1;
        for (n = 0; n < bufferedImage.getWidth(); n += 1) {
            if (this.isWhite(bufferedImage.getRGB(n, 0))) continue;
            n2 = 0;
            break;
        }
        n = n2;
        int n3 = 0;
        for (int i = 1; i < bufferedImage.getHeight(); ++i) {
            boolean bl = true;
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                if (this.isWhite(bufferedImage.getRGB(j, i))) continue;
                bl = false;
                break;
            }
            if (n) {
                if (bl) continue;
                arrayList.add(new Chunk(bufferedImage.getSubimage(0, n3, bufferedImage.getWidth(), i - n3), true));
                n3 = i;
                n = 0;
                continue;
            }
            if (!bl) continue;
            arrayList.add(new Chunk(bufferedImage.getSubimage(0, n3, bufferedImage.getWidth(), i - n3), false));
            n3 = i;
            n = 1;
        }
        arrayList.add(new Chunk(bufferedImage.getSubimage(0, n3, bufferedImage.getWidth(), bufferedImage.getHeight() - n3), n != 0));
        return arrayList;
    }

    private List<Chunk> cropLargeBlanks(Iterable<Chunk> iterable) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Chunk chunk : iterable) {
            if (chunk.isBlank() && chunk.getImage().getHeight() > 36) {
                chunk = new Chunk(chunk.getImage().getSubimage(0, 0, chunk.getImage().getWidth(), 36), true);
            }
            arrayList.add(chunk);
        }
        return arrayList;
    }

    private boolean isWhite(int n) {
        return (n & 0xFF) > 236;
    }

    static {
        byte[] byArray = new byte[16];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i * 17);
        }
        COLOR_MODEL = new IndexColorModel(4, byArray.length, byArray, byArray, byArray);
    }

    private static class Chunk {
        private final BufferedImage image;
        private final boolean blank;

        Chunk(BufferedImage bufferedImage, boolean bl) {
            this.image = bufferedImage;
            this.blank = bl;
        }

        BufferedImage getImage() {
            return this.image;
        }

        boolean isBlank() {
            return this.blank;
        }
    }
}

