/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.imageio.pnm;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

class PortableAnymapImageReader
extends ImageReader {
    static final int TYPE_PBM_ASCII = 20529;
    static final int TYPE_PGM_ASCII = 20530;
    static final int TYPE_PPM_ASCII = 20531;
    static final int TYPE_PBM_RAW = 20532;
    static final int TYPE_PGM_RAW = 20533;
    static final int TYPE_PPM_RAW = 20534;
    private BufferedImage image;

    protected PortableAnymapImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        PortableAnymapImageReader.checkIndex(n);
        return this.read((ImageInputStream)this.getInput());
    }

    @Override
    public int getHeight(int n) throws IOException {
        PortableAnymapImageReader.checkIndex(n);
        return this.read((ImageInputStream)this.getInput()).getHeight();
    }

    @Override
    public int getWidth(int n) throws IOException {
        PortableAnymapImageReader.checkIndex(n);
        return this.read((ImageInputStream)this.getInput()).getWidth();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        PortableAnymapImageReader.checkIndex(n);
        return Collections.singletonList(ImageTypeSpecifier.createFromBufferedImageType(this.read((ImageInputStream)this.getInput()).getType())).iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        PortableAnymapImageReader.checkIndex(n);
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    private static void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("A PNM file contains only one image.");
        }
    }

    private BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        if (this.image != null) {
            return this.image;
        }
        int n = imageInputStream.readShort() & 0xFFFF;
        switch (n) {
            case 20529: 
            case 20530: 
            case 20531: {
                throw new IOException("An ASCII PNM format is not supported: 0x" + Integer.toHexString(n));
            }
            case 20532: {
                int n2 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                int n3 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                boolean bl = true;
                byte[] byArray = new byte[n2 * n3 >> 3];
                imageInputStream.readFully(byArray);
                this.image = PortableAnymapImageReader.readBitmap(n2, n3, byArray);
                return this.image;
            }
            case 20533: {
                int n4 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                int n5 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                int n6 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                byte[] byArray = new byte[n4 * n5];
                imageInputStream.readFully(byArray);
                this.image = PortableAnymapImageReader.readGraymap(n4, n5, n6, byArray);
                return this.image;
            }
            case 20534: {
                int n7 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                int n8 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                int n9 = PortableAnymapImageReader.readAsciiInt(imageInputStream);
                byte[] byArray = new byte[n7 * n8 * 3];
                imageInputStream.readFully(byArray);
                this.image = PortableAnymapImageReader.readPixmap(n7, n8, n9, byArray);
                return this.image;
            }
        }
        throw new IOException("Unknown PNM format: " + Integer.toHexString(n));
    }

    private static BufferedImage readPixmap(int n, int n2, int n3, byte[] byArray) {
        BufferedImage bufferedImage;
        if (n3 < 256) {
            bufferedImage = new BufferedImage(n, n2, 1);
            int n4 = 0;
            if (n3 == 255) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 + 3 < byArray.length; ++j) {
                        int n5 = byArray[n4++] & 0xFF;
                        int n6 = byArray[n4++] & 0xFF;
                        int n7 = byArray[n4++] & 0xFF;
                        int n8 = -16777216 + (n5 << 16) + (n6 << 8) + n7;
                        bufferedImage.setRGB(j, i, n8);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 + 3 < byArray.length; ++j) {
                        int n9 = byArray[n4++] & 0xFF;
                        n9 = (n9 * 255 + (n3 >> 1)) / n3;
                        int n10 = byArray[n4++] & 0xFF;
                        n10 = (n10 * 255 + (n3 >> 1)) / n3;
                        int n11 = byArray[n4++] & 0xFF;
                        n11 = (n11 * 255 + (n3 >> 1)) / n3;
                        int n12 = -16777216 + (n9 << 16) + (n10 << 8) + n11;
                        bufferedImage.setRGB(j, i, n12);
                    }
                }
            }
        } else {
            bufferedImage = new BufferedImage(n, n2, 1);
            int n13 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n && n13 + 6 < byArray.length; ++j) {
                    int n14 = byArray[n13++] & 0xFF | (byArray[n13++] & 0xFF) << 8;
                    n14 = (n14 * 255 + (n3 >> 1)) / n3;
                    int n15 = byArray[n13++] & 0xFF | (byArray[n13++] & 0xFF) << 8;
                    n15 = (n15 * 255 + (n3 >> 1)) / n3;
                    int n16 = byArray[n13++] & 0xFF | (byArray[n13++] & 0xFF) << 8;
                    n16 = (n16 * 255 + (n3 >> 1)) / n3;
                    int n17 = -16777216 + (n14 << 16) + (n15 << 8) + n16;
                    bufferedImage.setRGB(j, i, n17);
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage readGraymap(int n, int n2, int n3, byte[] byArray) {
        BufferedImage bufferedImage;
        if (n3 < 256) {
            bufferedImage = new BufferedImage(n, n2, 10);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n4 = 0;
            if (n3 == 255) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 < byArray.length; ++j) {
                        writableRaster.setSample(j, i, 0, byArray[n4++] & 0xFF);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n4 < byArray.length; ++j) {
                        int n5 = ((byArray[n4++] & 0xFF) * 255 + (n3 >> 1)) / n3;
                        writableRaster.setSample(j, i, 0, n5);
                    }
                }
            }
        } else {
            bufferedImage = new BufferedImage(n, n2, 11);
            WritableRaster writableRaster = bufferedImage.getRaster();
            int n6 = 0;
            if (n3 == 65535) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n6 < byArray.length - 1; ++j) {
                        int n7 = byArray[n6++] & 0xFF | (byArray[n6++] & 0xFF) << 8;
                        writableRaster.setSample(j, i, 0, n7);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && n6 < byArray.length - 1; ++j) {
                        int n8 = byArray[n6++] & 0xFF | (byArray[n6++] & 0xFF) << 8;
                        int n9 = (n8 * 65535 + (n3 >> 1)) / n3;
                        writableRaster.setSample(j, i, 0, n9);
                    }
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage readBitmap(int n, int n2, byte[] byArray) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 12);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = 0;
        int n4 = n % 8 == 0 ? n >> 3 : n + 8 >> 3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4 && n3 < byArray.length; ++j) {
                byte by = byArray[n3++];
                for (int k = 0; k < 8; ++k) {
                    int n5 = (j << 3) + 7 - k;
                    if (n5 >= n) continue;
                    int n6 = (by & 1 << k) == 0 ? -1 : -16777216;
                    writableRaster.setSample(n5, i, 0, n6);
                }
            }
        }
        return bufferedImage;
    }

    private static char readAsciiChar(ImageInputStream imageInputStream) throws IOException {
        char c;
        do {
            if ((c = (char)imageInputStream.read()) != '#') continue;
            while ((c = (char)imageInputStream.read()) != '\n' && c != '\r') {
            }
        } while (c == ' ' || c == '\t' || c == '\n' || c == '\r');
        return c;
    }

    private static int readAsciiInt(ImageInputStream imageInputStream) throws IOException {
        char c = PortableAnymapImageReader.readAsciiChar(imageInputStream);
        if (c < '0' || '9' < c) {
            throw new IOException("Unexpected character in the PNM file.");
        }
        int n = 0;
        do {
            n = n * 10 + c - 48;
        } while ('0' <= (c = (char)imageInputStream.read()) && c <= '9');
        return n;
    }
}

