/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling.experimental;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.awt.image.BufferedImage;
import java.util.BitSet;

public class ResampleOpSingleThread
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private int totalItems;
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOpSingleThread(int destWidth, int destHeight) {
        super(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ResampleOpSingleThread(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter) {
        this.filter = filter;
    }

    public BufferedImage doFilter(BufferedImage srcImg, BufferedImage dest, int dstWidth, int dstHeight) {
        int i;
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        if (srcImg.getType() == 12 || srcImg.getType() == 13) {
            srcImg = ImageUtils.convert(srcImg, srcImg.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(srcImg);
        assert (this.nrChannels > 0);
        this.srcWidth = srcImg.getWidth();
        this.srcHeight = srcImg.getHeight();
        this.processedItems = 0;
        this.totalItems = this.srcHeight;
        this.horizontalSubsamplingData = this.createSubSampling(this.srcWidth, dstWidth);
        this.verticalSubsamplingData = this.createSubSampling(this.srcHeight, dstHeight);
        int bufferHeight = (int)Math.ceil(this.verticalSubsamplingData.width) * 2;
        byte[][] workPixels = new byte[this.srcHeight][];
        for (i = 0; i < bufferHeight && i < this.srcHeight; ++i) {
            workPixels[i] = new byte[dstWidth * this.nrChannels];
        }
        for (i = bufferHeight; i < workPixels.length; ++i) {
            workPixels[i] = workPixels[i % bufferHeight];
        }
        byte[][] workPixelsCopy = workPixels;
        BufferedImage out = dest != null && dstWidth == dest.getWidth() && dstHeight == dest.getHeight() ? dest : new BufferedImage(dstWidth, dstHeight, this.getResultBufferedImageType(srcImg));
        this.scale(srcImg, workPixelsCopy, out);
        return out;
    }

    private SubSamplingData createSubSampling(int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float width;
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = this.filter.getSamplingRadius();
        if (scale < 1.0f) {
            width = fwidth / scale;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * numContributors;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                assert (right - left <= numContributors);
                for (int j = left; j <= right; ++j) {
                    float weight = this.filter.apply((center - (float)j) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k2 = arrN[i];
                    int n2 = i;
                    arrN[n2] = arrN[n2] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k2] = n;
                    arrWeight[subindex + k2] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        } else {
            width = fwidth;
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i = 0; i < dstSize; ++i) {
                int k;
                int subindex = i * numContributors;
                float center = (float)i / scale;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j = left; j <= right; ++j) {
                    float weight = this.filter.apply(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                    int k3 = arrN[i];
                    int n3 = i;
                    arrN[n3] = arrN[n3] + 1;
                    if (n < 0 || n >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k3] = n;
                    arrWeight[subindex + k3] = weight;
                }
                int max = arrN[i];
                float tot = 0.0f;
                for (k = 0; k < max; ++k) {
                    tot += arrWeight[subindex + k];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k = 0; k < max; ++k) {
                    int n = subindex + k;
                    arrWeight[n] = arrWeight[n] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors, width);
    }

    private void scale(BufferedImage srcImg, byte[][] workPixels, BufferedImage outImage) {
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth * this.nrChannels];
        byte[] dstPixels = new byte[this.dstWidth * this.nrChannels];
        BitSet isRowInitialized = new BitSet(this.srcHeight);
        for (int dstY = this.dstHeight - 1; dstY >= 0; --dstY) {
            int channel;
            int yTimesNumContributors = dstY * this.verticalSubsamplingData.numContributors;
            int max = this.verticalSubsamplingData.arrN[dstY];
            int index = yTimesNumContributors;
            for (int j = max - 1; j >= 0; --j) {
                int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                ++index;
                if (isRowInitialized.get(valueLocation)) continue;
                isRowInitialized.set(valueLocation);
                ImageUtils.getPixelsBGR(srcImg, valueLocation, this.srcWidth, srcPixels, tempPixels);
                for (channel = this.nrChannels - 1; channel >= 0; --channel) {
                    this.getSamplesHorizontal(srcPixels, channel, tempPixels);
                    for (int i = this.dstWidth - 1; i >= 0; --i) {
                        int sampleLocation = i * this.nrChannels;
                        int horizontalMax = this.horizontalSubsamplingData.arrN[i];
                        float sample = 0.0f;
                        int horizontalIndex = i * this.horizontalSubsamplingData.numContributors;
                        for (int jj = horizontalMax - 1; jj >= 0; --jj) {
                            sample += (float)tempPixels[this.horizontalSubsamplingData.arrPixel[horizontalIndex]] * this.horizontalSubsamplingData.arrWeight[horizontalIndex];
                            ++horizontalIndex;
                        }
                        this.putSample(workPixels[valueLocation], channel, (int)sample, sampleLocation);
                    }
                }
            }
            for (int x = 0; x < this.dstWidth; ++x) {
                int xLocation = x * this.nrChannels;
                int sampleLocation = x * this.nrChannels;
                for (channel = this.nrChannels - 1; channel >= 0; --channel) {
                    float sample = 0.0f;
                    int index2 = yTimesNumContributors;
                    for (int j = max - 1; j >= 0; --j) {
                        int valueLocation = this.verticalSubsamplingData.arrPixel[index2];
                        sample += (float)(workPixels[valueLocation][xLocation + channel] & 0xFF) * this.verticalSubsamplingData.arrWeight[index2];
                        ++index2;
                    }
                    this.putSample(dstPixels, channel, sample, sampleLocation);
                }
            }
            ImageUtils.setBGRPixels(dstPixels, outImage, 0, dstY, this.dstWidth, 1);
            this.setProgress(this.processedItems++, this.totalItems);
        }
    }

    private void putSample(byte[] image, int channel, float sample, int location) {
        int result = (int)sample;
        if (sample < 0.0f) {
            result = 0;
        } else if (result > 255) {
            result = 255;
        }
        image[location + channel] = (byte)result;
    }

    private void getSamplesHorizontal(byte[] src, int channel, int[] dest) {
        int xDest = 0;
        int x = channel;
        while (x < src.length) {
            dest[xDest] = src[x] & 0xFF;
            x += this.nrChannels;
            ++xDest;
        }
    }

    private void setProgress(int zeroBasedIndex, int totalItems) {
        this.fireProgressChanged((float)zeroBasedIndex / (float)totalItems);
    }

    protected int getResultBufferedImageType(BufferedImage srcImg) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (srcImg.getSampleModel().getDataType() == 1 ? 11 : 10));
    }

    private class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final float[] arrWeight;
        private final int numContributors;
        private final float width;

        private SubSamplingData(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors, float width) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
            this.width = width;
        }
    }
}

