#!/bin/sh

# Version 0.01 (20090724) ebs
V="0.01"

# Default timeout in seconds
TIMEOUT=3600

L=/mnt/us/screensaver-timeout_install.log

# Result codes
OK=0
ERR=1

echo >> $L
echo "install: screensaver-timeout v$V, `date`" >> $L

# Give user a way to override timeout
U=/mnt/us/screensaver-timeout
if [ -f $U ]; then
	T=`cat $U | head -n 1 | sed 's/[^0-9]//g'`
	if [ "$T" -gt 59 ]; then
		echo "Using user specified timeout $T from $U" >> $L
		TIMEOUT=$T
	fi
fi

F=/etc/powerd.conf

# Make a backup just in case
[ -f $F.orig ] || cp -p $F $F.orig 2>> $L || exit $ERR

K="t1_timeout:"
OT=`grep "^$K" $F | cut -b 13-`
if [ -n "$OT" ]; then
	if [ "$OT" != "$TIMEOUT" ]; then
		echo "Replacing sleep timeout ($OT -> $TIMEOUT)" >> $L
		sed -i -e "s/^\($K\).*$/\1 $TIMEOUT/" $F 2>> $L || exit $ERR
	else
		echo "Timeout is already set to $TIMEOUT, skipping..." >> $L
	fi
else
	echo "Addding sleep timeout ($TIMEOUT)" >> $L
	(echo "$K $TIMEOUT" >> $F) 2>> $L || exit $ERR
fi

echo "Done!" >> $L
exit $OK
